/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.users;

import com.bes.enterprise.appserver.common.security.FileRealmHelper;
import com.bes.enterprise.appserver.common.security.SSHA;
import com.bes.enterprise.appserver.common.security.Utility;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.codec.binary.Base64;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Group;
import com.bes.enterprise.webtier.Role;
import com.bes.enterprise.webtier.User;
import com.bes.enterprise.webtier.UserDatabase;
import com.bes.enterprise.webtier.users.MemoryGroup;
import com.bes.enterprise.webtier.users.MemoryRole;
import com.bes.enterprise.webtier.users.MemoryUser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class MemoryUserDatabase
implements UserDatabase {
    private static final Log log = LogFactory.getLog(MemoryUserDatabase.class);
    private static final StringManager sm = StringManager.getManager(MemoryUserDatabase.class);
    protected final Map<String, Group> groups = new ConcurrentHashMap<String, Group>();
    protected final String id;
    protected String pathname = "conf/appServer-users.xml";
    protected String pathnameOld = this.pathname + ".old";
    protected String pathnameNew = this.pathname + ".new";
    protected boolean readonly = true;
    protected final Map<String, Role> roles = new ConcurrentHashMap<String, Role>();
    protected final Map<String, User> users = new ConcurrentHashMap<String, User>();
    private final ReentrantReadWriteLock dbLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.dbLock.readLock();
    private final Lock writeLock = this.dbLock.writeLock();
    private volatile long lastModified = 0L;
    private boolean watchSource = true;

    public MemoryUserDatabase() {
        this(null);
    }

    public MemoryUserDatabase(String id) {
        this.id = id;
    }

    @Override
    public Iterator<Group> getGroups() {
        this.checkOpen();
        this.readLock.lock();
        try {
            Iterator<Group> iterator = new ArrayList<Group>(this.groups.values()).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
        this.pathnameOld = pathname + ".old";
        this.pathnameNew = pathname + ".new";
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean getWatchSource() {
        return this.watchSource;
    }

    public void setWatchSource(boolean watchSource) {
        this.watchSource = watchSource;
    }

    @Override
    public Iterator<Role> getRoles() {
        this.checkOpen();
        this.readLock.lock();
        try {
            Iterator<Role> iterator = new ArrayList<Role>(this.roles.values()).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Iterator<User> getUsers() {
        this.checkOpen();
        this.readLock.lock();
        try {
            Iterator<User> iterator = new ArrayList<User>(this.users.values()).iterator();
            return iterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
        this.writeLock.lock();
        try {
            this.save();
            this.users.clear();
            this.groups.clear();
            this.roles.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String groupname, String description) {
        if (groupname == null || groupname.length() == 0) {
            String msg = sm.getString("memoryUserDatabase.nullGroup");
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        MemoryGroup group = new MemoryGroup(this, groupname, description);
        this.readLock.lock();
        try {
            this.groups.put(group.getGroupname(), group);
        }
        finally {
            this.readLock.unlock();
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role createRole(String rolename, String description) {
        if (rolename == null || rolename.length() == 0) {
            String msg = sm.getString("memoryUserDatabase.nullRole");
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        MemoryRole role = new MemoryRole(this, rolename, description);
        this.readLock.lock();
        try {
            this.roles.put(role.getRolename(), role);
        }
        finally {
            this.readLock.unlock();
        }
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String username, String password, String fullName) {
        if (username == null || username.length() == 0) {
            String msg = sm.getString("memoryUserDatabase.nullUser");
            log.warn(msg);
            throw new IllegalArgumentException(msg);
        }
        MemoryUser user = new MemoryUser(this, username, password, fullName);
        this.readLock.lock();
        try {
            this.users.put(user.getUsername(), user);
        }
        finally {
            this.readLock.unlock();
        }
        return user;
    }

    @Override
    public Group findGroup(String groupname) {
        this.checkOpen();
        this.readLock.lock();
        try {
            Group group = this.groups.get(groupname);
            return group;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Role findRole(String rolename) {
        this.checkOpen();
        this.readLock.lock();
        try {
            Role role = this.roles.get(rolename);
            return role;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public User findUser(String username) {
        this.checkOpen();
        this.readLock.lock();
        try {
            User user = this.users.get(username);
            return user;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws Exception {
        this.writeLock.lock();
        try {
            this.users.clear();
            this.groups.clear();
            this.roles.clear();
            String pathName = this.getPathname();
            this.lastModified = new File(pathName).lastModified();
            try {
                FileRealmHelper helper = new FileRealmHelper("admin-realm", pathName);
                Set<String> usernames = helper.getUserNames();
                for (String username : usernames) {
                    String[] groupStrs;
                    byte[] salt = helper.getUser(username).getSalt();
                    String encodeToString = Base64.encodeBase64String(salt);
                    MemoryUser user = (MemoryUser)this.createUser(username, encodeToString, null);
                    user.setAlgo(helper.getUser(username).getAlgo());
                    user.setHash(helper.getUser(username).getHash());
                    user.setSalt(salt);
                    for (String group : groupStrs = helper.getGroupNames(username)) {
                        Group grp = this.createGroup(group, null);
                        user.addGroup(grp);
                        this.groups.put(group, grp);
                    }
                    this.users.put(username, user);
                }
            }
            catch (IOException ioe) {
                log.error(sm.getString("memoryUserDatabase.fileNotFound", pathName));
            }
            catch (Exception e2) {
                this.users.clear();
                this.groups.clear();
                this.roles.clear();
                throw e2;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(Group group) {
        this.readLock.lock();
        try {
            Iterator<User> users = this.getUsers();
            while (users.hasNext()) {
                User user = users.next();
                user.removeGroup(group);
            }
            this.groups.remove(group.getGroupname());
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        this.readLock.lock();
        try {
            Iterator<Group> groups = this.getGroups();
            while (groups.hasNext()) {
                Group group = groups.next();
                group.removeRole(role);
            }
            Iterator<User> users = this.getUsers();
            while (users.hasNext()) {
                User user = users.next();
                user.removeRole(role);
            }
            this.roles.remove(role.getRolename());
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeUser(User user) {
        this.readLock.lock();
        try {
            this.users.remove(user.getUsername());
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isWriteable() {
        File dir;
        File file = new File(this.pathname);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("bes.base"), this.pathname);
        }
        return (dir = file.getParentFile()).exists() && dir.isDirectory() && dir.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() throws Exception {
        if (this.getReadonly()) {
            log.error(sm.getString("memoryUserDatabase.readOnly"));
            return;
        }
        if (!this.isWriteable()) {
            log.warn(sm.getString("memoryUserDatabase.notPersistable"));
            return;
        }
        File fileNew = new File(this.pathnameNew);
        if (!fileNew.isAbsolute()) {
            fileNew = new File(System.getProperty("bes.base"), this.pathnameNew);
        }
        this.writeLock.lock();
        try {
            try (FileOutputStream fos = new FileOutputStream(fileNew);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
                 PrintWriter writer = new PrintWriter(osw);){
                writer.println("<?xml version='1.0' encoding='utf-8'?>");
                writer.println("<appServer-users xmlns=\"http://appServer.apache.org/xml\"");
                writer.print("              ");
                writer.println("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                writer.print("              ");
                writer.println("xsi:schemaLocation=\"http://appServer.apache.org/xml appServer-users.xsd\"");
                writer.println("              version=\"1.0\">");
                Iterator<Principal> values = null;
                values = this.getRoles();
                while (values.hasNext()) {
                    writer.print("  ");
                    writer.println(values.next());
                }
                values = this.getGroups();
                while (values.hasNext()) {
                    writer.print("  ");
                    writer.println(values.next());
                }
                values = this.getUsers();
                while (values.hasNext()) {
                    writer.print("  ");
                    writer.println(((MemoryUser)values.next()).toXml());
                }
                writer.println("</appServer-users>");
                if (writer.checkError()) {
                    throw new IOException(sm.getString("memoryUserDatabase.writeException", fileNew.getAbsolutePath()));
                }
            }
            catch (IOException e2) {
                if (fileNew.exists() && !fileNew.delete()) {
                    log.warn(sm.getString("memoryUserDatabase.fileDelete", fileNew));
                }
                throw e2;
            }
            this.lastModified = fileNew.lastModified();
        }
        finally {
            this.writeLock.unlock();
        }
        File fileOld = new File(this.pathnameOld);
        if (!fileOld.isAbsolute()) {
            fileOld = new File(System.getProperty("bes.base"), this.pathnameOld);
        }
        if (fileOld.exists() && !fileOld.delete()) {
            throw new IOException(sm.getString("memoryUserDatabase.fileDelete", fileOld));
        }
        File fileOrig = new File(this.pathname);
        if (!fileOrig.isAbsolute()) {
            fileOrig = new File(System.getProperty("bes.base"), this.pathname);
        }
        if (fileOrig.exists() && !fileOrig.renameTo(fileOld)) {
            throw new IOException(sm.getString("memoryUserDatabase.renameOld", fileOld.getAbsolutePath()));
        }
        if (!fileNew.renameTo(fileOrig)) {
            if (fileOld.exists() && !fileOld.renameTo(fileOrig)) {
                log.warn(sm.getString("memoryUserDatabase.restoreOrig", fileOld));
            }
            throw new IOException(sm.getString("memoryUserDatabase.renameNew", fileOrig.getAbsolutePath()));
        }
        if (fileOld.exists() && !fileOld.delete()) {
            throw new IOException(sm.getString("memoryUserDatabase.fileDelete", fileOld));
        }
    }

    public void backgroundProcess() {
        if (!this.watchSource) {
            return;
        }
        this.checkOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpen() {
        block6: {
            File file = new File(this.getPathname());
            try {
                if (this.lastModified == file.lastModified()) break block6;
                this.writeLock.lock();
                try {
                    long detectedLastModified = file.lastModified();
                    if (this.lastModified != detectedLastModified && detectedLastModified + 2000L < System.currentTimeMillis()) {
                        log.debug(sm.getString("memoryUserDatabase.reload", this.id, this.getPathname()));
                        this.open();
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
            }
            catch (Exception ioe) {
                log.error(sm.getString("memoryUserDatabase.reloadError", this.id, this.getPathname()), ioe);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MemoryUserDatabase[id=");
        sb.append(this.id);
        sb.append(",pathname=");
        sb.append(this.pathname);
        sb.append(",groupCount=");
        sb.append(this.groups.size());
        sb.append(",roleCount=");
        sb.append(this.roles.size());
        sb.append(",userCount=");
        sb.append(this.users.size());
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean authenticate(String username, String credentials) {
        MemoryUser user = (MemoryUser)this.findUser(username);
        boolean ok = false;
        try {
            ok = SSHA.verify(user.getSalt(), user.getHash(), Utility.convertCharArrayToByteArray(credentials.toCharArray(), Charset.defaultCharset().displayName()), user.getAlgo());
        }
        catch (Exception e2) {
            return false;
        }
        return ok;
    }
}

