/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util;

import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.SystemPropertyValueTranslator;
import com.bes.enterprise.config.provider.ConfigProviderGlobals;
import java.io.File;
import java.util.List;

public class DeploymentContextUtils {
    public static DomTemplate getWebModule(String webModuleName) {
        DomTemplate serverBean = DeploymentContextUtils.getServer();
        if (serverBean == null) {
            return null;
        }
        DomTemplate result = null;
        List<DomTemplate> applications = serverBean.getElements("applications");
        if (applications != null) {
            block0: for (DomTemplate app : applications) {
                List<DomTemplate> webModules = app.getElements("web-module");
                if (webModules == null) continue;
                for (DomTemplate module : webModules) {
                    String moduleName = module.getAttribute("name");
                    if (!StringUtils.ok(moduleName) || !moduleName.equals(webModuleName)) continue;
                    result = module;
                    continue block0;
                }
            }
        }
        return result;
    }

    public static File getApplicationLocation() {
        File file;
        DomTemplate serverBean = DeploymentContextUtils.getServer();
        if (serverBean == null) {
            return null;
        }
        String result = "${com.bes.instanceRoot}/deployments";
        DomTemplate applications = serverBean.getElement("applications");
        if (applications != null && !StringUtils.isBlank(applications.getAttribute("location"))) {
            result = applications.getAttribute("location");
        }
        if (!(file = new File(result = SystemPropertyValueTranslator.getInstance().getTranslatedValue(result))).exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static DomTemplate getWebModuleSessionManager(String webModuleName) {
        DomTemplate webModule = DeploymentContextUtils.getWebModule(webModuleName);
        if (webModule == null) {
            return null;
        }
        String managerName = webModule.getAttribute("session-manager");
        return DeploymentContextUtils.getSessionManager(managerName);
    }

    public static DomTemplate getHotDeployConfig() {
        DomTemplate serverBean = DeploymentContextUtils.getServer();
        if (serverBean == null) {
            return null;
        }
        return serverBean.getElement("hotdeploy-config");
    }

    public static DomTemplate getVirtualServer(String virtualServer) {
        DomTemplate webContainer = DeploymentContextUtils.getWebContainer();
        if (webContainer == null) {
            return null;
        }
        DomTemplate vs = null;
        List<DomTemplate> virtualServers = webContainer.getElements("virtual-server");
        if (virtualServers != null) {
            for (DomTemplate v2 : virtualServers) {
                String name = v2.getAttribute("name");
                if (!StringUtils.ok(name) || !name.equals(virtualServer)) continue;
                vs = v2;
                break;
            }
        }
        return vs;
    }

    public static DomTemplate getSessionManager(String sessionManager) {
        DomTemplate webContainer = DeploymentContextUtils.getWebContainer();
        if (webContainer == null) {
            return null;
        }
        DomTemplate sm = null;
        DomTemplate managers = webContainer.getElement("session-managers");
        List<DomTemplate> sessionManagers = managers.getElements("session-manager");
        if (sessionManagers != null) {
            for (DomTemplate m2 : sessionManagers) {
                String name = m2.getAttribute("name");
                if (!StringUtils.ok(name) || !name.equals(sessionManager)) continue;
                sm = m2;
            }
        }
        return sm;
    }

    private static DomTemplate getWebContainer() {
        DomTemplate server = DeploymentContextUtils.getServer();
        if (server == null) {
            return null;
        }
        return server.getElement("web-container");
    }

    private static DomTemplate getServer() {
        DomTemplate server = (DomTemplate)ConfigProviderGlobals.getGlobalItem("rootConfig");
        return server;
    }
}

