/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.Lifecycle;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.LifecycleState;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class LifecycleBase
implements Lifecycle {
    private static final Log log = LogFactory.getLog(LifecycleBase.class);
    private static final StringManager sm = StringManager.getManager(LifecycleBase.class);
    private final List<LifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<LifecycleListener>();
    private volatile LifecycleState state = LifecycleState.NEW;
    private boolean throwOnFailure = true;

    public boolean getThrowOnFailure() {
        return this.throwOnFailure;
    }

    public void setThrowOnFailure(boolean throwOnFailure) {
        this.throwOnFailure = throwOnFailure;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycleListeners.toArray(new LifecycleListener[0]);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycleListeners.remove(listener);
    }

    protected void fireLifecycleEvent(String type, Object data) {
        LifecycleEvent event = new LifecycleEvent(this, type, data);
        for (LifecycleListener listener : this.lifecycleListeners) {
            listener.lifecycleEvent(event);
        }
    }

    @Override
    public final synchronized void init() throws LifecycleException {
        if (!this.state.equals((Object)LifecycleState.NEW)) {
            this.invalidTransition("before_init");
        }
        try {
            this.setStateInternal(LifecycleState.INITIALIZING, null, false);
            this.initInternal();
            this.setStateInternal(LifecycleState.INITIALIZED, null, false);
        }
        catch (Throwable t2) {
            this.handleSubClassException(t2, "lifecycleBase.initFail", this.toString());
        }
    }

    protected abstract void initInternal() throws LifecycleException;

    @Override
    public final synchronized void start() throws LifecycleException {
        if (LifecycleState.STARTING_PREP.equals((Object)this.state) || LifecycleState.STARTING.equals((Object)this.state) || LifecycleState.STARTED.equals((Object)this.state)) {
            if (log.isDebugEnabled()) {
                LifecycleException e2 = new LifecycleException();
                log.debug(sm.getString("lifecycleBase.alreadyStarted", this.toString()), e2);
            } else if (log.isInfoEnabled()) {
                log.info(sm.getString("lifecycleBase.alreadyStarted", this.toString()));
            }
            return;
        }
        if (this.state.equals((Object)LifecycleState.NEW)) {
            this.init();
        } else if (this.state.equals((Object)LifecycleState.FAILED)) {
            this.stop();
        } else if (!this.state.equals((Object)LifecycleState.INITIALIZED) && !this.state.equals((Object)LifecycleState.STOPPED)) {
            this.invalidTransition("before_start");
        }
        try {
            this.setStateInternal(LifecycleState.STARTING_PREP, null, false);
            this.startInternal();
            if (this.state.equals((Object)LifecycleState.FAILED)) {
                this.stop();
            } else if (!this.state.equals((Object)LifecycleState.STARTING)) {
                this.invalidTransition("after_start");
            } else {
                this.setStateInternal(LifecycleState.STARTED, null, false);
            }
        }
        catch (Throwable t2) {
            this.handleSubClassException(t2, "lifecycleBase.startFail", this.toString());
        }
    }

    protected abstract void startInternal() throws LifecycleException;

    @Override
    public final synchronized void stop() throws LifecycleException {
        if (LifecycleState.STOPPING_PREP.equals((Object)this.state) || LifecycleState.STOPPING.equals((Object)this.state) || LifecycleState.STOPPED.equals((Object)this.state)) {
            if (log.isDebugEnabled()) {
                LifecycleException e2 = new LifecycleException();
                log.debug(sm.getString("lifecycleBase.alreadyStopped", this.toString()), e2);
            } else if (log.isInfoEnabled()) {
                log.info(sm.getString("lifecycleBase.alreadyStopped", this.toString()));
            }
            return;
        }
        if (this.state.equals((Object)LifecycleState.NEW)) {
            this.state = LifecycleState.STOPPED;
            return;
        }
        if (!this.state.equals((Object)LifecycleState.STARTED) && !this.state.equals((Object)LifecycleState.FAILED)) {
            this.invalidTransition("before_stop");
        }
        try {
            if (this.state.equals((Object)LifecycleState.FAILED)) {
                this.fireLifecycleEvent("before_stop", null);
            } else {
                this.setStateInternal(LifecycleState.STOPPING_PREP, null, false);
            }
            this.stopInternal();
            if (!this.state.equals((Object)LifecycleState.STOPPING) && !this.state.equals((Object)LifecycleState.FAILED)) {
                this.invalidTransition("after_stop");
            }
            this.setStateInternal(LifecycleState.STOPPED, null, false);
        }
        catch (Throwable t2) {
            this.handleSubClassException(t2, "lifecycleBase.stopFail", this.toString());
        }
        finally {
            if (this instanceof Lifecycle.SingleUse) {
                this.setStateInternal(LifecycleState.STOPPED, null, false);
                this.destroy();
            }
        }
    }

    protected abstract void stopInternal() throws LifecycleException;

    @Override
    public final synchronized void destroy() throws LifecycleException {
        if (LifecycleState.FAILED.equals((Object)this.state)) {
            try {
                this.stop();
            }
            catch (LifecycleException e2) {
                log.error(sm.getString("lifecycleBase.destroyStopFail", this.toString()), e2);
            }
        }
        if (LifecycleState.DESTROYING.equals((Object)this.state) || LifecycleState.DESTROYED.equals((Object)this.state)) {
            if (log.isDebugEnabled()) {
                LifecycleException e3 = new LifecycleException();
                log.debug(sm.getString("lifecycleBase.alreadyDestroyed", this.toString()), e3);
            } else if (log.isInfoEnabled() && !(this instanceof Lifecycle.SingleUse)) {
                log.info(sm.getString("lifecycleBase.alreadyDestroyed", this.toString()));
            }
            return;
        }
        if (!(this.state.equals((Object)LifecycleState.STOPPED) || this.state.equals((Object)LifecycleState.FAILED) || this.state.equals((Object)LifecycleState.NEW) || this.state.equals((Object)LifecycleState.INITIALIZED))) {
            this.invalidTransition("before_destroy");
        }
        try {
            this.setStateInternal(LifecycleState.DESTROYING, null, false);
            this.destroyInternal();
            this.setStateInternal(LifecycleState.DESTROYED, null, false);
        }
        catch (Throwable t2) {
            this.handleSubClassException(t2, "lifecycleBase.destroyFail", this.toString());
        }
    }

    protected abstract void destroyInternal() throws LifecycleException;

    @Override
    public LifecycleState getState() {
        return this.state;
    }

    @Override
    public String getStateName() {
        return this.getState().toString();
    }

    protected synchronized void setState(LifecycleState state) throws LifecycleException {
        this.setStateInternal(state, null, true);
    }

    protected synchronized void setState(LifecycleState state, Object data) throws LifecycleException {
        this.setStateInternal(state, data, true);
    }

    private synchronized void setStateInternal(LifecycleState state, Object data, boolean check) throws LifecycleException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("lifecycleBase.setState", new Object[]{this, state}));
        }
        if (check) {
            if (state == null) {
                this.invalidTransition("null");
                return;
            }
            if (!(state == LifecycleState.FAILED || this.state == LifecycleState.STARTING_PREP && state == LifecycleState.STARTING || this.state == LifecycleState.STOPPING_PREP && state == LifecycleState.STOPPING || this.state == LifecycleState.FAILED && state == LifecycleState.STOPPING)) {
                this.invalidTransition(state.name());
            }
        }
        this.state = state;
        String lifecycleEvent = state.getLifecycleEvent();
        if (lifecycleEvent != null) {
            this.fireLifecycleEvent(lifecycleEvent, data);
        }
    }

    private void invalidTransition(String type) throws LifecycleException {
        String msg = sm.getString("lifecycleBase.invalidTransition", new Object[]{type, this.toString(), this.state});
        throw new LifecycleException(msg);
    }

    private void handleSubClassException(Throwable t2, String key, Object ... args) throws LifecycleException {
        ExceptionUtils.handleThrowable(t2);
        this.setStateInternal(LifecycleState.FAILED, null, false);
        String msg = sm.getString(key, args);
        if (this.getThrowOnFailure()) {
            if (!(t2 instanceof LifecycleException)) {
                t2 = new LifecycleException(msg, t2);
            }
            throw (LifecycleException)t2;
        }
        log.error(msg, t2);
    }
}

