/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.modeler.Registry;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.JmxEnabled;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.util.LifecycleBase;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public abstract class LifecycleMBeanBase
extends LifecycleBase
implements JmxEnabled {
    private static final Log log = LogFactory.getLog(LifecycleMBeanBase.class);
    private static final StringManager sm = StringManager.getManager("com.bes.enterprise.webtier.util");
    private String domain = null;
    private ObjectName oname = null;
    protected MBeanServer mserver = null;

    @Override
    protected void initInternal() throws LifecycleException {
        if (this.oname == null) {
            this.mserver = Registry.getRegistry(null, null).getMBeanServer();
            this.oname = this.register(this, this.getObjectNameKeyProperties());
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        this.unregister(this.oname);
    }

    @Override
    public final void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public final String getDomain() {
        if (this.domain == null) {
            this.domain = this.getDomainInternal();
        }
        if (this.domain == null) {
            this.domain = "Heaven";
        }
        return this.domain;
    }

    protected abstract String getDomainInternal();

    @Override
    public final ObjectName getObjectName() {
        return this.oname;
    }

    protected abstract String getObjectNameKeyProperties();

    protected final ObjectName register(Object obj, String objectNameKeyProperties) {
        StringBuilder name = new StringBuilder(this.getDomain());
        name.append(':');
        name.append(objectNameKeyProperties);
        ObjectName on = null;
        try {
            on = new ObjectName(name.toString());
            Registry.getRegistry(null, null).registerComponent(obj, on, null);
        }
        catch (MalformedObjectNameException e2) {
            log.warn(sm.getString("lifecycleMBeanBase.registerFail", obj, name), e2);
        }
        catch (Exception e3) {
            log.warn(sm.getString("lifecycleMBeanBase.registerFail", obj, name), e3);
        }
        return on;
    }

    protected final void unregister(ObjectName on) {
        if (on == null) {
            return;
        }
        if (this.mserver == null) {
            log.warn(sm.getString("lifecycleMBeanBase.unregisterNoServer", on));
            return;
        }
        try {
            this.mserver.unregisterMBean(on);
        }
        catch (MBeanRegistrationException e2) {
            log.warn(sm.getString("lifecycleMBeanBase.unregisterFail", on), e2);
        }
        catch (InstanceNotFoundException e3) {
            log.warn(sm.getString("lifecycleMBeanBase.unregisterFail", on), e3);
        }
    }

    @Override
    public final void postDeregister() {
    }

    @Override
    public final void postRegister(Boolean registrationDone) {
    }

    @Override
    public final void preDeregister() throws Exception {
    }

    @Override
    public final ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mserver = server;
        this.oname = name;
        this.domain = name.getDomain().intern();
        return this.oname;
    }
}

