/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util;

import com.bes.enterprise.appserver.common.util.VersionUtil;
import com.bes.enterprise.web.util.ExceptionUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ServerInfo {
    private static final String serverInfo;
    private static final String serverBuilt;
    private static final String serverNumber;
    private static final String patch_file_path = "license/version";
    private static final String PATCH_TIME = "PatchTime";
    private static final String PATCH_VERSION = "PatchVersion";

    public static String getServerInfo() {
        return serverInfo;
    }

    public static String getServerInfoAndServerNumber() {
        return serverInfo + " (patch " + serverNumber + ")";
    }

    public static String getServerInfoAndPatchVersion() {
        return serverInfo + ServerInfo.getPatchVersion();
    }

    public static String getServerBuilt() {
        return serverBuilt;
    }

    public static String getServerNumber() {
        return serverNumber;
    }

    public static void main(String[] args) {
        System.out.println("Server version: " + ServerInfo.getServerInfo() + " " + VersionUtil.getPatchVersion());
        System.out.println("Server built:   " + ServerInfo.getServerBuilt());
        System.out.println("Server number:  " + ServerInfo.getServerNumber());
        System.out.println("OS Name:        " + System.getProperty("os.name"));
        System.out.println("OS Version:     " + System.getProperty("os.version"));
        System.out.println("Architecture:   " + System.getProperty("os.arch"));
        System.out.println("JVM Version:    " + System.getProperty("java.runtime.version"));
        System.out.println("JVM Vendor:     " + System.getProperty("java.vm.vendor"));
    }

    private static String getPatchVersion() {
        Properties patchProperties = ServerInfo.getPatchFromFile();
        if (null != patchProperties.get(PATCH_VERSION)) {
            return " (patch " + patchProperties.get(PATCH_VERSION) + ")";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getPatchFromFile() {
        Properties prop = new Properties();
        String patchFilePath = System.getProperty("com.bes.installRoot");
        File patchFile = new File(patchFilePath, patch_file_path);
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(patchFile));
            prop.load(in);
        }
        catch (Exception e2) {
            Properties properties = new Properties();
            return properties;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return prop;
    }

    static {
        String info = null;
        String built = null;
        String number = null;
        Properties props = new Properties();
        try (InputStream is = ServerInfo.class.getResourceAsStream("/com/bes/enterprise/webtier/util/ServerInfo.properties");){
            props.load(is);
            info = props.getProperty("server.info");
            built = props.getProperty("server.built");
            number = props.getProperty("server.number");
        }
        catch (Throwable t2) {
            ExceptionUtils.handleThrowable(t2);
        }
        if (info == null) {
            info = "BES Application Server";
        }
        if (built == null) {
            built = "unknown";
        }
        if (number == null) {
            number = "9.5.x";
        }
        serverInfo = info;
        serverBuilt = built;
        serverNumber = number;
    }
}

