/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util;

import com.bes.enterprise.webtier.Context;
import javax.servlet.SessionCookieConfig;

public class SessionConfig {
    private static final String DEFAULT_SESSION_COOKIE_NAME = "JSESSIONID";
    private static final String DEFAULT_SESSION_PARAMETER_NAME = "jsessionid";
    private static final boolean cookiePathCompatibleWeblogic = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.web.cookie.compatibleWeblogic", "true"));

    public static String getSessionCookieName(Context context) {
        String result = SessionConfig.getConfiguredSessionCookieName(context);
        if (result == null) {
            result = DEFAULT_SESSION_COOKIE_NAME;
        }
        return result;
    }

    public static String getSessionUriParamName(Context context) {
        String result = SessionConfig.getConfiguredSessionCookieName(context);
        if (result == null) {
            result = DEFAULT_SESSION_PARAMETER_NAME;
        }
        return result;
    }

    private static String getConfiguredSessionCookieName(Context context) {
        if (context != null) {
            String cookieName = context.getSessionCookieName();
            if (cookieName != null && cookieName.length() > 0) {
                return cookieName;
            }
            SessionCookieConfig scc = context.getServletContext().getSessionCookieConfig();
            cookieName = scc.getName();
            if (cookieName != null && cookieName.length() > 0) {
                return cookieName;
            }
        }
        return null;
    }

    public static String getSessionCookiePath(Context context) {
        SessionCookieConfig scc = context.getServletContext().getSessionCookieConfig();
        String contextPath = context.getSessionCookiePath();
        if (contextPath == null || contextPath.length() == 0) {
            contextPath = scc.getPath();
        }
        if (contextPath == null || contextPath.length() == 0) {
            String string = contextPath = cookiePathCompatibleWeblogic ? "/" : context.getEncodedPath();
        }
        if (context.getSessionCookiePathUsesTrailingSlash()) {
            if (!contextPath.endsWith("/")) {
                contextPath = contextPath + "/";
            }
        } else if (contextPath.length() == 0) {
            contextPath = "/";
        }
        return contextPath;
    }

    private SessionConfig() {
    }
}

