/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util.mbeanserver;

import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.SystemPropertyValueTranslator;
import com.bes.enterprise.config.provider.ConfigProviderGlobals;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.webtier.LifecycleEvent;
import com.bes.enterprise.webtier.LifecycleListener;
import com.bes.enterprise.webtier.util.mbeanserver.JMXConnectorAuthenticator;
import com.bes.enterprise.webtier.util.mbeanserver.JMXConnectorStarter;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;

public class BesJmxRemoteLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(BesJmxRemoteLifecycleListener.class);
    private JMXConnectorStarter jmxConnectorStarter;
    private JMXConnectorServer jmxConnectorServer;

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("after_start".equals(event.getType())) {
            this.startJmxConnector();
        } else if ("stop".equals(event.getType())) {
            this.stopJmxConnector();
        }
    }

    private void startJmxConnector() {
        try {
            String enabled;
            DomTemplate rootConfig = (DomTemplate)ConfigProviderGlobals.getGlobalItem("rootConfig");
            DomTemplate jmxConnector = rootConfig.getElement("jmx-connector");
            if (jmxConnector != null && Boolean.valueOf(enabled = jmxConnector.getAttribute("enabled")).booleanValue()) {
                SystemPropertyValueTranslator translator = SystemPropertyValueTranslator.getInstance();
                String jmxAdress = translator.getTranslatedValue(jmxConnector.getAttribute("address"));
                String jmxPortStr = translator.getTranslatedValue(jmxConnector.getAttribute("port"));
                int jmxPort = Integer.parseInt(jmxPortStr);
                boolean securityEnabled = Boolean.valueOf(jmxConnector.getAttribute("security-enabled"));
                String authRealmName = jmxConnector.getAttribute("auth-realm-name");
                DomTemplate ssl = jmxConnector.getElement("ssl");
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                JMXAuthenticator jmxAuthenticator = this.createJMXAuthenticator(rootConfig, jmxConnector);
                this.jmxConnectorStarter = new JMXConnectorStarter(mBeanServer, jmxAdress, jmxPort, authRealmName, jmxAuthenticator, securityEnabled, ssl);
                this.jmxConnectorServer = this.jmxConnectorStarter.start();
                JMXServiceURL jmxServiceURL = this.jmxConnectorStarter.getJmxServiceURL();
                log.info("JMX service url: " + jmxServiceURL.toString());
            }
        }
        catch (Exception ex) {
            log.error("The JMX connector server could not be created or failed to start!", ex);
        }
    }

    private JMXAuthenticator createJMXAuthenticator(DomTemplate rootConfig, DomTemplate jmxConnector) {
        String authRealmName = jmxConnector.getAttribute("auth-realm-name");
        DomTemplate authRealm = this.getAuthRealm(rootConfig, authRealmName);
        String adminKeyFile = SystemPropertyValueTranslator.getInstance().getTranslatedValue(authRealm.getAttribute("pathname"));
        JMXConnectorAuthenticator jmxConnectorAuthenticator = new JMXConnectorAuthenticator(adminKeyFile, authRealmName);
        return jmxConnectorAuthenticator;
    }

    private DomTemplate getAuthRealm(DomTemplate rootConfig, String jmxAuthRealmName) {
        List<DomTemplate> authRealms = rootConfig.getElement("security-service").getElements("auth-realm");
        for (DomTemplate authRealm : authRealms) {
            String authRealmName = authRealm.getAttribute("name");
            if (authRealmName == null || !authRealmName.equals(jmxAuthRealmName)) continue;
            return authRealm;
        }
        throw new IllegalStateException("The auth-realm " + jmxAuthRealmName + " does not exists.");
    }

    private void stopJmxConnector() {
        if (this.jmxConnectorStarter != null) {
            this.jmxConnectorStarter.stop();
        }
    }
}

