/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util.mbeanserver;

import com.bes.enterprise.appserver.common.security.FileRealmHelper;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.io.IOException;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;

public class JMXConnectorAuthenticator
implements JMXAuthenticator {
    private static final Log log = LogFactory.getLog(JMXConnectorAuthenticator.class);
    private String adminKeyFilePath;
    private String authRealmName;

    public JMXConnectorAuthenticator(String adminKeyFilePath, String authRealmName) {
        this.adminKeyFilePath = adminKeyFilePath;
        this.authRealmName = authRealmName;
    }

    @Override
    public Subject authenticate(Object credentials) {
        if (credentials == null) {
            String msg = "Null credentials sent from the client!";
            log.error(msg);
            throw new SecurityException(msg);
        }
        if (!(credentials instanceof String[])) {
            String msg = "Invalid credentials sent from the client " + credentials.getClass().getName() + "!";
            log.error(msg);
            throw new SecurityException(msg);
        }
        String[] userpass = (String[])credentials;
        if (userpass.length != 2) {
            String msg = "Invalid credentials sent from client, string array of length " + userpass.length + "!";
            log.error(msg);
            throw new SecurityException(msg);
        }
        try {
            String user = userpass[0];
            String password = userpass[1];
            if (this.handleWithFileRealm(user, password)) {
                return null;
            }
            String msg = "Incorrect user/password sent from client!";
            log.error(msg);
            throw new SecurityException(msg);
        }
        catch (Exception ex) {
            String msg = "Failed to authenticate credentials!";
            log.error(msg);
            throw new SecurityException(msg, ex);
        }
    }

    private boolean handleWithFileRealm(String user, String password) throws IOException {
        FileRealmHelper fileRealmHelper = new FileRealmHelper(this.authRealmName, this.adminKeyFilePath);
        return fileRealmHelper.authenticate(user, password.toCharArray()) != null;
    }
}

