/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.util.mbeanserver;

import com.bes.enterprise.appserver.common.ssl.SecuritySupport;
import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.config.miniparser.DomTemplate;
import com.bes.enterprise.config.miniparser.SystemPropertyValueTranslator;
import com.bes.enterprise.webtier.util.mbeanserver.JMXSslRMISocketFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.net.ssl.SSLException;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class JMXConnectorStarter {
    public static final String RMI_HOSTNAME_PROP = "java.rmi.server.hostname";
    private Registry registry;
    private MBeanServer mbeanServer;
    private String hostName;
    private int port;
    private String authRealmName;
    private boolean securityEnabled;
    private JMXServiceURL jmxServiceURL;
    private JMXConnectorServer jmxConnectorServer;
    private RMIServerSocketFactory rmiServerSocketFactory;
    private RMIClientSocketFactory rmiClientSocketFactory;
    private JMXAuthenticator jmxAuthenticator;

    public JMXConnectorStarter(MBeanServer mbeanServer, String hostName, int port, String authRealmName, JMXAuthenticator jmxAuthenticator, boolean securityEnabled, DomTemplate ssl) throws UnknownHostException, NoSuchAlgorithmException, GeneralSecurityException, IOException {
        this.mbeanServer = mbeanServer;
        this.hostName = hostName;
        this.port = port;
        this.authRealmName = authRealmName;
        this.jmxAuthenticator = jmxAuthenticator;
        this.securityEnabled = securityEnabled;
        InetAddress inetAddr = JMXConnectorStarter.getAddress(this.hostName);
        if (securityEnabled) {
            SecuritySupport securitySupport;
            String alias = ssl.getAttribute("key-alias");
            boolean ssl3Enabled = Boolean.valueOf(ssl.getAttribute("ssl3-enabled"));
            boolean tlsEnabled = Boolean.valueOf(ssl.getAttribute("tls-enabled"));
            boolean tls11Enabled = Boolean.valueOf(ssl.getAttribute("tls11-enabled"));
            boolean tls12Enabled = Boolean.valueOf(ssl.getAttribute("tls12-enabled"));
            boolean tls13Enabled = Boolean.valueOf(ssl.getAttribute("tls13-enabled"));
            String ciphers = ssl.getAttribute("ciphers");
            if (StringUtils.isNotEmpty(ciphers)) {
                String[] ciphersArray = ciphers.split(":");
                if (!(StringUtils.contains(ciphersArray, "!DHE") || StringUtils.contains(ciphersArray, "DHE") || StringUtils.contains(ciphersArray, "+DHE") || StringUtils.contains(ciphersArray, "-DHE"))) {
                    ciphers = ciphers + ":!DHE";
                }
                if (!(StringUtils.contains(ciphersArray, "!kRSA") || StringUtils.contains(ciphersArray, "kRSA") || StringUtils.contains(ciphersArray, "+kRSA") || StringUtils.contains(ciphersArray, "-kRSA"))) {
                    ciphers = ciphers + ":!kRSA";
                }
            }
            if (!(securitySupport = this.createSecuritySupport(ssl)).getKeystore().containsAlias(alias)) {
                throw new SSLException("The key alias " + alias + " is invalid.");
            }
            JMXSslRMISocketFactory jmxSslRMISocketFactory = new JMXSslRMISocketFactory(alias, ssl3Enabled, tlsEnabled, tls11Enabled, tls12Enabled, tls13Enabled, ssl.getAttribute("client-auth"), ciphers, inetAddr, securitySupport);
            this.initSSLSystemProperties(ssl, jmxSslRMISocketFactory.getEnabledProtocolsAsString(), jmxSslRMISocketFactory.getCiphersAsString());
            jmxSslRMISocketFactory.setSecuritySupport(securitySupport);
            this.rmiServerSocketFactory = new SecureSslRMIServerSocketFactory(jmxSslRMISocketFactory);
            this.rmiClientSocketFactory = this.createRmiClientSocketFactory();
        } else {
            this.rmiServerSocketFactory = new DefaultRMISocketFactory(inetAddr);
            this.rmiClientSocketFactory = null;
        }
        this.registry = this.createRegistry(port);
    }

    private void initSSLSystemProperties(DomTemplate ssl, String enabledProtocols, String enabledCiphers) {
        String keyStoreType = ssl.getAttribute("keystore-type");
        String keyStoreFile = SystemPropertyValueTranslator.getInstance().getTranslatedValue(ssl.getAttribute("keystore-file"));
        String keyStorePass = ssl.getAttribute("keystore-pass");
        String trustStoreType = ssl.getAttribute("truststore-type");
        String trustStoreFile = SystemPropertyValueTranslator.getInstance().getTranslatedValue(ssl.getAttribute("truststore-file"));
        String trustStorePass = ssl.getAttribute("truststore-pass");
        if (System.getProperty("javax.net.ssl.keyStoreType") == null) {
            System.setProperty("javax.net.ssl.keyStoreType", trustStoreType == null ? "JKS" : keyStoreType);
        }
        if (System.getProperty("javax.net.ssl.trustStoreType") == null) {
            System.setProperty("javax.net.ssl.trustStoreType", trustStoreType == null ? "JKS" : trustStoreType);
        }
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            System.setProperty("javax.net.ssl.keyStore", keyStoreFile);
        }
        if (System.getProperty("javax.net.ssl.trustStore") == null) {
            System.setProperty("javax.net.ssl.trustStore", trustStoreFile);
        }
        if (System.getProperty("javax.net.ssl.keyStorePassword") == null) {
            System.setProperty("javax.net.ssl.keyStorePassword", keyStorePass == null ? "changeit" : keyStorePass);
        }
        if (System.getProperty("javax.net.ssl.trustStorePassword") == null) {
            System.setProperty("javax.net.ssl.trustStorePassword", trustStorePass == null ? "changeit" : trustStorePass);
        }
        if (enabledProtocols != null) {
            System.setProperty("javax.rmi.ssl.client.enabledProtocols", enabledProtocols);
        }
        if (enabledCiphers != null) {
            System.setProperty("javax.rmi.ssl.client.enabledCipherSuites", enabledCiphers);
        }
    }

    public JMXConnectorServer start() throws Exception {
        String name = "jmxrmi";
        String hostname = JMXConnectorStarter.getHostName(this.hostName);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.jndi.rebind", "true");
        env.put("jmx.remote.rmi.client.socket.factory", this.rmiClientSocketFactory);
        env.put("jmx.remote.rmi.server.socket.factory", this.rmiServerSocketFactory);
        env.put("com.sun.jndi.rmi.factory.socket", this.rmiClientSocketFactory);
        if (this.jmxAuthenticator != null) {
            env.put("jmx.remote.authenticator", this.jmxAuthenticator);
        }
        String registryHostPort = hostname + ":" + this.port;
        String urlPath = "/jndi/rmi://" + registryHostPort + "/" + name;
        String protocol = "rmi";
        this.jmxServiceURL = new JMXServiceURL(protocol, hostname, this.port, urlPath);
        this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.jmxServiceURL, env, this.mbeanServer);
        this.jmxConnectorServer.start();
        return this.jmxConnectorServer;
    }

    public void stop() {
        if (this.jmxConnectorServer != null) {
            try {
                this.jmxConnectorServer.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.registry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.registry, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    private Registry createRegistry(int port) throws RemoteException {
        System.setProperty("java.rmi.server.randomIDs", "true");
        try {
            if (this.securityEnabled) {
                return LocateRegistry.createRegistry(port, this.rmiClientSocketFactory, this.rmiServerSocketFactory);
            }
            return LocateRegistry.createRegistry(port, null, this.rmiServerSocketFactory);
        }
        catch (RemoteException ex) {
            RemoteException rmEx = new RemoteException("Port " + port + " is not available for the internal rmi registry.");
            rmEx.detail = ex;
            throw rmEx;
        }
    }

    private SecuritySupport createSecuritySupport(DomTemplate ssl) throws GeneralSecurityException {
        String keyStoreType = ssl.getAttribute("keystore-type");
        String keyStoreFile = SystemPropertyValueTranslator.getInstance().getTranslatedValue(ssl.getAttribute("keystore-file"));
        String keyStorePass = ssl.getAttribute("keystore-pass");
        String trustStoreType = ssl.getAttribute("truststore-type");
        String trustStoreFile = SystemPropertyValueTranslator.getInstance().getTranslatedValue(ssl.getAttribute("truststore-file"));
        String trustStorePass = ssl.getAttribute("truststore-pass");
        SecuritySupport securitySupport = new SecuritySupport(keyStoreType, keyStoreFile, keyStorePass.toCharArray(), trustStoreType, trustStoreFile, trustStorePass.toCharArray());
        securitySupport.init();
        return securitySupport;
    }

    private RMIClientSocketFactory createRmiClientSocketFactory() {
        SslRMIClientSocketFactory sslRMIClientSocketFactory = new SslRMIClientSocketFactory();
        return sslRMIClientSocketFactory;
    }

    private static InetAddress getAddress(String addrSpec) throws UnknownHostException {
        String actual = addrSpec;
        if (addrSpec.equals("localhost")) {
            actual = "127.0.0.1";
        }
        InetAddress addr = InetAddress.getByName(actual);
        return addr;
    }

    private static String getHostName(String hostName) throws UnknownHostException {
        if (hostName.equals("") || hostName.equals("0.0.0.0")) {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        if (hostName.contains(":") && !hostName.startsWith("[")) {
            return "[" + hostName + "]";
        }
        return hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public JMXServiceURL getJmxServiceURL() {
        return this.jmxServiceURL;
    }

    public RMIServerSocketFactory getRmiServerSocketFactory() {
        return this.rmiServerSocketFactory;
    }

    public void setRmiServerSocketFactory(RMIServerSocketFactory rmiServerSocketFactory) {
        this.rmiServerSocketFactory = rmiServerSocketFactory;
    }

    public RMIClientSocketFactory getRmiClientSocketFactory() {
        return this.rmiClientSocketFactory;
    }

    public void setRmiClientSocketFactory(RMIClientSocketFactory rmiClientSocketFactory) {
        this.rmiClientSocketFactory = rmiClientSocketFactory;
    }

    private static class SecureSslRMIServerSocketFactory
    extends SslRMIServerSocketFactory {
        private JMXSslRMISocketFactory secureSslRMISocketFactory;

        public SecureSslRMIServerSocketFactory(JMXSslRMISocketFactory secureSslRMISocketFactory) {
            this.secureSslRMISocketFactory = secureSslRMISocketFactory;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return this.secureSslRMISocketFactory.createServerSocket(port);
        }
    }

    private static final class DefaultRMISocketFactory
    extends RMISocketFactory {
        private final InetAddress mAddress;

        public DefaultRMISocketFactory(InetAddress addr) {
            this.mAddress = addr;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            int backlog = 5;
            ServerSocket s2 = new ServerSocket(port, 5, this.mAddress);
            return s2;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            Socket s2 = new Socket(host, port);
            return s2;
        }
    }
}

