/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.valves;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.ExceptionUtils;
import com.bes.enterprise.web.util.buf.B2CConverter;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.valves.AbstractAccessLogValve;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;

public class AccessLogValve
extends AbstractAccessLogValve {
    private static final Log log = LogFactory.getLog(AccessLogValve.class);
    public static final int DEFAULT_MAX_HISTROY_FILES = 10;
    public static final int DEFAULT_ROTATION_SIZE = 0xA00000;
    private volatile String dateStamp = "";
    private String directory = "logs";
    protected String prefix = "access_log";
    protected boolean rotatableByTime = true;
    protected boolean rotatableBySize = false;
    protected boolean renameOnRotate = true;
    private boolean buffered = true;
    protected String suffix = "";
    protected PrintWriter writer = null;
    protected SimpleDateFormat fileDateFormatter = null;
    protected File currentLogFile = null;
    private volatile long rotationLastChecked = 0L;
    private boolean checkExists = false;
    protected String fileDateFormat = ".yyyy-MM-dd";
    protected String encoding = null;
    protected int rotationSize;
    private int rotationBySizeFlag = 0;
    private LinkedList<File> historyFiles;
    private int maxHistoryFiles;
    private boolean deleteAllHistoryFiles;

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean isCheckExists() {
        return this.checkExists;
    }

    public void setCheckExists(boolean checkExists) {
        this.checkExists = checkExists;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isRotatableByTime() {
        return this.rotatableByTime;
    }

    public void setRotatableByTime(boolean rotatableByTime) {
        this.rotatableByTime = rotatableByTime;
    }

    public boolean isRotatableBySize() {
        return this.rotatableBySize;
    }

    public void setRotatableBySize(boolean rotatableBySize) {
        this.rotatableBySize = rotatableBySize;
    }

    public int getRotationSize() {
        return this.rotationSize;
    }

    public void setRotationSize(int rotationSize) {
        this.rotationSize = rotationSize;
    }

    public int getMaxHistoryFiles() {
        return this.maxHistoryFiles;
    }

    public void setMaxHistoryFiles(int maxHistoryFiles) {
        this.maxHistoryFiles = maxHistoryFiles;
    }

    public boolean isRenameOnRotate() {
        return this.renameOnRotate;
    }

    public void setRenameOnRotate(boolean renameOnRotate) {
        this.renameOnRotate = renameOnRotate;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public void setBuffered(boolean buffered) {
        this.buffered = buffered;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getFileDateFormat() {
        return this.fileDateFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileDateFormat(String fileDateFormat) {
        String newFormat = fileDateFormat == null ? "" : fileDateFormat;
        this.fileDateFormat = newFormat;
        AccessLogValve accessLogValve = this;
        synchronized (accessLogValve) {
            this.fileDateFormatter = new SimpleDateFormat(newFormat, Locale.US);
            this.fileDateFormatter.setTimeZone(TimeZone.getDefault());
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding != null && encoding.length() > 0 ? encoding : null;
    }

    @Override
    public synchronized void backgroundProcess() {
        if (this.getState().isAvailable() && this.getEnabled() && this.writer != null && this.buffered) {
            this.writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotate(CharArrayWriter message) {
        AccessLogValve accessLogValve;
        int rotationSize = this.getRotationSize();
        long systime = System.currentTimeMillis();
        int messageLength = 0;
        if (message != null) {
            messageLength = message.size() + 2;
        }
        if (this.rotatableBySize) {
            accessLogValve = this;
            synchronized (accessLogValve) {
                long writtenBytes = new File(this.currentLogFile.toURI()).length() + (long)messageLength;
                if (writtenBytes > (long)rotationSize) {
                    this.close(true);
                    this.open();
                    return;
                }
            }
        }
        if (this.rotatableByTime && systime - this.rotationLastChecked > 1000L) {
            accessLogValve = this;
            synchronized (accessLogValve) {
                if (systime - this.rotationLastChecked > 1000L) {
                    this.rotationLastChecked = systime;
                    String tsDate = this.fileDateFormatter.format(new Date(systime));
                    if (!this.dateStamp.equals(tsDate)) {
                        this.close(true);
                        this.dateStamp = tsDate;
                        this.open();
                        return;
                    }
                }
            }
        }
    }

    public synchronized boolean rotate(String newFileName) {
        if (this.currentLogFile != null) {
            File holder = this.currentLogFile;
            this.close(false);
            try {
                holder.renameTo(new File(newFileName));
            }
            catch (Throwable e2) {
                ExceptionUtils.handleThrowable(e2);
                log.error(sm.getString("accessLogValve.rotateFail"), e2);
            }
            this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
            this.open();
            return true;
        }
        return false;
    }

    private File getLogFile(boolean useDateStamp) {
        File pathname;
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(this.getContainer().getHeavenBase(), this.directory);
        }
        if (!dir.mkdirs() && !dir.isDirectory()) {
            log.error(sm.getString("accessLogValve.openDirFail", dir));
        }
        if (useDateStamp && this.rotatableByTime && !this.rotatableBySize) {
            pathname = new File(dir.getAbsoluteFile(), this.prefix + this.dateStamp + this.suffix);
        } else if (useDateStamp && !this.rotatableByTime && this.rotatableBySize) {
            pathname = new File(dir.getAbsoluteFile(), this.prefix + "-" + this.rotationBySizeFlag + this.suffix);
            ++this.rotationBySizeFlag;
        } else if (useDateStamp && this.rotatableByTime && this.rotatableBySize) {
            pathname = new File(dir.getAbsoluteFile(), this.prefix + "-" + this.rotationBySizeFlag + "-" + this.dateStamp + this.suffix);
            String tsDate = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
            this.rotationBySizeFlag = this.dateStamp.equals(tsDate) ? ++this.rotationBySizeFlag : 0;
        } else {
            pathname = new File(dir.getAbsoluteFile(), this.prefix + this.suffix);
        }
        File parent = pathname.getParentFile();
        if (!parent.mkdirs() && !parent.isDirectory()) {
            log.error(sm.getString("accessLogValve.openDirFail", parent));
        }
        return pathname;
    }

    private void restore() {
        File newLogFile = this.getLogFile(false);
        File rotatedLogFile = this.getLogFile(true);
        if (rotatedLogFile.exists() && !newLogFile.exists() && !rotatedLogFile.equals(newLogFile)) {
            try {
                if (!rotatedLogFile.renameTo(newLogFile)) {
                    log.error(sm.getString("accessLogValve.renameFail", rotatedLogFile, newLogFile));
                }
            }
            catch (Throwable e2) {
                ExceptionUtils.handleThrowable(e2);
                log.error(sm.getString("accessLogValve.renameFail", rotatedLogFile, newLogFile), e2);
            }
        }
    }

    private synchronized void close(boolean rename) {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        if (rename && this.renameOnRotate) {
            File newLogFile = this.getLogFile(true);
            if (!newLogFile.exists()) {
                try {
                    if (!this.currentLogFile.renameTo(newLogFile)) {
                        log.error(sm.getString("accessLogValve.renameFail", this.currentLogFile, newLogFile));
                    }
                }
                catch (Throwable e2) {
                    ExceptionUtils.handleThrowable(e2);
                    log.error(sm.getString("accessLogValve.renameFail", this.currentLogFile, newLogFile), e2);
                }
            } else {
                log.error(sm.getString("accessLogValve.alreadyExists", this.currentLogFile, newLogFile));
            }
            LinkedList<File> removeFiles = new LinkedList<File>();
            if (this.deleteAllHistoryFiles) {
                if (this.historyFiles != null) {
                    for (File file : this.historyFiles) {
                        file.delete();
                    }
                }
                removeFiles.add(newLogFile);
            } else {
                this.historyFiles.addLast(newLogFile);
                while (this.historyFiles.size() > this.maxHistoryFiles) {
                    removeFiles.add(this.historyFiles.removeFirst());
                }
            }
            if (removeFiles != null && removeFiles.size() > 0) {
                for (int i2 = 0; i2 < removeFiles.size(); ++i2) {
                    if (((File)removeFiles.get(i2)).delete()) continue;
                    log.warn("Failed to remove the old access log file:" + ((File)removeFiles.get(i2)).getName() + ".");
                }
            }
        }
        this.writer = null;
        this.currentLogFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(CharArrayWriter message) {
        AccessLogValve accessLogValve;
        this.rotate(message);
        if (this.checkExists) {
            accessLogValve = this;
            synchronized (accessLogValve) {
                if (this.currentLogFile != null && !this.currentLogFile.exists()) {
                    try {
                        this.close(false);
                    }
                    catch (Throwable e2) {
                        ExceptionUtils.handleThrowable(e2);
                        log.info(sm.getString("accessLogValve.closeFail"), e2);
                    }
                    this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
                    this.open();
                }
            }
        }
        try {
            message.write(System.lineSeparator());
            accessLogValve = this;
            synchronized (accessLogValve) {
                if (this.writer != null) {
                    message.writeTo(this.writer);
                    if (!this.buffered) {
                        this.writer.flush();
                    }
                }
            }
        }
        catch (IOException ioe) {
            log.warn(sm.getString("accessLogValve.writeFail", message.toString()), ioe);
        }
    }

    protected synchronized void open() {
        File pathname = this.getLogFile((this.rotatableByTime || this.rotatableBySize) && !this.renameOnRotate);
        Charset charset = null;
        if (this.encoding != null) {
            try {
                charset = B2CConverter.getCharset(this.encoding);
            }
            catch (UnsupportedEncodingException ex) {
                log.error(sm.getString("accessLogValve.unsupportedEncoding", this.encoding), ex);
            }
        }
        if (charset == null) {
            charset = StandardCharsets.ISO_8859_1;
        }
        try {
            this.writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pathname, true), charset), 128000), false);
            this.currentLogFile = pathname;
        }
        catch (IOException e2) {
            this.writer = null;
            this.currentLogFile = null;
            log.error(sm.getString("accessLogValve.openFail", pathname), e2);
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        String format = this.getFileDateFormat();
        this.fileDateFormatter = new SimpleDateFormat(format, Locale.US);
        this.fileDateFormatter.setTimeZone(TimeZone.getDefault());
        this.dateStamp = this.fileDateFormatter.format(new Date(System.currentTimeMillis()));
        this.deleteAllHistoryFiles = false;
        this.historyFiles = null;
        try {
            this.maxHistoryFiles = this.getMaxHistoryFiles();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.maxHistoryFiles == 0) {
            this.deleteAllHistoryFiles = true;
        }
        this.historyFiles = new LinkedList();
        File dir = new File(this.directory);
        File[] allAccessLogFiles = dir.listFiles();
        boolean judgeFlag = false;
        if (allAccessLogFiles != null) {
            String fileName;
            for (File file : allAccessLogFiles) {
                fileName = file.getName();
                if (!fileName.startsWith(this.prefix) || fileName.endsWith(this.prefix) || fileName.endsWith(".zip")) continue;
                this.historyFiles.addLast(file);
            }
            if (this.historyFiles != null && this.historyFiles.size() > 0) {
                this.historyFiles = this.sortByLastModifiedTime(this.historyFiles);
                if (this.rotatableBySize && !this.rotatableByTime) {
                    for (File file : this.historyFiles) {
                        String[] nameParts = file.getName().split("-");
                        if (file.getName().charAt(this.prefix.length()) != '-' || nameParts.length != 2 || Integer.parseInt(nameParts[1]) < this.rotationBySizeFlag) continue;
                        this.rotationBySizeFlag = Integer.parseInt(nameParts[1]);
                        judgeFlag = true;
                    }
                    if (judgeFlag) {
                        ++this.rotationBySizeFlag;
                    }
                } else if (this.rotatableBySize && this.rotatableByTime) {
                    File currentLog = new File(dir.getAbsoluteFile(), this.prefix + this.suffix);
                    String currentLogDateStamp = this.fileDateFormatter.format(new Date(currentLog.lastModified()));
                    for (File file : this.historyFiles) {
                        fileName = file.getName();
                        String[] nameParts = fileName.split("-");
                        if (fileName.charAt(this.prefix.length()) != '-' || nameParts.length == 2) continue;
                        int sizeFlagLength = nameParts[1].length();
                        String fileDataStamp = fileName.substring(this.prefix.length() + sizeFlagLength + 2, fileName.length());
                        if (!this.dateStamp.equals(currentLogDateStamp) || !fileDataStamp.equals(currentLogDateStamp) || Integer.parseInt(nameParts[1]) < this.rotationBySizeFlag) continue;
                        this.rotationBySizeFlag = Integer.parseInt(nameParts[1]);
                        judgeFlag = true;
                    }
                    if (judgeFlag) {
                        ++this.rotationBySizeFlag;
                    }
                }
            }
        }
        this.open();
        super.startInternal();
    }

    protected LinkedList<File> sortByLastModifiedTime(LinkedList<File> files) {
        for (int x2 = 0; x2 < files.size(); ++x2) {
            for (int y2 = 0; y2 < files.size() - 1 - x2; ++y2) {
                long time1 = files.get(y2).lastModified();
                long time2 = files.get(y2 + 1).lastModified();
                File file1 = files.get(y2);
                File file2 = files.get(y2 + 1);
                if (time1 - time2 <= 0L) continue;
                files.set(y2, file2);
                files.set(y2 + 1, file1);
            }
        }
        return files;
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.close(false);
    }
}

