/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.valves;

import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.buf.UDecoder;
import com.bes.enterprise.webtier.Container;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Engine;
import com.bes.enterprise.webtier.Host;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.connector.Request;
import com.bes.enterprise.webtier.connector.Response;
import com.bes.enterprise.webtier.valves.ValveBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;

public class ParameterLimitValve
extends ValveBase {
    private Map<Pattern, Integer[]> urlPatternLimits = new ConcurrentHashMap<Pattern, Integer[]>();
    private String resourcePath = "parameter_limit.config";
    private boolean context = false;

    public ParameterLimitValve() {
        super(true);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.containerLog = LogFactory.getLog(this.getContainer().getLogName() + ".parameterLimit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        super.startInternal();
        InputStream is = null;
        if (this.getContainer() instanceof Context) {
            this.context = true;
            String webInfResourcePath = "/WEB-INF/" + this.resourcePath;
            is = ((Context)this.getContainer()).getServletContext().getResourceAsStream(webInfResourcePath);
            if (this.containerLog.isDebugEnabled()) {
                if (is == null) {
                    this.containerLog.debug(sm.getString("parameterLimitValve.noConfiguration", webInfResourcePath));
                } else {
                    this.containerLog.debug(sm.getString("parameterLimitValve.readConfiguration", webInfResourcePath));
                }
            }
        } else if (this.getContainer() instanceof Host) {
            String resourceName = this.getHostConfigPath(this.resourcePath);
            File file = new File(this.getConfigBase(), resourceName);
            try {
                if (!file.exists()) {
                    is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                    if (is != null && this.containerLog.isDebugEnabled()) {
                        this.containerLog.debug("Read configuration from CL at " + resourceName);
                    }
                } else {
                    if (this.containerLog.isDebugEnabled()) {
                        this.containerLog.debug("Read configuration from " + file.getAbsolutePath());
                    }
                    is = new FileInputStream(file);
                }
                if (is == null && this.containerLog.isDebugEnabled()) {
                    this.containerLog.debug("No configuration resource found: " + resourceName + " in " + this.getConfigBase() + " or in the classloader");
                }
            }
            catch (Exception e2) {
                this.containerLog.error("Error opening configuration", e2);
            }
        }
        if (is == null) {
            return;
        }
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(isr);){
            this.setUrlPatternLimits(reader);
        }
        catch (IOException ioe) {
            this.containerLog.error(sm.getString("parameterLimitValve.closeError"), ioe);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e3) {
                this.containerLog.error(sm.getString("parameterLimitValve.closeError"), e3);
            }
        }
    }

    public void setUrlPatternLimits(String urlPatternConfig) {
        this.urlPatternLimits.clear();
        this.setUrlPatternLimits(new BufferedReader(new StringReader(urlPatternConfig)));
    }

    public void setUrlPatternLimits(BufferedReader reader) {
        if (this.containerLog == null && this.getContainer() != null) {
            this.containerLog = LogFactory.getLog(this.getContainer().getLogName() + ".parameterLimit");
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                int lastEqualsIndex = line.lastIndexOf(61);
                if (lastEqualsIndex == -1) {
                    throw new IllegalArgumentException(sm.getString("parameterLimitValve.invalidLine", line));
                }
                String patternString = line.substring(0, lastEqualsIndex).trim();
                String limitsString = line.substring(lastEqualsIndex + 1).trim();
                Pattern pattern = Pattern.compile(UDecoder.URLDecode(patternString, StandardCharsets.UTF_8));
                String[] limits = limitsString.split(",");
                if (limits.length == 1) {
                    this.urlPatternLimits.put(pattern, new Integer[]{Integer.valueOf(limits[0]), null, null});
                } else if (limits.length == 3) {
                    this.urlPatternLimits.put(pattern, new Integer[]{Integer.valueOf(limits[0]), Integer.valueOf(limits[1]), Integer.valueOf(limits[2])});
                } else {
                    throw new IllegalArgumentException(sm.getString("parameterLimitValve.invalidLimitsString", limitsString));
                }
                if (this.containerLog == null || !this.containerLog.isTraceEnabled()) continue;
                this.containerLog.trace("Add pattern " + pattern + " and limit(s) " + limitsString);
            }
        }
        catch (IOException e2) {
            this.containerLog.error(sm.getString("parameterLimitValve.readError"), e2);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.urlPatternLimits.clear();
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.urlPatternLimits.isEmpty()) {
            this.getNext().invoke(request, response);
            return;
        }
        String requestURI = this.context ? request.getRequestPathMB().toString() : request.getDecodedRequestURI();
        for (Map.Entry<Pattern, Integer[]> entry : this.urlPatternLimits.entrySet()) {
            if (!entry.getKey().matcher(requestURI).matches()) continue;
            Integer[] limits = entry.getValue();
            request.setMaxParameterCount(limits[0]);
            if (limits[1] == null) break;
            request.setMaxPartCount(limits[1]);
            request.setMaxPartHeaderSize(limits[2]);
            break;
        }
        this.getNext().invoke(request, response);
    }

    protected File getConfigBase() {
        File configBase = new File(System.getProperty("bes.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        return configBase;
    }

    protected String getHostConfigPath(String resourceName) {
        StringBuffer result = new StringBuffer();
        Container host = null;
        Container engine = null;
        for (Container container = this.getContainer(); container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            result.append(engine.getName()).append('/');
        }
        if (host != null) {
            result.append(host.getName()).append('/');
        }
        result.append(resourceName);
        return result.toString();
    }
}

