/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.webresources;

import com.bes.enterprise.appserver.common.util.FileUtils;
import com.bes.enterprise.appserver.common.util.StringUtils;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.webtier.WebResourceSet;
import com.bes.enterprise.webtier.webresources.DirResourceSet;
import com.bes.enterprise.webtier.webresources.EmptyResourceSet;
import com.bes.enterprise.webtier.webresources.WarResourceSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BesResourceSet
extends EmptyResourceSet {
    private static final Log log = LogFactory.getLog(BesResourceSet.class);
    protected static final StringManager sm = StringManager.getManager(BesResourceSet.class);
    private static final boolean SUPPORT_OPENAS = Boolean.getBoolean("com.bes.enterprise.web.compatibleOpenas");
    private String base;
    private String webAppMount;
    private String extension;
    private String internalPath;
    private boolean readOnly;

    public BesResourceSet() {
        this.setExtension(".war,.car");
        this.setWebAppMount("/");
        this.setInternalPath("/");
        this.setReadOnly(true);
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getWebAppMount() {
        return this.webAppMount;
    }

    public void setWebAppMount(String webAppMount) {
        this.webAppMount = webAppMount;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getInternalPath() {
        return this.internalPath;
    }

    public void setInternalPath(String internalPath) {
        this.internalPath = internalPath;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public List<WebResourceSet> getWarResourceSets() {
        ArrayList<WebResourceSet> result = new ArrayList<WebResourceSet>();
        File baseFile = new File(this.getBase());
        if (!FileUtils.safeIsDirectory(baseFile)) {
            log.error(sm.getString("standardRoot.invalidPath", this.getBase()));
            return result;
        }
        DirResourceSet dirResourceSet = new DirResourceSet();
        dirResourceSet.setBase(baseFile.getAbsolutePath());
        dirResourceSet.setWebAppMount(this.getWebAppMount());
        dirResourceSet.setInternalPath(this.getInternalPath());
        dirResourceSet.setReadOnly(this.getReadOnly());
        result.add(dirResourceSet);
        result.addAll(this.getResourceSetsInternal(baseFile));
        return result;
    }

    private List<WebResourceSet> getResourceSetsInternal(File baseFile) {
        File[] files;
        ArrayList<WebResourceSet> result = new ArrayList<WebResourceSet>();
        if (!FileUtils.safeIsDirectory(baseFile)) {
            log.error(sm.getString("standardRoot.invalidPath", this.getBase()));
            return result;
        }
        for (File f2 : files = baseFile.listFiles()) {
            if (SUPPORT_OPENAS && !f2.isFile()) {
                DirResourceSet dirResourceSet = new DirResourceSet();
                dirResourceSet.setBase(f2.getAbsolutePath());
                dirResourceSet.setWebAppMount(this.getWebAppMount());
                dirResourceSet.setInternalPath(this.getInternalPath());
                dirResourceSet.setReadOnly(this.getReadOnly());
                result.add(dirResourceSet);
                continue;
            }
            if (SUPPORT_OPENAS || !f2.isFile()) continue;
            boolean ok = false;
            Set<String> extensions = StringUtils.parseStringSet(this.extension, ",");
            for (String extension : extensions) {
                if (!f2.getName().endsWith(extension)) continue;
                ok = true;
                break;
            }
            if (!ok) continue;
            WarResourceSet warResourceSet = new WarResourceSet();
            warResourceSet.setBase(f2.getAbsolutePath());
            warResourceSet.setWebAppMount(this.getWebAppMount());
            warResourceSet.setInternalPath(this.getInternalPath());
            warResourceSet.setReadOnly(this.getReadOnly());
            result.add(warResourceSet);
        }
        return result;
    }
}

