/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.webresources;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.http.RequestUtil;
import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.WebResource;
import com.bes.enterprise.webtier.WebResourceLockSet;
import com.bes.enterprise.webtier.WebResourceRoot;
import com.bes.enterprise.webtier.util.ResourceSet;
import com.bes.enterprise.webtier.webresources.AbstractFileResourceSet;
import com.bes.enterprise.webtier.webresources.EmptyResource;
import com.bes.enterprise.webtier.webresources.FileResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;

public class DirResourceSet
extends AbstractFileResourceSet
implements WebResourceLockSet {
    private static final Log log = LogFactory.getLog(DirResourceSet.class);
    private boolean caseSensitive = true;
    private Map<String, WebResourceLockSet.ResourceLock> resourceLocksByPath = new HashMap<String, WebResourceLockSet.ResourceLock>();
    private Object resourceLocksByPathLock = new Object();

    public DirResourceSet() {
        super("/");
    }

    public DirResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath) {
        super(internalPath);
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        if (root.getContext().getAddWebinfClassesResources()) {
            File f2 = new File(base, internalPath);
            if ((f2 = new File(f2, "/WEB-INF/classes/META-INF/resources")).isDirectory()) {
                root.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", f2.getAbsolutePath(), null, "/");
            }
        }
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e2) {
                throw new IllegalStateException(e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResource getResource(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root = this.getRoot();
        if (this.isPathMounted(path, webAppMount)) {
            WebResourceLockSet.ResourceLock lock = this.lockForRead(path);
            try {
                File f2 = this.file(path.substring(webAppMount.length()), false);
                if (f2 == null) {
                    EmptyResource emptyResource = new EmptyResource(root, path);
                    return emptyResource;
                }
                if (!f2.exists()) {
                    EmptyResource emptyResource = new EmptyResource(root, path, f2);
                    return emptyResource;
                }
                if (f2.isDirectory() && path.charAt(path.length() - 1) != '/') {
                    path = path + '/';
                }
                FileResource fileResource = new FileResource(root, path, f2, this.isReadOnly(), this.getManifest(), this, lock.key);
                return fileResource;
            }
            finally {
                this.unlockForRead(lock);
            }
        }
        return new EmptyResource(root, path);
    }

    @Override
    public String[] list(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        if (this.isPathMounted(path, webAppMount)) {
            File f2 = this.file(path.substring(webAppMount.length()), true);
            if (f2 == null) {
                return EMPTY_STRING_ARRAY;
            }
            String[] result = f2.list();
            if (result == null) {
                return EMPTY_STRING_ARRAY;
            }
            return result;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (webAppMount.startsWith(path)) {
            int i2 = webAppMount.indexOf(47, path.length());
            if (i2 == -1) {
                return new String[]{webAppMount.substring(path.length())};
            }
            return new String[]{webAppMount.substring(path.length(), i2)};
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> listWebAppPaths(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        ResourceSet<String> result = new ResourceSet<String>();
        if (this.isPathMounted(path, webAppMount)) {
            File[] list;
            File f2 = this.file(path.substring(webAppMount.length()), true);
            if (f2 != null && (list = f2.listFiles()) != null) {
                for (File entry : list) {
                    if (!this.getRoot().getAllowLinking()) {
                        boolean symlink = true;
                        String absPath = null;
                        String canPath = null;
                        try {
                            absPath = entry.getAbsolutePath();
                            canPath = entry.getCanonicalPath();
                            if (absPath.equals(canPath)) {
                                symlink = false;
                            }
                        }
                        catch (IOException ioe) {
                            canPath = "Unknown";
                        }
                        if (symlink) {
                            this.logIgnoredSymlink(this.getRoot().getContext().getName(), absPath, canPath);
                            continue;
                        }
                    }
                    StringBuilder sb = new StringBuilder(path);
                    if (path.charAt(path.length() - 1) != '/') {
                        sb.append('/');
                    }
                    sb.append(entry.getName());
                    if (entry.isDirectory()) {
                        sb.append('/');
                    }
                    result.add(sb.toString());
                }
            }
        } else {
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (webAppMount.startsWith(path)) {
                int i2 = webAppMount.indexOf(47, path.length());
                if (i2 == -1) {
                    result.add(webAppMount + "/");
                } else {
                    result.add(webAppMount.substring(0, i2 + 1));
                }
            }
        }
        result.setLocked(true);
        return result;
    }

    @Override
    public boolean mkdir(String path) {
        this.checkPath(path);
        if (this.isReadOnly()) {
            return false;
        }
        String webAppMount = this.getWebAppMount();
        if (this.isPathMounted(path, webAppMount)) {
            File f2 = this.file(path.substring(webAppMount.length()), false);
            if (f2 == null) {
                return false;
            }
            return f2.mkdir();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean write(String path, InputStream is, boolean overwrite) {
        this.checkPath(path);
        if (is == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (path.endsWith("/")) {
            return false;
        }
        String webAppMount = this.getWebAppMount();
        if (this.isPathMounted(path, webAppMount)) {
            return false;
        }
        File dest = null;
        WebResourceLockSet.ResourceLock lock = this.lockForWrite(path);
        try {
            dest = this.file(path.substring(webAppMount.length()), false);
            if (dest == null) {
                boolean bl = false;
                return bl;
            }
            if (dest.exists() && !overwrite) {
                boolean bl = false;
                return bl;
            }
            try {
                if (overwrite) {
                    Files.copy(is, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    Files.copy(is, dest.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException ioe) {
                boolean bl = false;
                this.unlockForWrite(lock);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.unlockForWrite(lock);
        }
    }

    @Override
    protected void checkType(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(sm.getString("dirResourceSet.notDirectory", this.getBase(), File.separator, this.getInternalPath()));
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        File mf;
        super.initInternal();
        this.caseSensitive = this.isCaseSensitive();
        if (this.getWebAppMount().equals("") && (mf = this.file("META-INF/MANIFEST.MF", true)) != null && mf.isFile()) {
            try (FileInputStream fis = new FileInputStream(mf);){
                this.setManifest(new Manifest(fis));
            }
            catch (IOException e2) {
                log.warn(sm.getString("dirResourceSet.manifestFail", mf.getAbsolutePath()), e2);
            }
        }
    }

    private boolean isCaseSensitive() {
        try {
            String canonicalPath = this.getFileBase().getCanonicalPath();
            File upper = new File(canonicalPath.toUpperCase(Locale.ENGLISH));
            if (!canonicalPath.equals(upper.getCanonicalPath())) {
                return true;
            }
            File lower = new File(canonicalPath.toLowerCase(Locale.ENGLISH));
            if (!canonicalPath.equals(lower.getCanonicalPath())) {
                return true;
            }
        }
        catch (IOException ioe) {
            log.warn(sm.getString("dirResourceSet.isCaseSensitive.fail", this.getFileBase().getAbsolutePath()), ioe);
        }
        return false;
    }

    private String getLockKey(String path) {
        String normalisedPath = RequestUtil.normalize(path);
        if (this.caseSensitive) {
            return normalisedPath;
        }
        return normalisedPath.toLowerCase(Locale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResourceLockSet.ResourceLock lockForRead(String path) {
        String key = this.getLockKey(path);
        WebResourceLockSet.ResourceLock resourceLock = null;
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            resourceLock = this.resourceLocksByPath.get(key);
            if (resourceLock == null) {
                resourceLock = new WebResourceLockSet.ResourceLock(key);
                this.resourceLocksByPath.put(key, resourceLock);
            }
            resourceLock.count.incrementAndGet();
        }
        resourceLock.reentrantLock.readLock().lock();
        return resourceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockForRead(WebResourceLockSet.ResourceLock resourceLock) {
        resourceLock.reentrantLock.readLock().unlock();
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            if (resourceLock.count.decrementAndGet() == 0) {
                this.resourceLocksByPath.remove(resourceLock.key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebResourceLockSet.ResourceLock lockForWrite(String path) {
        String key = this.getLockKey(path);
        WebResourceLockSet.ResourceLock resourceLock = null;
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            resourceLock = this.resourceLocksByPath.get(key);
            if (resourceLock == null) {
                resourceLock = new WebResourceLockSet.ResourceLock(key);
                this.resourceLocksByPath.put(key, resourceLock);
            }
            resourceLock.count.incrementAndGet();
        }
        resourceLock.reentrantLock.writeLock().lock();
        return resourceLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockForWrite(WebResourceLockSet.ResourceLock resourceLock) {
        resourceLock.reentrantLock.writeLock().unlock();
        Object object = this.resourceLocksByPathLock;
        synchronized (object) {
            if (resourceLock.count.decrementAndGet() == 0) {
                this.resourceLocksByPath.remove(resourceLock.key);
            }
        }
    }
}

