/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.webtier.webresources;

import com.bes.enterprise.webtier.LifecycleException;
import com.bes.enterprise.webtier.WebResource;
import com.bes.enterprise.webtier.WebResourceRoot;
import com.bes.enterprise.webtier.util.ResourceSet;
import com.bes.enterprise.webtier.webresources.AbstractFileResourceSet;
import com.bes.enterprise.webtier.webresources.EmptyResource;
import com.bes.enterprise.webtier.webresources.FileResource;
import com.bes.enterprise.webtier.webresources.VirtualResource;
import java.io.File;
import java.io.InputStream;
import java.util.Set;

public class FileResourceSet
extends AbstractFileResourceSet {
    public FileResourceSet() {
        super("/");
    }

    public FileResourceSet(WebResourceRoot root, String webAppMount, String base, String internalPath) {
        super(internalPath);
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e2) {
                throw new IllegalStateException(e2);
            }
        }
    }

    @Override
    public WebResource getResource(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root = this.getRoot();
        if (path.equals(webAppMount)) {
            File f2 = this.file("", true);
            if (f2 == null) {
                return new EmptyResource(root, path);
            }
            return new FileResource(root, path, f2, this.isReadOnly(), null);
        }
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        if (webAppMount.startsWith(path)) {
            String name = path.substring(0, path.length() - 1);
            if ((name = name.substring(name.lastIndexOf(47) + 1)).length() > 0) {
                return new VirtualResource(root, path, name);
            }
        }
        return new EmptyResource(root, path);
    }

    @Override
    public String[] list(String path) {
        String webAppMount;
        this.checkPath(path);
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        if ((webAppMount = this.getWebAppMount()).startsWith(path)) {
            if ((webAppMount = webAppMount.substring(path.length())).equals(this.getFileBase().getName())) {
                return new String[]{this.getFileBase().getName()};
            }
            int i2 = webAppMount.indexOf(47);
            if (i2 > 0) {
                return new String[]{webAppMount.substring(0, i2)};
            }
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> listWebAppPaths(String path) {
        String webAppMount;
        this.checkPath(path);
        ResourceSet<String> result = new ResourceSet<String>();
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        if ((webAppMount = this.getWebAppMount()).startsWith(path)) {
            if ((webAppMount = webAppMount.substring(path.length())).equals(this.getFileBase().getName())) {
                result.add(path + this.getFileBase().getName());
            } else {
                int i2 = webAppMount.indexOf(47);
                if (i2 > 0) {
                    result.add(path + webAppMount.substring(0, i2 + 1));
                }
            }
        }
        result.setLocked(true);
        return result;
    }

    @Override
    public boolean mkdir(String path) {
        this.checkPath(path);
        return false;
    }

    @Override
    public boolean write(String path, InputStream is, boolean overwrite) {
        this.checkPath(path);
        return false;
    }

    @Override
    protected void checkType(File file) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(sm.getString("fileResourceSet.notFile", this.getBase(), File.separator, this.getInternalPath()));
        }
    }
}

