/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.el.ELException;
import javax.el.MethodNotFoundException;
import org.apache.el.lang.ELSupport;
import org.apache.el.lang.EvaluationContext;
import org.apache.el.util.JreCompat;
import org.apache.el.util.MessageFactory;

public class ReflectionUtil {
    protected static final String[] PRIMITIVE_NAMES = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
    protected static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Void.TYPE};

    private ReflectionUtil() {
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        if (null == name || "".equals(name)) {
            return null;
        }
        Class<?> c2 = ReflectionUtil.forNamePrimitive(name);
        if (c2 == null) {
            if (name.endsWith("[]")) {
                String nc = name.substring(0, name.length() - 2);
                c2 = Class.forName(nc, true, ReflectionUtil.getContextClassLoader());
                c2 = Array.newInstance(c2, 0).getClass();
            } else {
                c2 = Class.forName(name, true, ReflectionUtil.getContextClassLoader());
            }
        }
        return c2;
    }

    protected static Class<?> forNamePrimitive(String name) {
        int p2;
        if (name.length() <= 8 && (p2 = Arrays.binarySearch(PRIMITIVE_NAMES, name)) >= 0) {
            return PRIMITIVES[p2];
        }
        return null;
    }

    public static Class<?>[] toTypeArray(String[] s2) throws ClassNotFoundException {
        if (s2 == null) {
            return null;
        }
        Class[] c2 = new Class[s2.length];
        for (int i2 = 0; i2 < s2.length; ++i2) {
            c2[i2] = ReflectionUtil.forName(s2[i2]);
        }
        return c2;
    }

    public static String[] toTypeNameArray(Class<?>[] c2) {
        if (c2 == null) {
            return null;
        }
        String[] s2 = new String[c2.length];
        for (int i2 = 0; i2 < c2.length; ++i2) {
            s2[i2] = c2[i2].getName();
        }
        return s2;
    }

    public static Method getMethod(EvaluationContext ctx, Object base, Object property, Class<?>[] paramTypes, Object[] paramValues) throws MethodNotFoundException {
        if (base == null || property == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        String methodName = property instanceof String ? (String)property : property.toString();
        int paramCount = paramTypes == null ? 0 : paramTypes.length;
        Method[] methods = base.getClass().getMethods();
        HashMap<Method, MatchResult> candidates = new HashMap<Method, MatchResult>();
        for (Method m2 : methods) {
            if (!m2.getName().equals(methodName)) continue;
            Class<?>[] mParamTypes = m2.getParameterTypes();
            int mParamCount = mParamTypes == null ? 0 : mParamTypes.length;
            if (!m2.isVarArgs() && paramCount != mParamCount || m2.isVarArgs() && paramCount < mParamCount - 1 || m2.isVarArgs() && paramCount == mParamCount && paramValues != null && paramValues.length > paramCount && !paramTypes[mParamCount - 1].isArray() || m2.isVarArgs() && paramCount > mParamCount && paramValues != null && paramValues.length != paramCount || !m2.isVarArgs() && paramValues != null && paramCount != paramValues.length) continue;
            int exactMatch = 0;
            int assignableMatch = 0;
            int coercibleMatch = 0;
            boolean noMatch = false;
            block1: for (int i2 = 0; i2 < mParamCount; ++i2) {
                if (m2.isVarArgs() && i2 == mParamCount - 1) {
                    if (i2 == paramCount || paramValues != null && paramValues.length == i2) {
                        ++assignableMatch;
                        break;
                    }
                    Class<?> varType = mParamTypes[i2].getComponentType();
                    for (int j2 = i2; j2 < paramCount; ++j2) {
                        if (ReflectionUtil.isAssignableFrom(paramTypes[j2], varType)) {
                            ++assignableMatch;
                            continue;
                        }
                        if (paramValues == null) {
                            noMatch = true;
                            continue block1;
                        }
                        if (ReflectionUtil.isCoercibleFrom(ctx, paramValues[j2], varType)) {
                            ++coercibleMatch;
                            continue;
                        }
                        noMatch = true;
                        continue block1;
                    }
                    continue;
                }
                if (mParamTypes[i2].equals(paramTypes[i2])) {
                    ++exactMatch;
                    continue;
                }
                if (paramTypes[i2] != null && ReflectionUtil.isAssignableFrom(paramTypes[i2], mParamTypes[i2])) {
                    ++assignableMatch;
                    continue;
                }
                if (paramValues == null) {
                    noMatch = true;
                    break;
                }
                if (ReflectionUtil.isCoercibleFrom(ctx, paramValues[i2], mParamTypes[i2])) {
                    ++coercibleMatch;
                    continue;
                }
                noMatch = true;
                break;
            }
            if (noMatch) continue;
            if (exactMatch == paramCount) {
                return ReflectionUtil.getMethod(base.getClass(), base, m2);
            }
            candidates.put(m2, new MatchResult(exactMatch, assignableMatch, coercibleMatch, m2.isBridge()));
        }
        MatchResult bestMatch = new MatchResult(0, 0, 0, false);
        Method match = null;
        boolean multiple = false;
        for (Map.Entry entry : candidates.entrySet()) {
            int cmp = ((MatchResult)entry.getValue()).compareTo(bestMatch);
            if (cmp > 0 || match == null) {
                bestMatch = (MatchResult)entry.getValue();
                match = (Method)entry.getKey();
                multiple = false;
                continue;
            }
            if (cmp != 0) continue;
            multiple = true;
        }
        if (multiple && (match = bestMatch.getExact() == paramCount - 1 ? ReflectionUtil.resolveAmbiguousMethod(candidates.keySet(), paramTypes) : null) == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.ambiguous", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        if (match == null) {
            throw new MethodNotFoundException(MessageFactory.get("error.method.notfound", base, property, ReflectionUtil.paramString(paramTypes)));
        }
        return ReflectionUtil.getMethod(base.getClass(), base, match);
    }

    /*
     * WARNING - void declaration
     */
    private static Method resolveAmbiguousMethod(Set<Method> candidates, Class<?>[] paramTypes) {
        void var6_14;
        Method m2 = candidates.iterator().next();
        int nonMatchIndex = 0;
        Class<?> nonMatchClass = null;
        for (int i2 = 0; i2 < paramTypes.length; ++i2) {
            if (m2.getParameterTypes()[i2] == paramTypes[i2]) continue;
            nonMatchIndex = i2;
            nonMatchClass = paramTypes[i2];
            break;
        }
        if (nonMatchClass == null) {
            return null;
        }
        for (Method method : candidates) {
            if (method.getParameterTypes()[nonMatchIndex] != paramTypes[nonMatchIndex]) continue;
            return null;
        }
        for (Class superClass = nonMatchClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            for (Method c3 : candidates) {
                if (!c3.getParameterTypes()[nonMatchIndex].equals(superClass)) continue;
                return c3;
            }
        }
        Object var6_10 = null;
        if (Number.class.isAssignableFrom(nonMatchClass)) {
            for (Method c4 : candidates) {
                void var6_11;
                Class<?> candidateType = c4.getParameterTypes()[nonMatchIndex];
                if (!Number.class.isAssignableFrom(candidateType) && !candidateType.isPrimitive()) continue;
                if (var6_11 == null) {
                    Method method = c4;
                    continue;
                }
                Object var6_13 = null;
                break;
            }
        }
        return var6_14;
    }

    private static boolean isAssignableFrom(Class<?> src, Class<?> target) {
        if (src == null) {
            return true;
        }
        Class<Object> targetClass = target.isPrimitive() ? (target == Boolean.TYPE ? Boolean.class : (target == Character.TYPE ? Character.class : (target == Byte.TYPE ? Byte.class : (target == Short.TYPE ? Short.class : (target == Integer.TYPE ? Integer.class : (target == Long.TYPE ? Long.class : (target == Float.TYPE ? Float.class : Double.class))))))) : target;
        return targetClass.isAssignableFrom(src);
    }

    private static boolean isCoercibleFrom(EvaluationContext ctx, Object src, Class<?> target) {
        try {
            ELSupport.coerceToType(ctx, src, target);
        }
        catch (ELException e2) {
            return false;
        }
        return true;
    }

    private static Method getMethod(Class<?> type, Object base, Method m2) {
        JreCompat jreCompat = JreCompat.getInstance();
        if (m2 == null || Modifier.isPublic(type.getModifiers()) && (jreCompat.canAcccess(base, m2) || base != null && jreCompat.canAcccess(null, m2))) {
            return m2;
        }
        Class<?>[] inf = type.getInterfaces();
        Method mp = null;
        for (int i2 = 0; i2 < inf.length; ++i2) {
            try {
                mp = inf[i2].getMethod(m2.getName(), m2.getParameterTypes());
                mp = ReflectionUtil.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        Class<?> sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m2.getName(), m2.getParameterTypes());
                mp = ReflectionUtil.getMethod(mp.getDeclaringClass(), base, mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private static final String paramString(Class<?>[] types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < types.length; ++i2) {
                if (types[i2] == null) {
                    sb.append("null, ");
                    continue;
                }
                sb.append(types[i2].getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader tccl;
        if (System.getSecurityManager() != null) {
            PrivilegedGetTccl pa = new PrivilegedGetTccl();
            tccl = AccessController.doPrivileged(pa);
        } else {
            tccl = Thread.currentThread().getContextClassLoader();
        }
        return tccl;
    }

    private static class MatchResult
    implements Comparable<MatchResult> {
        private final int exact;
        private final int assignable;
        private final int coercible;
        private final boolean bridge;

        public MatchResult(int exact, int assignable, int coercible, boolean bridge) {
            this.exact = exact;
            this.assignable = assignable;
            this.coercible = coercible;
            this.bridge = bridge;
        }

        public int getExact() {
            return this.exact;
        }

        public int getAssignable() {
            return this.assignable;
        }

        public int getCoercible() {
            return this.coercible;
        }

        public boolean isBridge() {
            return this.bridge;
        }

        @Override
        public int compareTo(MatchResult o2) {
            int cmp = Integer.compare(this.getExact(), o2.getExact());
            if (cmp == 0 && (cmp = Integer.compare(this.getAssignable(), o2.getAssignable())) == 0 && (cmp = Integer.compare(this.getCoercible(), o2.getCoercible())) == 0) {
                cmp = Boolean.compare(o2.isBridge(), this.isBridge());
            }
            return cmp;
        }

        public boolean equals(Object o2) {
            return o2 == this || null != o2 && this.getClass().equals(o2.getClass()) && ((MatchResult)o2).getExact() == this.getExact() && ((MatchResult)o2).getAssignable() == this.getAssignable() && ((MatchResult)o2).getCoercible() == this.getCoercible() && ((MatchResult)o2).isBridge() == this.isBridge();
        }

        public int hashCode() {
            return (this.isBridge() ? 0x1000000 : 0) ^ this.getExact() << 16 ^ this.getAssignable() << 8 ^ this.getCoercible();
        }
    }

    private static class PrivilegedGetTccl
    implements PrivilegedAction<ClassLoader> {
        private PrivilegedGetTccl() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

