/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class Validation {
    private static final String[] invalidIdentifiers = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    private static final boolean SKIP_IDENTIFIER_CHECK;

    private Validation() {
    }

    public static boolean isIdentifier(String key) {
        if (SKIP_IDENTIFIER_CHECK) {
            return true;
        }
        if (key == null || key.length() == 0) {
            return false;
        }
        int i2 = 0;
        int j2 = invalidIdentifiers.length;
        while (i2 < j2) {
            int k2 = i2 + j2 >>> 1;
            int result = invalidIdentifiers[k2].compareTo(key);
            if (result == 0) {
                return false;
            }
            if (result < 0) {
                i2 = k2 + 1;
                continue;
            }
            j2 = k2;
        }
        if (!Character.isJavaIdentifierStart(key.charAt(0))) {
            return false;
        }
        for (int idx = 1; idx < key.length(); ++idx) {
            if (Character.isJavaIdentifierPart(key.charAt(idx))) continue;
            return false;
        }
        return true;
    }

    static {
        String skipIdentifierCheckStr = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("org.apache.el.parser.SKIP_IDENTIFIER_CHECK", "true");
            }
        }) : System.getProperty("org.apache.el.parser.SKIP_IDENTIFIER_CHECK", "true");
        SKIP_IDENTIFIER_CHECK = Boolean.parseBoolean(skipIdentifierCheckStr);
    }
}

