/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.websocket;

import com.bes.enterprise.web.util.codec.binary.Base64;
import com.bes.enterprise.web.websocket.AuthenticationException;
import com.bes.enterprise.web.websocket.Authenticator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class BasicAuthenticator
extends Authenticator {
    public static final String schemeName = "basic";
    public static final String charsetparam = "charset";

    @Override
    public String getAuthorization(String requestUri, String WWWAuthenticate, Map<String, Object> userProperties) throws AuthenticationException {
        String userName = (String)userProperties.get("com.bes.enterprise.web.websocket.WS_AUTHENTICATION_USER_NAME");
        String password = (String)userProperties.get("com.bes.enterprise.web.websocket.WS_AUTHENTICATION_PASSWORD");
        if (userName == null || password == null) {
            throw new AuthenticationException("Failed to perform Basic authentication due to  missing user/password");
        }
        Map<String, String> wwwAuthenticate = this.parseWWWAuthenticateHeader(WWWAuthenticate);
        String userPass = userName + ":" + password;
        Charset charset = wwwAuthenticate.get(charsetparam) != null && wwwAuthenticate.get(charsetparam).equalsIgnoreCase("UTF-8") ? StandardCharsets.UTF_8 : StandardCharsets.ISO_8859_1;
        String base64 = Base64.encodeBase64String((byte[])userPass.getBytes(charset));
        return " Basic " + base64;
    }

    @Override
    public String getSchemeName() {
        return schemeName;
    }
}

