/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.websocket;

import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.websocket.Constants;
import com.bes.enterprise.web.websocket.PerMessageDeflate;
import com.bes.enterprise.web.websocket.Transformation;
import java.util.List;
import javax.websocket.Extension;

public class TransformationFactory {
    private static final StringManager sm = StringManager.getManager(TransformationFactory.class);
    private static final TransformationFactory factory = new TransformationFactory();

    private TransformationFactory() {
    }

    public static TransformationFactory getInstance() {
        return factory;
    }

    public Transformation create(String name, List<List<Extension.Parameter>> preferences, boolean isServer) {
        if ("permessage-deflate".equals(name)) {
            return PerMessageDeflate.negotiate(preferences, isServer);
        }
        if (Constants.ALLOW_UNSUPPORTED_EXTENSIONS) {
            return null;
        }
        throw new IllegalArgumentException(sm.getString("transformerFactory.unsupportedExtension", new Object[]{name}));
    }
}

