/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.websocket;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.InstanceManager;
import com.bes.enterprise.web.util.buf.StringUtils;
import com.bes.enterprise.web.util.codec.binary.Base64;
import com.bes.enterprise.web.util.collections.CaseInsensitiveKeyMap;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.util.security.KeyStoreUtil;
import com.bes.enterprise.web.websocket.AsyncChannelGroupUtil;
import com.bes.enterprise.web.websocket.AsyncChannelWrapper;
import com.bes.enterprise.web.websocket.AsyncChannelWrapperNonSecure;
import com.bes.enterprise.web.websocket.AsyncChannelWrapperSecure;
import com.bes.enterprise.web.websocket.AuthenticationException;
import com.bes.enterprise.web.websocket.Authenticator;
import com.bes.enterprise.web.websocket.AuthenticatorFactory;
import com.bes.enterprise.web.websocket.BackgroundProcess;
import com.bes.enterprise.web.websocket.BackgroundProcessManager;
import com.bes.enterprise.web.websocket.Constants;
import com.bes.enterprise.web.websocket.Transformation;
import com.bes.enterprise.web.websocket.TransformationFactory;
import com.bes.enterprise.web.websocket.Util;
import com.bes.enterprise.web.websocket.WsFrameClient;
import com.bes.enterprise.web.websocket.WsHandshakeResponse;
import com.bes.enterprise.web.websocket.WsRemoteEndpointImplClient;
import com.bes.enterprise.web.websocket.WsSession;
import com.bes.enterprise.web.websocket.pojo.PojoEndpointClient;
import com.bes.enterprise.web.websocket.pojo.PojoEndpointServer;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class WsWebSocketContainer
implements WebSocketContainer,
BackgroundProcess {
    private static final StringManager sm = StringManager.getManager(WsWebSocketContainer.class);
    private static final boolean SCOPING_GET_OPEN_SESSION_TO_ENDPOINT_CLASS = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.web.websocket.SCOPING_GET_OPEN_SESSION_TO_ENDPOINT_CLASS", "false"));
    private static final Random RANDOM = new Random();
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] GET_BYTES = "GET ".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] ROOT_URI_BYTES = "/".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] HTTP_VERSION_BYTES = " HTTP/1.1\r\n".getBytes(StandardCharsets.ISO_8859_1);
    private volatile AsynchronousChannelGroup asynchronousChannelGroup = null;
    private final Object asynchronousChannelGroupLock = new Object();
    private final Log log = LogFactory.getLog(WsWebSocketContainer.class);
    private final Map<Object, Set<WsSession>> endpointSessionMap = new HashMap<Object, Set<WsSession>>();
    private final Map<WsSession, WsSession> sessions = new ConcurrentHashMap<WsSession, WsSession>();
    private final Object endPointSessionMapLock = new Object();
    private long defaultAsyncTimeout = -1L;
    private int maxBinaryMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
    private int maxTextMessageBufferSize = Constants.DEFAULT_BUFFER_SIZE;
    private volatile long defaultMaxSessionIdleTimeout = 0L;
    private int backgroundProcessCount = 0;
    private int processPeriod = Constants.DEFAULT_PROCESS_PERIOD;
    private InstanceManager instanceManager;

    InstanceManager getInstanceManager() {
        return this.instanceManager;
    }

    protected void setInstanceManager(InstanceManager instanceManager) {
        this.instanceManager = instanceManager;
    }

    @Override
    public Session connectToServer(Object pojo, URI path) throws DeploymentException {
        ClientEndpoint annotation = pojo.getClass().getAnnotation(ClientEndpoint.class);
        if (annotation == null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.missingAnnotation", new Object[]{pojo.getClass().getName()}));
        }
        PojoEndpointClient ep = new PojoEndpointClient(pojo, Arrays.asList(annotation.decoders()));
        Class<? extends ClientEndpointConfig.Configurator> configuratorClazz = annotation.configurator();
        ClientEndpointConfig.Configurator configurator = null;
        if (!ClientEndpointConfig.Configurator.class.equals(configuratorClazz)) {
            try {
                configurator = configuratorClazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.defaultConfiguratorFail"), e);
            }
        }
        ClientEndpointConfig.Builder builder = ClientEndpointConfig.Builder.create();
        if (configurator != null) {
            builder.configurator(configurator);
        }
        ClientEndpointConfig config = builder.decoders(Arrays.asList(annotation.decoders())).encoders(Arrays.asList(annotation.encoders())).preferredSubprotocols(Arrays.asList(annotation.subprotocols())).build();
        return this.connectToServer(ep, config, path);
    }

    @Override
    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException {
        Object pojo;
        try {
            pojo = annotatedEndpointClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{annotatedEndpointClass.getName()}), e);
        }
        return this.connectToServer(pojo, path);
    }

    @Override
    public Session connectToServer(Class<? extends Endpoint> clazz, ClientEndpointConfig clientEndpointConfiguration, URI path) throws DeploymentException {
        Endpoint endpoint;
        try {
            endpoint = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.endpointCreateFail", new Object[]{clazz.getName()}), e);
        }
        return this.connectToServer(endpoint, clientEndpointConfiguration, path);
    }

    @Override
    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig clientEndpointConfiguration, URI path) throws DeploymentException {
        return this.connectToServerRecursive(endpoint, clientEndpointConfiguration, path, new HashSet<URI>());
    }

    private Session connectToServerRecursive(Endpoint endpoint, ClientEndpointConfig clientEndpointConfiguration, URI path, Set<URI> redirectSet) throws DeploymentException {
        String subProtocol;
        AsynchronousSocketChannel socketChannel;
        URI proxyPath;
        boolean secure = false;
        ByteBuffer proxyConnect = null;
        String scheme = path.getScheme();
        if ("ws".equalsIgnoreCase(scheme)) {
            proxyPath = URI.create("http" + path.toString().substring(2));
        } else if ("wss".equalsIgnoreCase(scheme)) {
            proxyPath = URI.create("https" + path.toString().substring(3));
            secure = true;
        } else {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.pathWrongScheme", new Object[]{scheme}));
        }
        String host = path.getHost();
        if (host == null) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.pathNoHost"));
        }
        int port = path.getPort();
        SocketAddress sa = null;
        List<Proxy> proxies = ProxySelector.getDefault().select(proxyPath);
        Proxy selectedProxy = null;
        for (Proxy proxy : proxies) {
            SocketAddress inet;
            if (!proxy.type().equals((Object)Proxy.Type.HTTP)) continue;
            sa = proxy.address();
            if (sa instanceof InetSocketAddress && ((InetSocketAddress)(inet = sa)).isUnresolved()) {
                sa = new InetSocketAddress(((InetSocketAddress)inet).getHostName(), ((InetSocketAddress)inet).getPort());
            }
            selectedProxy = proxy;
            break;
        }
        if (port == -1) {
            port = "ws".equalsIgnoreCase(scheme) ? 80 : 443;
        }
        if (sa == null) {
            sa = new InetSocketAddress(host, port);
        } else {
            proxyConnect = WsWebSocketContainer.createProxyRequest(host, port);
        }
        Map<String, List<String>> reqHeaders = WsWebSocketContainer.createRequestHeaders(host, port, secure, clientEndpointConfiguration);
        clientEndpointConfiguration.getConfigurator().beforeRequest(reqHeaders);
        if (Constants.DEFAULT_ORIGIN_HEADER_VALUE != null && !reqHeaders.containsKey("Origin")) {
            ArrayList<String> originValues = new ArrayList<String>(1);
            originValues.add(Constants.DEFAULT_ORIGIN_HEADER_VALUE);
            reqHeaders.put("Origin", originValues);
        }
        ByteBuffer request = WsWebSocketContainer.createRequest(path, reqHeaders);
        try {
            socketChannel = AsynchronousSocketChannel.open(this.getAsynchronousChannelGroup());
        }
        catch (IOException ioe) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.asynchronousSocketChannelFail"), ioe);
        }
        Map<String, Object> userProperties = clientEndpointConfiguration.getUserProperties();
        long timeout = 5000L;
        String timeoutValue = (String)userProperties.get("com.bes.enterprise.web.websocket.IO_TIMEOUT_MS");
        if (timeoutValue != null) {
            timeout = Long.valueOf(timeoutValue).intValue();
        }
        ByteBuffer response = ByteBuffer.allocate(this.getDefaultMaxBinaryMessageBufferSize());
        boolean success = false;
        ArrayList<Extension> extensionsAgreed = new ArrayList<Extension>();
        Transformation transformation = null;
        Future<Void> fConnect = socketChannel.connect(sa);
        AsyncChannelWrapper channel = null;
        if (proxyConnect != null) {
            try {
                fConnect.get(timeout, TimeUnit.MILLISECONDS);
                channel = new AsyncChannelWrapperNonSecure(socketChannel);
                WsWebSocketContainer.writeRequest(channel, proxyConnect, timeout);
                HttpResponse httpResponse = this.processResponse(response, channel, timeout);
                if (httpResponse.getStatus() != 200) {
                    throw new DeploymentException(sm.getString("wsWebSocketContainer.proxyConnectFail", new Object[]{selectedProxy, Integer.toString(httpResponse.getStatus())}));
                }
            }
            catch (EOFException | InterruptedException | ExecutionException | TimeoutException e) {
                if (channel != null) {
                    channel.close();
                }
                throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), e);
            }
        }
        if (secure) {
            SSLEngine sslEngine = this.createSSLEngine(userProperties, host, port);
            channel = new AsyncChannelWrapperSecure(socketChannel, sslEngine);
        } else if (channel == null) {
            channel = new AsyncChannelWrapperNonSecure(socketChannel);
        }
        try {
            fConnect.get(timeout, TimeUnit.MILLISECONDS);
            Future<Void> fHandshake = channel.handshake();
            fHandshake.get(timeout, TimeUnit.MILLISECONDS);
            WsWebSocketContainer.writeRequest(channel, request, timeout);
            HttpResponse httpResponse = this.processResponse(response, channel, timeout);
            int maxRedirects = 20;
            String maxRedirectsValue = (String)userProperties.get("com.bes.enterprise.web.websocket.MAX_REDIRECTIONS");
            if (maxRedirectsValue != null) {
                maxRedirects = Integer.parseInt(maxRedirectsValue);
            }
            if (httpResponse.status != 101) {
                if (WsWebSocketContainer.isRedirectStatus(httpResponse.status)) {
                    String redirectScheme;
                    List<String> locationHeader = httpResponse.getHandshakeResponse().getHeaders().get("Location");
                    if (locationHeader == null || locationHeader.isEmpty() || locationHeader.get(0) == null || locationHeader.get(0).isEmpty()) {
                        throw new DeploymentException(sm.getString("wsWebSocketContainer.missingLocationHeader", new Object[]{Integer.toString(httpResponse.status)}));
                    }
                    URI redirectLocation = URI.create(locationHeader.get(0)).normalize();
                    if (!redirectLocation.isAbsolute()) {
                        redirectLocation = path.resolve(redirectLocation);
                    }
                    if ((redirectScheme = redirectLocation.getScheme().toLowerCase()).startsWith("http")) {
                        redirectLocation = new URI(redirectScheme.replace("http", "ws"), redirectLocation.getUserInfo(), redirectLocation.getHost(), redirectLocation.getPort(), redirectLocation.getPath(), redirectLocation.getQuery(), redirectLocation.getFragment());
                    }
                    if (!redirectSet.add(redirectLocation) || redirectSet.size() > maxRedirects) {
                        throw new DeploymentException(sm.getString("wsWebSocketContainer.redirectThreshold", new Object[]{redirectLocation, Integer.toString(redirectSet.size()), Integer.toString(maxRedirects)}));
                    }
                    Session session = this.connectToServerRecursive(endpoint, clientEndpointConfiguration, redirectLocation, redirectSet);
                    return session;
                }
                if (httpResponse.status == 401) {
                    if (userProperties.get("Authorization") != null) {
                        throw new DeploymentException(sm.getString("wsWebSocketContainer.failedAuthentication", new Object[]{httpResponse.status}));
                    }
                    List<String> wwwAuthenticateHeaders = httpResponse.getHandshakeResponse().getHeaders().get("WWW-Authenticate");
                    if (wwwAuthenticateHeaders == null || wwwAuthenticateHeaders.isEmpty() || wwwAuthenticateHeaders.get(0) == null || wwwAuthenticateHeaders.get(0).isEmpty()) {
                        throw new DeploymentException(sm.getString("wsWebSocketContainer.missingWWWAuthenticateHeader", new Object[]{Integer.toString(httpResponse.status)}));
                    }
                    String authScheme = wwwAuthenticateHeaders.get(0).split("\\s+", 2)[0];
                    String requestUri = new String(request.array(), StandardCharsets.ISO_8859_1).split("\\s", 3)[1];
                    Authenticator auth = AuthenticatorFactory.getAuthenticator(authScheme);
                    if (auth == null) {
                        throw new DeploymentException(sm.getString("wsWebSocketContainer.unsupportedAuthScheme", new Object[]{httpResponse.status, authScheme}));
                    }
                    userProperties.put("Authorization", auth.getAuthorization(requestUri, wwwAuthenticateHeaders.get(0), userProperties));
                    Session session = this.connectToServerRecursive(endpoint, clientEndpointConfiguration, path, redirectSet);
                    return session;
                }
                throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{Integer.toString(httpResponse.status)}));
            }
            HandshakeResponse handshakeResponse = httpResponse.getHandshakeResponse();
            clientEndpointConfiguration.getConfigurator().afterResponse(handshakeResponse);
            List<String> protocolHeaders = handshakeResponse.getHeaders().get("Sec-WebSocket-Protocol");
            if (protocolHeaders == null || protocolHeaders.size() == 0) {
                subProtocol = null;
            } else if (protocolHeaders.size() == 1) {
                subProtocol = protocolHeaders.get(0);
            } else {
                throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidSubProtocol"));
            }
            List<String> extHeaders = handshakeResponse.getHeaders().get("Sec-WebSocket-Extensions");
            if (extHeaders != null) {
                for (String extHeader : extHeaders) {
                    Util.parseExtensionHeader(extensionsAgreed, extHeader);
                }
            }
            TransformationFactory factory = TransformationFactory.getInstance();
            for (Extension extension : extensionsAgreed) {
                ArrayList<List<Extension.Parameter>> wrapper = new ArrayList<List<Extension.Parameter>>(1);
                wrapper.add(extension.getParameters());
                Transformation t = factory.create(extension.getName(), wrapper, false);
                if (t == null) {
                    throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidExtensionParameters"));
                }
                if (transformation == null) {
                    transformation = t;
                    continue;
                }
                transformation.setNext(t);
            }
            success = true;
        }
        catch (AuthenticationException | EOFException | InterruptedException | URISyntaxException | ExecutionException | TimeoutException | SSLException e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.httpRequestFailed"), e);
        }
        finally {
            if (!success) {
                channel.close();
            }
        }
        WsRemoteEndpointImplClient wsRemoteEndpointClient = new WsRemoteEndpointImplClient(channel);
        WsSession wsSession = new WsSession(endpoint, wsRemoteEndpointClient, this, null, null, null, null, null, extensionsAgreed, subProtocol, Collections.emptyMap(), secure, clientEndpointConfiguration);
        WsFrameClient wsFrameClient = new WsFrameClient(response, channel, wsSession, transformation);
        wsRemoteEndpointClient.setTransformation(wsFrameClient.getTransformation());
        endpoint.onOpen(wsSession, clientEndpointConfiguration);
        this.registerSession(endpoint, wsSession);
        wsFrameClient.startInputProcessing();
        return wsSession;
    }

    private static void writeRequest(AsyncChannelWrapper channel, ByteBuffer request, long timeout) throws TimeoutException, InterruptedException, ExecutionException {
        int toWrite = request.limit();
        Future<Integer> fWrite = channel.write(request);
        Integer thisWrite = fWrite.get(timeout, TimeUnit.MILLISECONDS);
        toWrite -= thisWrite.intValue();
        while (toWrite > 0) {
            fWrite = channel.write(request);
            thisWrite = fWrite.get(timeout, TimeUnit.MILLISECONDS);
            toWrite -= thisWrite.intValue();
        }
    }

    private static boolean isRedirectStatus(int httpResponseCode) {
        boolean isRedirect = false;
        switch (httpResponseCode) {
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 305: 
            case 307: {
                isRedirect = true;
                break;
            }
        }
        return isRedirect;
    }

    private static ByteBuffer createProxyRequest(String host, int port) {
        StringBuilder request = new StringBuilder();
        request.append("CONNECT ");
        request.append(host);
        request.append(':');
        request.append(port);
        request.append(" HTTP/1.1\r\nProxy-Connection: keep-alive\r\nConnection: keepalive\r\nHost: ");
        request.append(host);
        request.append(':');
        request.append(port);
        request.append("\r\n\r\n");
        byte[] bytes = request.toString().getBytes(StandardCharsets.ISO_8859_1);
        return ByteBuffer.wrap(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerSession(Object endpoint, WsSession wsSession) {
        Object endpointKey = this.getEndpointKeyForOpenSessions(endpoint);
        if (!wsSession.isOpen()) {
            return;
        }
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<WsSession> wsSessions;
            if (this.endpointSessionMap.size() == 0) {
                BackgroundProcessManager.getInstance().register(this);
            }
            if ((wsSessions = this.endpointSessionMap.get(endpointKey)) == null) {
                wsSessions = new HashSet<WsSession>();
                this.endpointSessionMap.put(endpointKey, wsSessions);
            }
            wsSessions.add(wsSession);
        }
        this.sessions.put(wsSession, wsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterSession(Object endpoint, WsSession wsSession) {
        Object endpointKey = this.getEndpointKeyForOpenSessions(endpoint);
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<WsSession> wsSessions = this.endpointSessionMap.get(endpointKey);
            if (wsSessions != null) {
                wsSessions.remove(wsSession);
                if (wsSessions.size() == 0) {
                    this.endpointSessionMap.remove(endpointKey);
                }
            }
            if (this.endpointSessionMap.size() == 0) {
                BackgroundProcessManager.getInstance().unregister(this);
            }
        }
        this.sessions.remove(wsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<Session> getOpenSessions(Object endpoint) {
        Object endpointKey = this.getEndpointKeyForOpenSessions(endpoint);
        HashSet<Session> result = new HashSet<Session>();
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<WsSession> sessions = this.endpointSessionMap.get(endpointKey);
            if (sessions != null) {
                for (WsSession session : sessions) {
                    if (!session.isOpen()) continue;
                    result.add(session);
                }
            }
        }
        return result;
    }

    private static Map<String, List<String>> createRequestHeaders(String host, int port, boolean secure, ClientEndpointConfig clientEndpointConfiguration) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        List<Extension> extensions = clientEndpointConfiguration.getExtensions();
        List<String> subProtocols = clientEndpointConfiguration.getPreferredSubprotocols();
        Map<String, Object> userProperties = clientEndpointConfiguration.getUserProperties();
        if (userProperties.get("Authorization") != null) {
            ArrayList<String> authValues = new ArrayList<String>(1);
            authValues.add((String)userProperties.get("Authorization"));
            headers.put("Authorization", authValues);
        }
        ArrayList<String> hostValues = new ArrayList<String>(1);
        if (port == 80 && !secure || port == 443 && secure) {
            hostValues.add(host);
        } else {
            hostValues.add(host + ':' + port);
        }
        headers.put("Host", hostValues);
        ArrayList<String> upgradeValues = new ArrayList<String>(1);
        upgradeValues.add("websocket");
        headers.put("Upgrade", upgradeValues);
        ArrayList<String> connectionValues = new ArrayList<String>(1);
        connectionValues.add("upgrade");
        headers.put("Connection", connectionValues);
        ArrayList<String> wsVersionValues = new ArrayList<String>(1);
        wsVersionValues.add("13");
        headers.put("Sec-WebSocket-Version", wsVersionValues);
        ArrayList<String> wsKeyValues = new ArrayList<String>(1);
        wsKeyValues.add(WsWebSocketContainer.generateWsKeyValue());
        headers.put("Sec-WebSocket-Key", wsKeyValues);
        if (subProtocols != null && subProtocols.size() > 0) {
            headers.put("Sec-WebSocket-Protocol", subProtocols);
        }
        if (extensions != null && extensions.size() > 0) {
            headers.put("Sec-WebSocket-Extensions", WsWebSocketContainer.generateExtensionHeaders(extensions));
        }
        return headers;
    }

    private static List<String> generateExtensionHeaders(List<Extension> extensions) {
        ArrayList<String> result = new ArrayList<String>(extensions.size());
        for (Extension extension : extensions) {
            StringBuilder header = new StringBuilder();
            header.append(extension.getName());
            for (Extension.Parameter param : extension.getParameters()) {
                header.append(';');
                header.append(param.getName());
                String value = param.getValue();
                if (value == null || value.length() <= 0) continue;
                header.append('=');
                header.append(value);
            }
            result.add(header.toString());
        }
        return result;
    }

    private static String generateWsKeyValue() {
        byte[] keyBytes = new byte[16];
        RANDOM.nextBytes(keyBytes);
        return Base64.encodeBase64String((byte[])keyBytes);
    }

    private static ByteBuffer createRequest(URI uri, Map<String, List<String>> reqHeaders) {
        ByteBuffer result = ByteBuffer.allocate(4096);
        result.put(GET_BYTES);
        if (null == uri.getPath() || "".equals(uri.getPath())) {
            result.put(ROOT_URI_BYTES);
        } else {
            result.put(uri.getRawPath().getBytes(StandardCharsets.ISO_8859_1));
        }
        String query = uri.getRawQuery();
        if (query != null) {
            result.put((byte)63);
            result.put(query.getBytes(StandardCharsets.ISO_8859_1));
        }
        result.put(HTTP_VERSION_BYTES);
        for (Map.Entry<String, List<String>> entry : reqHeaders.entrySet()) {
            result = WsWebSocketContainer.addHeader(result, entry.getKey(), entry.getValue());
        }
        result.put(CRLF);
        result.flip();
        return result;
    }

    private static ByteBuffer addHeader(ByteBuffer result, String key, List<String> values) {
        if (values.isEmpty()) {
            return result;
        }
        result = WsWebSocketContainer.putWithExpand(result, key.getBytes(StandardCharsets.ISO_8859_1));
        result = WsWebSocketContainer.putWithExpand(result, ": ".getBytes(StandardCharsets.ISO_8859_1));
        result = WsWebSocketContainer.putWithExpand(result, StringUtils.join(values).getBytes(StandardCharsets.ISO_8859_1));
        result = WsWebSocketContainer.putWithExpand(result, CRLF);
        return result;
    }

    private static ByteBuffer putWithExpand(ByteBuffer input, byte[] bytes) {
        if (bytes.length > input.remaining()) {
            int newSize = bytes.length > input.capacity() ? 2 * bytes.length : input.capacity() * 2;
            ByteBuffer expanded = ByteBuffer.allocate(newSize);
            input.flip();
            expanded.put(input);
            input = expanded;
        }
        return input.put(bytes);
    }

    private HttpResponse processResponse(ByteBuffer response, AsyncChannelWrapper channel, long timeout) throws InterruptedException, ExecutionException, DeploymentException, EOFException, TimeoutException {
        CaseInsensitiveKeyMap headers = new CaseInsensitiveKeyMap();
        int status = 0;
        boolean readStatus = false;
        boolean readHeaders = false;
        String line = null;
        while (!readHeaders) {
            response.clear();
            Future<Integer> read = channel.read(response);
            Integer bytesRead = read.get(timeout, TimeUnit.MILLISECONDS);
            if (bytesRead == -1) {
                throw new EOFException();
            }
            response.flip();
            while (response.hasRemaining() && !readHeaders) {
                if ("\r\n".equals(line = line == null ? this.readLine(response) : line + this.readLine(response))) {
                    readHeaders = true;
                    continue;
                }
                if (!line.endsWith("\r\n")) continue;
                if (readStatus) {
                    this.parseHeaders(line, (Map<String, List<String>>)headers);
                } else {
                    status = this.parseStatus(line);
                    readStatus = true;
                }
                line = null;
            }
        }
        return new HttpResponse(status, new WsHandshakeResponse((Map<String, List<String>>)headers));
    }

    private int parseStatus(String line) throws DeploymentException {
        String[] parts = line.trim().split(" ");
        if (parts.length < 2 || !"HTTP/1.0".equals(parts[0]) && !"HTTP/1.1".equals(parts[0])) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{line}));
        }
        try {
            return Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException nfe) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.invalidStatus", new Object[]{line}));
        }
    }

    private void parseHeaders(String line, Map<String, List<String>> headers) {
        int index = line.indexOf(58);
        if (index == -1) {
            this.log.warn((Object)sm.getString("wsWebSocketContainer.invalidHeader", new Object[]{line}));
            return;
        }
        String headerName = line.substring(0, index).trim().toLowerCase(Locale.ENGLISH);
        String headerValue = line.substring(index + 1).trim();
        List<String> values = headers.get(headerName);
        if (values == null) {
            values = new ArrayList<String>(1);
            headers.put(headerName, values);
        }
        values.add(headerValue);
    }

    private String readLine(ByteBuffer response) {
        StringBuilder sb = new StringBuilder();
        char c = '\u0000';
        while (response.hasRemaining()) {
            c = (char)response.get();
            sb.append(c);
            if (c != '\n') continue;
            break;
        }
        return sb.toString();
    }

    private SSLEngine createSSLEngine(Map<String, Object> userProperties, String host, int port) throws DeploymentException {
        try {
            SSLContext sslContext = (SSLContext)userProperties.get("com.bes.enterprise.web.websocket.SSL_CONTEXT");
            if (sslContext == null) {
                sslContext = SSLContext.getInstance("TLS");
                String sslTrustStoreValue = (String)userProperties.get("com.bes.enterprise.web.websocket.SSL_TRUSTSTORE");
                if (sslTrustStoreValue != null) {
                    String sslTrustStorePwdValue = (String)userProperties.get("com.bes.enterprise.web.websocket.SSL_TRUSTSTORE_PWD");
                    if (sslTrustStorePwdValue == null) {
                        sslTrustStorePwdValue = "changeit";
                    }
                    File keyStoreFile = new File(sslTrustStoreValue);
                    KeyStore ks = KeyStore.getInstance("JKS");
                    try (FileInputStream is = new FileInputStream(keyStoreFile);){
                        KeyStoreUtil.load((KeyStore)ks, (InputStream)is, (char[])sslTrustStorePwdValue.toCharArray());
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    sslContext.init(null, tmf.getTrustManagers(), null);
                } else {
                    sslContext.init(null, null, null);
                }
            }
            SSLEngine engine = sslContext.createSSLEngine(host, port);
            String sslProtocolsValue = (String)userProperties.get("com.bes.enterprise.web.websocket.SSL_PROTOCOLS");
            if (sslProtocolsValue != null) {
                engine.setEnabledProtocols(sslProtocolsValue.split(","));
            }
            engine.setUseClientMode(true);
            SSLParameters sslParams = engine.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            engine.setSSLParameters(sslParams);
            return engine;
        }
        catch (Exception e) {
            throw new DeploymentException(sm.getString("wsWebSocketContainer.sslEngineFail"), e);
        }
    }

    @Override
    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    @Override
    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.defaultMaxSessionIdleTimeout = timeout;
    }

    @Override
    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    @Override
    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.maxBinaryMessageBufferSize = max;
    }

    @Override
    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    @Override
    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.maxTextMessageBufferSize = max;
    }

    @Override
    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    @Override
    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncTimeout;
    }

    @Override
    public void setAsyncSendTimeout(long timeout) {
        this.defaultAsyncTimeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        CloseReason cr = new CloseReason(CloseReason.CloseCodes.GOING_AWAY, sm.getString("wsWebSocketContainer.shutdown"));
        for (WsSession session : this.sessions.keySet()) {
            try {
                session.close(cr);
            }
            catch (IOException ioe) {
                this.log.debug((Object)sm.getString("wsWebSocketContainer.sessionCloseFail", new Object[]{session.getId()}), (Throwable)ioe);
            }
        }
        if (this.asynchronousChannelGroup != null) {
            Object object = this.asynchronousChannelGroupLock;
            synchronized (object) {
                if (this.asynchronousChannelGroup != null) {
                    AsyncChannelGroupUtil.unregister();
                    this.asynchronousChannelGroup = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsynchronousChannelGroup getAsynchronousChannelGroup() {
        AsynchronousChannelGroup result = this.asynchronousChannelGroup;
        if (result == null) {
            Object object = this.asynchronousChannelGroupLock;
            synchronized (object) {
                if (this.asynchronousChannelGroup == null) {
                    this.asynchronousChannelGroup = AsyncChannelGroupUtil.register();
                }
                result = this.asynchronousChannelGroup;
            }
        }
        return result;
    }

    @Override
    public void backgroundProcess() {
        ++this.backgroundProcessCount;
        if (this.backgroundProcessCount >= this.processPeriod) {
            this.backgroundProcessCount = 0;
            for (WsSession wsSession : this.sessions.keySet()) {
                wsSession.checkExpiration();
                wsSession.checkCloseTimeout();
            }
        }
    }

    @Override
    public void setProcessPeriod(int period) {
        this.processPeriod = period;
    }

    @Override
    public int getProcessPeriod() {
        return this.processPeriod;
    }

    private Object getEndpointKeyForOpenSessions(Object endpoint) {
        if (!SCOPING_GET_OPEN_SESSION_TO_ENDPOINT_CLASS) {
            return endpoint;
        }
        if (endpoint instanceof PojoEndpointServer) {
            Object pojo = ((PojoEndpointServer)endpoint).getPojo();
            if (pojo == null) {
                return endpoint.getClass().getName();
            }
            return pojo.getClass().getName();
        }
        return endpoint.getClass().getName();
    }

    private static class HttpResponse {
        private final int status;
        private final HandshakeResponse handshakeResponse;

        public HttpResponse(int status, HandshakeResponse handshakeResponse) {
            this.status = status;
            this.handshakeResponse = handshakeResponse;
        }

        public int getStatus() {
            return this.status;
        }

        public HandshakeResponse getHandshakeResponse() {
            return this.handshakeResponse;
        }
    }
}

