/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.websocket.server;

import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import com.bes.enterprise.web.util.net.AbstractEndpoint;
import com.bes.enterprise.web.util.net.SocketEvent;
import com.bes.enterprise.web.util.net.SocketWrapperBase;
import com.bes.enterprise.web.util.res.StringManager;
import com.bes.enterprise.web.websocket.Transformation;
import com.bes.enterprise.web.websocket.WsFrameBase;
import com.bes.enterprise.web.websocket.WsIOException;
import com.bes.enterprise.web.websocket.WsSession;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class WsFrameServer
extends WsFrameBase {
    private final Log log = LogFactory.getLog(WsFrameServer.class);
    private static final StringManager sm = StringManager.getManager(WsFrameServer.class);
    private final SocketWrapperBase<?> socketWrapper;
    private final ClassLoader applicationClassLoader;

    public WsFrameServer(SocketWrapperBase<?> socketWrapper, WsSession wsSession, Transformation transformation, ClassLoader applicationClassLoader) {
        super(wsSession, transformation);
        this.socketWrapper = socketWrapper;
        this.applicationClassLoader = applicationClassLoader;
    }

    private void onDataAvailable() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"wsFrameServer.onDataAvailable");
        }
        if (this.isOpen() && this.inputBuffer.hasRemaining() && !this.isSuspended()) {
            this.processInputBuffer();
        }
        while (this.isOpen() && !this.isSuspended()) {
            this.inputBuffer.mark();
            this.inputBuffer.position(this.inputBuffer.limit()).limit(this.inputBuffer.capacity());
            int read = this.socketWrapper.read(false, this.inputBuffer);
            this.inputBuffer.limit(this.inputBuffer.position()).reset();
            if (read < 0) {
                throw new EOFException();
            }
            if (read == 0) {
                return;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)sm.getString("wsFrameServer.bytesRead", new Object[]{Integer.toString(read)}));
            }
            this.processInputBuffer();
        }
    }

    @Override
    protected boolean isMasked() {
        return true;
    }

    @Override
    protected Transformation getTransformation() {
        return super.getTransformation();
    }

    @Override
    protected boolean isOpen() {
        return super.isOpen();
    }

    @Override
    protected Log getLog() {
        return this.log;
    }

    @Override
    protected void sendMessageText(boolean last) throws WsIOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.applicationClassLoader);
            super.sendMessageText(last);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendMessageBinary(ByteBuffer msg, boolean last) throws WsIOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.applicationClassLoader);
            super.sendMessageBinary(msg, last);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    @Override
    protected void resumeProcessing() {
        this.socketWrapper.processSocket(SocketEvent.OPEN_READ, true);
    }

    AbstractEndpoint.Handler.SocketState notifyDataAvailable() throws IOException {
        block6: while (this.isOpen()) {
            switch (this.getReadState()) {
                case WAITING: {
                    if (!this.changeReadState(WsFrameBase.ReadState.WAITING, WsFrameBase.ReadState.PROCESSING)) continue block6;
                    try {
                        return this.doOnDataAvailable();
                    }
                    catch (IOException e) {
                        this.changeReadState(WsFrameBase.ReadState.CLOSING);
                        throw e;
                    }
                }
                case SUSPENDING_WAIT: {
                    if (!this.changeReadState(WsFrameBase.ReadState.SUSPENDING_WAIT, WsFrameBase.ReadState.SUSPENDED)) continue block6;
                    return AbstractEndpoint.Handler.SocketState.SUSPENDED;
                }
            }
            throw new IllegalStateException(sm.getString("wsFrameServer.illegalReadState", new Object[]{this.getReadState()}));
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    private AbstractEndpoint.Handler.SocketState doOnDataAvailable() throws IOException {
        this.onDataAvailable();
        block4: while (this.isOpen()) {
            switch (this.getReadState()) {
                case PROCESSING: {
                    if (!this.changeReadState(WsFrameBase.ReadState.PROCESSING, WsFrameBase.ReadState.WAITING)) continue block4;
                    return AbstractEndpoint.Handler.SocketState.UPGRADED;
                }
                case SUSPENDING_PROCESS: {
                    if (!this.changeReadState(WsFrameBase.ReadState.SUSPENDING_PROCESS, WsFrameBase.ReadState.SUSPENDED)) continue block4;
                    return AbstractEndpoint.Handler.SocketState.SUSPENDED;
                }
            }
            throw new IllegalStateException(sm.getString("wsFrameServer.illegalReadState", new Object[]{this.getReadState()}));
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }
}

