/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.core.convert.impl;

import com.dahuatech.hutool.core.convert.AbstractConverter;
import com.dahuatech.hutool.core.util.ClassUtil;
import com.dahuatech.hutool.core.util.ReflectUtil;
import java.lang.reflect.Method;

public class Jdk8DateConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    public static String[] supportClassNames = new String[]{"java.time.LocalDateTime", "java.time.LocalDate", "java.time.LocalTime", "java.time.ZonedDateTime", "java.time.OffsetDateTime", "java.time.OffsetTime", "java.time.Period", "java.time.Instant"};
    private Class<?> targetType;
    private String format;

    public Jdk8DateConverter(Class<?> targetType) {
        this.targetType = targetType;
    }

    public Jdk8DateConverter(Class<?> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Object convertInternal(Object value) {
        if (value instanceof Long) {
            return this.parseFromLong((Long)value);
        }
        return this.parseFromCharSequence(this.convertToStr(value));
    }

    private Object parseFromCharSequence(CharSequence value) {
        if (null != this.format) {
            Object dateTimeFormatter = this.getDateTimeFormatter();
            Method method = ReflectUtil.getMethod(this.targetType, "parse", CharSequence.class, dateTimeFormatter.getClass());
            return ReflectUtil.invokeStatic(method, value, dateTimeFormatter);
        }
        Method method = ReflectUtil.getMethod(this.targetType, "parse", CharSequence.class);
        return ReflectUtil.invokeStatic(method, value);
    }

    private Object parseFromLong(Long time) {
        String targetName = this.targetType.getName();
        if ("java.time.Instant".equals(targetName)) {
            return this.toInstant(time);
        }
        return null;
    }

    private Object getDateTimeFormatter() {
        if (null != this.format) {
            return ClassUtil.invoke("java.time.format.DateTimeFormatter.ofPattern", false, this.format);
        }
        return null;
    }

    private Object toInstant(Long time) {
        return ClassUtil.invoke("java.time.Instant.ofEpochMilli", false, time);
    }

    @Override
    public Class<Object> getTargetType() {
        return this.targetType;
    }
}

