/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.hutool.json;

import com.dahuatech.hutool.core.convert.Convert;
import com.dahuatech.hutool.core.convert.ConvertException;
import com.dahuatech.hutool.core.convert.Converter;
import com.dahuatech.hutool.core.convert.ConverterRegistry;
import com.dahuatech.hutool.core.convert.impl.ArrayConverter;
import com.dahuatech.hutool.core.util.ObjectUtil;
import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.core.util.TypeUtil;
import com.dahuatech.hutool.json.JSON;
import com.dahuatech.hutool.json.JSONArray;
import com.dahuatech.hutool.json.JSONObject;
import com.dahuatech.hutool.json.JSONUtil;
import com.dahuatech.hutool.json.serialize.GlobalSerializeMapping;
import com.dahuatech.hutool.json.serialize.JSONDeserializer;
import java.lang.reflect.Type;
import java.util.List;

public class JSONConverter
implements Converter<JSON> {
    protected static Object toArray(JSONArray jsonArray, Class<?> arrayClass) {
        return new ArrayConverter(arrayClass).convert(jsonArray, null);
    }

    protected static <T> List<T> toList(JSONArray jsonArray, Class<T> elementType) {
        return Convert.toList(elementType, jsonArray);
    }

    protected static <T> T jsonConvert(Type targetType, Object value, boolean ignoreError) throws ConvertException {
        JSONDeserializer<?> deserializer;
        if (JSONUtil.isNull(value)) {
            return null;
        }
        if (value instanceof JSON && null != (deserializer = GlobalSerializeMapping.getDeserializer(targetType))) {
            return (T)deserializer.deserialize((JSON)value);
        }
        T targetValue = null;
        try {
            targetValue = Convert.convert(targetType, value);
        }
        catch (ConvertException e) {
            if (ignoreError) {
                return null;
            }
            throw e;
        }
        if (null == targetValue && !ignoreError) {
            if (StrUtil.isBlankIfStr(value)) {
                return null;
            }
            throw new ConvertException("Can not convert {} to type {}", value, ObjectUtil.defaultIfNull(TypeUtil.getClass(targetType), targetType));
        }
        return targetValue;
    }

    @Override
    public JSON convert(Object value, JSON defaultValue) throws IllegalArgumentException {
        return JSONUtil.parse(value);
    }

    static {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        registry.putCustom((Type)((Object)JSON.class), (Class<? extends Converter<?>>)JSONConverter.class);
        registry.putCustom((Type)((Object)JSONObject.class), (Class<? extends Converter<?>>)JSONConverter.class);
        registry.putCustom((Type)((Object)JSONArray.class), (Class<? extends Converter<?>>)JSONConverter.class);
    }
}

