/*
 * Decompiled with CFR 0.152.
 */
package com.dahuatech.icc.oauth.model.v202010;

import com.dahuatech.hutool.core.util.StrUtil;
import com.dahuatech.hutool.http.HttpRequest;
import com.dahuatech.hutool.http.HttpResponse;
import com.dahuatech.hutool.http.HttpUtil;
import com.dahuatech.hutool.log.Log;
import com.dahuatech.hutool.log.LogFactory;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.DefaultClient;
import com.dahuatech.icc.oauth.http.IccTokenResponse;
import com.dahuatech.icc.oauth.profile.IccProfile;
import java.io.File;

public class OssmConvertUtil {
    private static final Log logger = LogFactory.get();

    public static boolean download(String path, String file) {
        return HttpUtil.downloadFile((String)OssmConvertUtil.revertImageUrl(path), (String)file) > 0L;
    }

    public static boolean download(String path, File file) {
        return HttpUtil.downloadFile((String)OssmConvertUtil.revertImageUrl(path), (File)file) > 0L;
    }

    public static String revertImageUrl(String path, String token) {
        try {
            HttpRequest request = HttpRequest.get((String)(IccProfile.URL_SCHEME + "/evo-apigw/evo-oss/" + path));
            if (StrUtil.isBlank((CharSequence)token)) {
                logger.warn("token is null ,check config", new Object[0]);
                return "";
            }
            request.form("token", (Object)token);
            HttpResponse response = request.execute();
            if (response.getStatus() == 302) {
                String locationPath = response.header("Location");
                if (StrUtil.isNotBlank((CharSequence)(locationPath = OssmConvertUtil.checkPath(locationPath))) && locationPath.toLowerCase().startsWith("http")) {
                    return locationPath;
                }
                return IccProfile.URL_SCHEME + locationPath;
            }
        }
        catch (Exception e) {
            logger.warn("get oss redirect url error ={}", new Object[]{e});
        }
        return "";
    }

    public static String revertImageUrl(String path) {
        try {
            DefaultClient iClient = new DefaultClient();
            IccTokenResponse.IccToken token = iClient.getAccessToken();
            if (token == null) {
                logger.warn("token is null ,check config", new Object[0]);
                return "";
            }
            return OssmConvertUtil.revertImageUrl(path, token.getAccess_token());
        }
        catch (ClientException e) {
            logger.warn("get oss redirect url error ={}", new Object[]{e});
            return "";
        }
    }

    private static String checkPath(String path) {
        if (StrUtil.isBlank((CharSequence)path)) {
            logger.warn("oss path is empty", new Object[0]);
            return path;
        }
        if (path.startsWith("/") || path.toLowerCase().startsWith("http")) {
            return path;
        }
        return "/" + path;
    }
}

