/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.hivecommon.api;

import com.databricks.client.dsi.dataengine.utilities.DSITypeUtilities;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.hivecommon.HiveJDBCSettings;
import com.databricks.client.hivecommon.IServerVersion;
import com.databricks.client.hivecommon.IServerVersionUtils;
import com.databricks.client.hivecommon.api.HS2Buffer;
import com.databricks.client.hivecommon.api.HiveOperationContext;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TBinaryColumn;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TBoolColumn;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TByteColumn;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TColumn;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TDoubleColumn;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TI16Column;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TI32Column;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TI64Column;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TStringColumn;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class HS2v6Buffer
extends HS2Buffer {
    private static final byte[] BITMASK_TO_CELL_MAP = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    public int m_indexInNullArray = 0;
    public int m_bitIndexInCurrentNullByte = 0;
    private List<byte[]> m_nullLists;
    private HiveOperationContext m_context;
    private ArrayList<ArrayList<Object>> m_convertedColsVals;

    public HS2v6Buffer(ILogger iLogger, HiveJDBCSettings hiveJDBCSettings, HiveOperationContext hiveOperationContext) {
        super(iLogger, hiveJDBCSettings);
        this.m_context = hiveOperationContext;
    }

    @Override
    public boolean getData(int n, long l, long l2, DataWrapper dataWrapper, int n2, short s, String string, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        IServerVersionUtils iServerVersionUtils = hiveJDBCSettings.m_platformVersionUtils;
        IServerVersion iServerVersion = hiveJDBCSettings.m_serverVersion;
        switch (s) {
            case -2: {
                TBinaryColumn tBinaryColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getBinaryVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                ByteBuffer byteBuffer = tBinaryColumn.getValues().get(n2);
                if (null == byteBuffer || null == byteBuffer.array()) {
                    dataWrapper.setNull(s);
                    return false;
                }
                return DSITypeUtilities.outputBinary(byteBuffer.array(), dataWrapper, l, l2);
            }
            case 12: {
                TStringColumn tStringColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                String string2 = tStringColumn.getValues().get(n2);
                return DSITypeUtilities.outputVarCharStringData(string2, dataWrapper, l, l2);
            }
            case 1: {
                TStringColumn tStringColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                String string3 = tStringColumn.getValues().get(n2);
                return DSITypeUtilities.outputCharStringData(string3, dataWrapper, l, l2);
            }
            case 16: {
                if (iServerVersionUtils.hasIssueWithNullTypeData(iServerVersion) && ((TColumn._Fields)this.m_hiveServer2Buffer.getResults().getColumns().get(n).getSetField()).getFieldName().equals("stringVal")) {
                    if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                        dataWrapper.setNull(s);
                        return false;
                    }
                    ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Incorrect data type returned from server."});
                    throw errorException;
                }
                TBoolColumn tBoolColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getBoolVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Boolean bl = tBoolColumn.getValues().get(n2);
                dataWrapper.setBoolean(bl);
                return false;
            }
            case -6: {
                TByteColumn tByteColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getByteVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Byte by = tByteColumn.getValues().get(n2);
                dataWrapper.setTinyInt(by.byteValue());
                return false;
            }
            case 5: {
                if (this.m_hiveServer2Buffer.getResults().getColumns().get(n).isSetI16Val()) {
                    TI16Column tI16Column = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getI16Val();
                    if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                        dataWrapper.setNull(s);
                        return false;
                    }
                    Short s2 = tI16Column.getValues().get(n2);
                    dataWrapper.setSmallInt(s2.shortValue());
                } else {
                    TI32Column tI32Column = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getI32Val();
                    if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                        dataWrapper.setNull(s);
                        return false;
                    }
                    Integer n3 = tI32Column.getValues().get(n2);
                    dataWrapper.setInteger(n3.intValue());
                }
                return false;
            }
            case 4: {
                TI32Column tI32Column = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getI32Val();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Integer n4 = tI32Column.getValues().get(n2);
                dataWrapper.setInteger(n4.intValue());
                return false;
            }
            case -5: {
                TI64Column tI64Column = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getI64Val();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Long l3 = tI64Column.getValues().get(n2);
                dataWrapper.setBigInt(l3);
                return false;
            }
            case 7: {
                TDoubleColumn tDoubleColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getDoubleVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Double d = tDoubleColumn.getValues().get(n2);
                dataWrapper.setReal(d.floatValue());
                return false;
            }
            case 8: {
                TDoubleColumn tDoubleColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getDoubleVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                Double d = tDoubleColumn.getValues().get(n2);
                dataWrapper.setDouble(d);
                return false;
            }
            case 93: {
                TStringColumn tStringColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                ArrayList<Object> arrayList = this.m_convertedColsVals.get(n);
                if (null != arrayList && !this.m_convertedColsVals.get(n).isEmpty()) {
                    dataWrapper.setTimestamp((Timestamp)arrayList.get(n2));
                } else {
                    String string4 = tStringColumn.getValues().get(n2);
                    Timestamp timestamp = null;
                    timestamp = this.convertTimestamp(string4);
                    dataWrapper.setTimestamp(timestamp);
                }
                return false;
            }
            case 3: {
                TStringColumn tStringColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                ArrayList<Object> arrayList = this.m_convertedColsVals.get(n);
                if (null != arrayList && !this.m_convertedColsVals.get(n).isEmpty()) {
                    dataWrapper.setDecimal((BigDecimal)arrayList.get(n2));
                } else {
                    String string5 = tStringColumn.getValues().get(n2);
                    dataWrapper.setDecimal(new BigDecimal(string5));
                }
                return false;
            }
            case 91: {
                TStringColumn tStringColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n).getStringVal();
                if (HS2v6Buffer.checkIfNull(this.m_indexInNullArray, this.m_bitIndexInCurrentNullByte, this.m_nullLists.get(n))) {
                    dataWrapper.setNull(s);
                    return false;
                }
                ArrayList<Object> arrayList = this.m_convertedColsVals.get(n);
                if (null != arrayList && !this.m_convertedColsVals.get(n).isEmpty()) {
                    dataWrapper.setDate((Date)arrayList.get(n2));
                } else {
                    String string6 = tStringColumn.getValues().get(n2);
                    dataWrapper.setDate(Date.valueOf(string6));
                }
                return false;
            }
        }
        ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_RESULTSET_DATA_RETRIEVING_ERR.name(), new String[]{"Data Type May Not Supported"});
        throw errorException;
    }

    @Override
    public List<Integer> getIntColumn(int n) {
        return this.getHiveServer2Buffer().getResults().getColumns().get(n).getI32Val().getValues();
    }

    @Override
    public int getNumColumns() {
        return this.m_hiveServer2Buffer.getResults().getColumnsSize();
    }

    @Override
    public String getString(int n, int n2) {
        TStringColumn tStringColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(n2).getStringVal();
        if (HS2v6Buffer.checkIfNull(n, tStringColumn.getNulls())) {
            return null;
        }
        return tStringColumn.getValues().get(n);
    }

    @Override
    public List<String> getStringColumn(int n) {
        return this.getHiveServer2Buffer().getResults().getColumns().get(n).getStringVal().getValues();
    }

    @Override
    public void parseRow(int n) throws ErrorException {
        if (++this.m_bitIndexInCurrentNullByte == 8) {
            this.m_bitIndexInCurrentNullByte = 0;
            ++this.m_indexInNullArray;
        }
    }

    @Override
    public void setNumRows() throws ErrorException {
        if (null != this.m_hiveServer2Buffer.getResults()) {
            TColumn tColumn;
            List<TColumn> list = this.m_hiveServer2Buffer.getResults().getColumns();
            if (null == list) {
                ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Thrift column information request error");
                throw errorException;
            }
            this.m_numRows = 0 == list.size() ? 0 : ((tColumn = list.get(0)).isSetBinaryVal() ? tColumn.getBinaryVal().getValuesSize() : (tColumn.isSetBoolVal() ? tColumn.getBoolVal().getValuesSize() : (tColumn.isSetByteVal() ? tColumn.getByteVal().getValuesSize() : (tColumn.isSetDoubleVal() ? tColumn.getDoubleVal().getValuesSize() : (tColumn.isSetI16Val() ? tColumn.getI16Val().getValuesSize() : (tColumn.isSetI32Val() ? tColumn.getI32Val().getValuesSize() : (tColumn.isSetI64Val() ? tColumn.getI64Val().getValuesSize() : tColumn.getStringVal().getValuesSize())))))));
        } else {
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_ROW_FETCHING_ERR.name(), "Thrift column information request error");
            throw errorException;
        }
    }

    @Override
    protected void handleInitializeBuffer() {
        this.m_bitIndexInCurrentNullByte = 0;
        this.m_indexInNullArray = 0;
        this.m_nullLists = new ArrayList<byte[]>();
        this.m_convertedColsVals = new ArrayList();
        for (int i = 0; i < this.getNumColumns(); ++i) {
            byte[] byArray;
            TColumn tColumn = this.m_hiveServer2Buffer.getResults().getColumns().get(i);
            if (!tColumn.isSetStringVal()) {
                this.m_convertedColsVals.add(null);
            }
            if (tColumn.isSetBinaryVal()) {
                byArray = tColumn.getBinaryVal().getNulls();
            } else if (tColumn.isSetBoolVal()) {
                byArray = tColumn.getBoolVal().getNulls();
            } else if (tColumn.isSetByteVal()) {
                byArray = tColumn.getByteVal().getNulls();
            } else if (tColumn.isSetDoubleVal()) {
                byArray = tColumn.getDoubleVal().getNulls();
            } else if (tColumn.isSetI16Val()) {
                byArray = tColumn.getI16Val().getNulls();
            } else if (tColumn.isSetI32Val()) {
                byArray = tColumn.getI32Val().getNulls();
            } else if (tColumn.isSetI64Val()) {
                byArray = tColumn.getI64Val().getNulls();
            } else {
                byArray = tColumn.getStringVal().getNulls();
                if (this.m_settings.m_dataConversionInFetchThread.booleanValue()) {
                    ArrayList<Comparable<java.util.Date>> arrayList = new ArrayList<Comparable<java.util.Date>>();
                    this.m_convertedColsVals.add(arrayList);
                    if (null != this.m_context.m_columnTypes) {
                        boolean bl = false;
                        for (String string : tColumn.getStringVal().getValues()) {
                            switch (this.m_context.m_columnTypes[i]) {
                                case 93: {
                                    if (null == string || string.isEmpty()) {
                                        arrayList.add(null);
                                    } else {
                                        arrayList.add(this.convertTimestamp(string));
                                    }
                                    bl = true;
                                    break;
                                }
                                case 3: {
                                    if (null == string || string.isEmpty()) {
                                        arrayList.add(null);
                                    } else {
                                        arrayList.add(new BigDecimal(string));
                                    }
                                    bl = true;
                                    break;
                                }
                                case 91: {
                                    if (null == string || string.isEmpty()) {
                                        arrayList.add(null);
                                    } else {
                                        arrayList.add(Date.valueOf(string));
                                    }
                                    bl = true;
                                    break;
                                }
                            }
                            if (bl) continue;
                            break;
                        }
                    }
                } else {
                    this.m_convertedColsVals.add(null);
                }
            }
            this.m_nullLists.add(byArray);
        }
    }

    private static boolean checkIfNull(int n, byte[] byArray) {
        int n2 = n / 8;
        int n3 = n % 8;
        return HS2v6Buffer.checkIfNull(n2, n3, byArray);
    }

    private static boolean checkIfNull(int n, int n2, byte[] byArray) {
        if (n >= byArray.length) {
            return false;
        }
        return (byArray[n] & BITMASK_TO_CELL_MAP[n2]) != 0;
    }
}

