/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.catalog;

import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.favorite.FavoriteNodeDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.catalog.service.FavoriteNodeService;
import com.geoway.adf.dms.common.web.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/"})
@Api(tags={"03.06-\u5e94\u7528\u76ee\u5f55-\u8282\u70b9\u6536\u85cf"})
public class AppCatalogFavoriteController {
    @Resource
    private AppCatalogNodeService appCatalogNodeService;
    @Resource
    private FavoriteNodeService favoriteNodeService;

    @ApiOperation(value="01-\u83b7\u53d6\u6536\u85cf\u8282\u70b9\u6811")
    @GetMapping(value={"/appcatalog/node/favorite/tree"})
    public Response<AppCatalogNodeDTO> getFavoriteNodeTree(@RequestParam(required=false) String appCatalogId, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.appCatalogNodeService.getFavoriteNodeTree(appCatalogId, keyword));
    }

    @ApiOperation(value="02-\u6dfb\u52a0\u6587\u4ef6\u5939\u8282\u70b9")
    @PostMapping(path={"/catalog/browse/favorite/folder/add"})
    public Response<String> addFavoriteFolder(@RequestBody FavoriteNodeDTO addDTO) {
        return Response.ok((Object)this.favoriteNodeService.addFavoriteFolder(addDTO.getName(), addDTO.getPid()));
    }

    @ApiOperation(value="03-\u7f16\u8f91\u6587\u4ef6\u5939\u8282\u70b9")
    @PostMapping(path={"/catalog/browse/favorite/folder/edit"})
    public Response editFavoriteFolder(@RequestBody FavoriteNodeDTO editDTO) {
        this.favoriteNodeService.editFavoriteFolder(editDTO.getNodeId(), editDTO.getName());
        return Response.ok();
    }

    @ApiOperation(value="04-\u5220\u9664\u6587\u4ef6\u5939\u8282\u70b9\u3001\u53d6\u6d88\u6536\u85cf\u76ee\u5f55\u8282\u70b9")
    @PostMapping(path={"/catalog/browse/favorite/folder/del"})
    public Response<Integer> deleteFavoriteFolder(@RequestParam String nodeId) {
        return Response.ok((Object)this.favoriteNodeService.deleteFavoriteFolder(nodeId));
    }

    @ApiOperation(value="05-\u6536\u85cf\u76ee\u5f55\u8282\u70b9")
    @PostMapping(path={"/catalog/browse/node/favorite"})
    public Response setFavoriteNode(@RequestBody FavoriteNodeDTO addDTO) {
        this.favoriteNodeService.addFavoriteNode(addDTO.getNodeId(), addDTO.getPid());
        return Response.ok();
    }

    @ApiOperation(value="06-\u79fb\u52a8\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeId", value="\u6807\u8bc6", required=true), @ApiImplicitParam(name="pid", value="\u8282\u70b9\u7236id", required=false), @ApiImplicitParam(name="order", value="\u79fb\u52a8\u540e\u4e0a\u4e00\u4e2a\u5144\u5f1f\u8282\u70b9\u7684\u4f4d\u6b21\uff08\u4f4d\u6b21\u4ece1\u5f00\u59cb\uff0c\u6ca1\u6709\u4e0a\u4e2a\u5144\u5f1f\u8282\u70b9\u65f6\u6b64\u5904\u4e3a0\uff09", required=true)})
    @PostMapping(value={"/catalog/browse/favorite/move"})
    public Response moveNodeOrder(@RequestParam String nodeId, @RequestParam(required=false) String pid, @RequestParam Integer order) {
        this.favoriteNodeService.moveFavoriteNode(nodeId, pid, order);
        return Response.ok();
    }
}

