/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.entity.CmColorItem;
import com.geoway.adf.dms.config.entity.CmColorScheme;
import com.geoway.adf.dms.config.service.ColorItemService;
import com.geoway.adf.dms.config.service.ColorSchemeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/config/color/manage"})
@Api(tags={"04.09-\u914d\u7f6e\u7ba1\u7406-\u989c\u8272\u914d\u7f6e"})
public class ColorManageController {
    @Resource
    private ColorItemService colorItemService;
    @Resource
    private ColorSchemeService colorSchemeService;

    @ApiOperation(value="01-\u989c\u8272\u65b9\u6848-\u4fdd\u5b58\u6216\u66f4\u65b0")
    @PostMapping(value={"/scheme"})
    public Response<String> schemeSaveOrUpdate(CmColorScheme colorScheme) {
        return Response.ok((Object)this.colorSchemeService.saveOrUpdateInfo(colorScheme));
    }

    @ApiOperation(value="02-\u989c\u8272\u65b9\u6848-\u67e5\u8be2\u5217\u8868")
    @GetMapping(value={"/scheme/list"})
    public Response<List<CmColorScheme>> schemeList() {
        return Response.ok((Object)this.colorSchemeService.queryList());
    }

    @ApiOperation(value="03-\u989c\u8272\u65b9\u6848-\u5220\u9664\u65b9\u6848")
    @PostMapping(value={"/scheme/delete"})
    public Response<Boolean> schemeDelete(@RequestParam String id) {
        return Response.ok((Object)this.colorSchemeService.deleteById(id));
    }

    @ApiOperation(value="04-\u989c\u8272\u914d\u7f6e-\u4fdd\u5b58\u6216\u66f4\u65b0")
    @PostMapping(value={"/item"})
    public Response<String> itemSaveOrUpdate(CmColorItem colorItem) {
        return Response.ok((Object)this.colorItemService.saveOrUpdateInfo(colorItem));
    }

    @ApiOperation(value="05-\u989c\u8272\u914d\u7f6e-\u6839\u636e\u65b9\u6848\u67e5\u8be2\u5217\u8868")
    @GetMapping(value={"/item/list"})
    public Response<List<CmColorItem>> itemList(@RequestParam(required=false) String schemeId, @RequestParam(required=false) String schemeName, @RequestParam(required=false) String keyword) {
        if (StringUtil.isEmptyOrWhiteSpace((String)schemeId) && StringUtil.isEmptyOrWhiteSpace((String)schemeName)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (StringUtil.isNotEmpty((String)schemeId)) {
            return Response.ok((Object)this.colorItemService.queryByScheme(schemeId, keyword));
        }
        return Response.ok((Object)this.colorItemService.queryBySchemeName(schemeName, keyword));
    }

    @ApiOperation(value="06-\u989c\u8272\u914d\u7f6e-\u5220\u9664\u989c\u8272")
    @PostMapping(value={"/item/delete"})
    public Response<Boolean> itemDelete(@RequestParam(value="ids") String ids) {
        return Response.ok((Object)this.colorItemService.deleteByIds(ids));
    }

    @ApiOperation(value="07-\u989c\u8272\u914d\u7f6e-\u5bfc\u51fa")
    @GetMapping(value={"/scheme/export"})
    public void exportScheme(@RequestParam(value="schemeId") String schemeId) {
        this.colorSchemeService.exportScheme(schemeId);
    }

    @ApiOperation(value="08-\u989c\u8272\u914d\u7f6e-\u5bfc\u5165")
    @ApiImplicitParams(value={@ApiImplicitParam(name="schemeId", value="\u65b9\u6848\u6807\u8bc6"), @ApiImplicitParam(name="file", value="json\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class)})
    @UploadFileCheck(supportedSuffixes={".json"})
    @PostMapping(value={"/scheme/import/json"})
    public Response<Boolean> importScheme(@RequestPart MultipartFile file, @RequestParam(required=false) String schemeId) {
        return Response.ok((Object)this.colorSchemeService.importScheme(file, schemeId));
    }
}

