/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/config/sys/param"})
@Api(tags={"04.07-\u914d\u7f6e\u7ba1\u7406-\u7cfb\u7edf\u53c2\u6570"})
public class SysParamsController {
    @Resource
    private SysParamsService sysParamsService;

    @ApiOperation(value="01-\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd")})
    @GetMapping(value={"/list"})
    public Response<List<SysParamGroupDTO>> list(@RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.sysParamsService.listGroupParams(keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupKey", value="\u5206\u7ec4\u6807\u8bc6"), @ApiImplicitParam(name="key", value="\u53c2\u6570\u6807\u8bc6", required=true)})
    @GetMapping(value={"/detail"})
    public Response<SysParamDTO> getDetail(@RequestParam(required=false) String groupKey, @RequestParam String key) {
        SysParamDTO sysParamDTO = this.sysParamsService.getDetail(groupKey, key);
        if (sysParamDTO != null) {
            return Response.ok((Object)sysParamDTO);
        }
        String msg = StringUtil.isEmpty((String)groupKey) ? String.format("\u7cfb\u7edf\u53c2\u6570[%s]\u4e0d\u5b58\u5728", key) : String.format("\u7cfb\u7edf\u53c2\u6570[%s]->[%s]\u4e0d\u5b58\u5728", groupKey, key);
        return Response.error((String)msg);
    }

    @ApiOperation(value="03-\u83b7\u53d6\u5206\u7ec4\u4e0b\u7684\u6240\u6709\u53c2\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupKey", value="\u5206\u7ec4\u6807\u8bc6")})
    @GetMapping(value={"/group/detail"})
    public Response<SysParamGroupDTO> getGroupDetail(@RequestParam(required=false) String groupKey) {
        SysParamGroupDTO sysParamGroupDTO = this.sysParamsService.getGroupDetail(groupKey);
        if (sysParamGroupDTO != null) {
            return Response.ok((Object)sysParamGroupDTO);
        }
        String msg = String.format("\u7cfb\u7edf\u53c2\u6570\u5206\u7ec4[%s]\u4e0d\u5b58\u5728", groupKey);
        return Response.error((String)msg);
    }

    @ApiOperation(value="04-\u6dfb\u52a0\u5206\u7ec4")
    @PostMapping(value={"/group"})
    public Response<Long> addBaseMapGroup(@RequestBody SysParamGroupDTO groupDTO) {
        return Response.ok((Object)this.sysParamsService.addParamGroup(groupDTO));
    }

    @ApiOperation(value="05-\u7f16\u8f91\u5206\u7ec4")
    @PutMapping(value={"/group"})
    public Response updateBaseMapGroup(@RequestBody SysParamGroupDTO groupDTO) {
        this.sysParamsService.updateParamGroup(groupDTO);
        return Response.ok();
    }

    @ApiOperation(value="06-\u6dfb\u52a0\u7cfb\u7edf\u53c2\u6570")
    @PostMapping(value={""})
    public Response<Long> addBaseMapService(@RequestBody SysParamDTO paramDTO) {
        return Response.ok((Object)this.sysParamsService.addSysParam(paramDTO));
    }

    @ApiOperation(value="07-\u4fee\u6539\u7cfb\u7edf\u53c2\u6570")
    @PutMapping(value={""})
    public Response updateBaseMapService(@RequestBody SysParamDTO paramDTO) {
        this.sysParamsService.updateSysParam(paramDTO);
        return Response.ok();
    }

    @ApiOperation(value="08-\u5220\u9664\u5206\u7ec4\u6216\u7cfb\u7edf\u53c2\u6570")
    @ApiImplicitParam(name="id", value="\u6807\u8bc6", required=true)
    @DeleteMapping(value={""})
    public Response deleteBaseMap(@RequestParam Long id) {
        this.sysParamsService.deleteSysParam(id);
        return Response.ok();
    }

    @ApiOperation(value="09-\u6279\u91cf\u5220\u9664\u5206\u7ec4\u6216\u7cfb\u7edf\u53c2\u6570")
    @ApiImplicitParam(name="ids", value="\u591a\u4e2a\u6807\u8bc6\u7528\u9017\u53f7\u9694\u5f00", required=true)
    @PostMapping(value={"/batch/delete"})
    public Response deleteBaseMap(@RequestParam String ids) {
        this.sysParamsService.batchDeleteSysParam(ids);
        return Response.ok();
    }

    @ApiOperation(value="10-\u5bfc\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="groupKey", value="\u5206\u7ec4\u6807\u8bc6")})
    @GetMapping(value={"/group/export"})
    public void exportGroupParam(@RequestParam(required=false) String groupKey) {
        this.sysParamsService.exportGroupParam(groupKey);
    }

    @ApiOperation(value="11-\u5bfc\u5165")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="json\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class)})
    @UploadFileCheck(supportedSuffixes={".json"})
    @PostMapping(value={"/group/import/json"})
    public Response<Boolean> importScheme(@RequestPart MultipartFile file) {
        return Response.ok((Object)this.sysParamsService.importGroupParam(file));
    }
}

