/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.api.action.datasource.ResponseDatasetList;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DatasetTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.atlas.AtlasSimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.AtlasDataSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/atlas"})
@Api(tags={"01.07-atlas\u5927\u6570\u636e\u8d44\u6e90\u6c60"})
public class AtlasDataSourceController {
    @Resource
    private AtlasDataSourceService atlasDataSourceService;

    @ApiOperation(value="01-\u83b7\u53d6\u6570\u636e\u6e90\u8fde\u63a5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="types", value="\u6570\u636e\u6e90\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694(31-HDFS; 22-HBase)", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/list"})
    public Response<List<DataSourceDTO>> list(@RequestParam(required=false) String types, @RequestParam(required=false) String keyword) {
        List sourceTypes = null;
        if (StringUtil.isNotEmpty((String)types)) {
            sourceTypes = StringUtil.split((String)types, (String)",", t -> DataSourceTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        List databaseDTOList = this.atlasDataSourceService.listDataSource(sourceTypes, keyword);
        return Response.ok((Object)databaseDTOList);
    }

    @ApiOperation(value="02-\u83b7\u53d6\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="types", value="\u6570\u636e\u96c6\u7c7b\u578b", paramType="query", allowableValues="com.geoway.adf.dms.datasource.constant.DatasetTypeEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/dataset/list"})
    public ResponseDatasetList<AtlasSimpleDatasetDTO> listGeoDataset(@RequestParam String key, @RequestParam(required=false) String types, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        List datasetTypes = null;
        if (StringUtil.isNotEmpty((String)types)) {
            datasetTypes = StringUtil.split((String)types, (String)",", t -> DatasetTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        DatasetPageList datasets = this.atlasDataSourceService.listDatasets(key, datasetTypes, keyword, pageIndex, rows);
        return ResponseDatasetList.ok(datasets);
    }

    @ApiOperation(value="03-\u5220\u9664\u6570\u636e\u96c6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u96c6id", required=true)})
    @PostMapping(value={"/dataset/del"})
    public Response deleteDataset(String id) {
        this.atlasDataSourceService.deleteDataset(id);
        return Response.ok();
    }
}

