/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterBasicDTO;
import com.geoway.adf.dms.datasource.dto.query.QueryFilterDTO;
import com.geoway.adf.dms.datasource.manager.DataSourceManager;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource"})
@Api(tags={"01-\u6570\u636e\u6e90\u7ba1\u7406"})
public class DataSourceController {
    @Resource
    private DataSourceService dataSourceService;
    @Resource
    private DataSourceManager dataSourceManager;

    @ApiOperation(value="01-\u83b7\u53d6\u6570\u636e\u6e90\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataStoreTypes", value="\u6570\u636e\u5b58\u50a8\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694", paramType="query", allowableValues="com.geoway.adf.dms.datasource.constant.DataStoreTypeEnum"), @ApiImplicitParam(name="dataSourceTypes", value="\u6570\u636e\u6e90\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694", paramType="query", allowableValues="com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/list"})
    public Response<List<DataSourceDTO>> listDataSource(@RequestParam(required=false) String dataStoreTypes, @RequestParam(required=false) String dataSourceTypes, @RequestParam(required=false) String keyword) {
        List storeTypes = null;
        if (StringUtil.isNotEmpty((String)dataStoreTypes)) {
            storeTypes = StringUtil.split((String)dataStoreTypes, (String)",", t -> DataStoreTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        List sourceTypes = null;
        if (StringUtil.isNotEmpty((String)dataSourceTypes)) {
            sourceTypes = StringUtil.split((String)dataSourceTypes, (String)",", t -> DataSourceTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        List databaseDTOList = this.dataSourceService.listDataSource(storeTypes, sourceTypes, keyword);
        return Response.ok((Object)databaseDTOList);
    }

    @ApiOperation(value="02-\u6d4b\u8bd5\u6570\u636e\u6e90\u8fde\u63a5")
    @PostMapping(value={"/test"})
    public Response testConnect(@RequestBody DataSourceDTO dataSource) {
        this.dataSourceService.testConnect(dataSource);
        return Response.ok();
    }

    @ApiOperation(value="03-\u65b0\u589e\u6570\u636e\u6e90\u8fde\u63a5")
    @PostMapping(value={"/add"})
    public Response<String> addDataSource(@RequestBody DataSourceDTO dataSource) {
        return Response.ok((Object)this.dataSourceService.addDataSource(dataSource));
    }

    @ApiOperation(value="04-\u66f4\u65b0\u6570\u636e\u6e90\u8fde\u63a5")
    @PostMapping(value={"/update"})
    public Response updateDatasource(@RequestBody DataSourceDTO dataSource) {
        this.dataSourceService.updateDataSource(dataSource);
        return Response.ok();
    }

    @ApiOperation(value="05-\u5220\u9664\u6570\u636e\u6e90\u8fde\u63a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u5e93\u6807\u8bc6", required=true, paramType="path"), @ApiImplicitParam(name="deleteBizInfo", value="\u662f\u5426\u5220\u9664\u5173\u8054\u7684\u4e1a\u52a1\u4fe1\u606f", dataType="Boolean")})
    @DeleteMapping(value={"/delete/{key}"})
    public Response deleteDataSource(@PathVariable String key, @RequestParam(required=false, defaultValue="false") Boolean deleteBizInfo) {
        this.dataSourceService.deleteDataSource(key, deleteBizInfo);
        return Response.ok();
    }

    @ApiOperation(value="06-\u83b7\u53d6\u6570\u636e\u5b58\u50a8\u8fde\u63a5\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="path")})
    @GetMapping(value={"/detail/{key}"})
    public Response<DataSourceDTO> getDataSource(@PathVariable String key) {
        DataSourceDTO databaseDTO = this.dataSourceService.getDataSourceDetailWithoutPwd(key);
        return Response.ok((Object)databaseDTO);
    }

    @ApiOperation(hidden=true, value="06.2-\u83b7\u53d6\u6570\u636e\u5b58\u50a8\u8fde\u63a5\u8be6\u60c5", notes="\u6570\u636e\u6e90\u8fde\u63a5\u8be6\u60c5\uff0c\u5305\u542b\u5bc6\u7801\u3002\u8bf7\u6c42\u5934\u9700\u5305\u542baccess-token:Geoway")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="path")})
    @GetMapping(value={"/detail2/{key}"})
    public Response<DataSourceDTO> getDataSourceWithPassword(@PathVariable String key, HttpServletRequest request) {
        String token = request.getHeader("access-token");
        if (StringUtil.isEmpty((String)token) || !"Geoway".equals(token)) {
            return Response.error((String)"\u65e0\u6548\u7684token");
        }
        DataSourceDTO databaseDTO = this.dataSourceService.getDataSourceDetail(key);
        return Response.ok((Object)databaseDTO);
    }

    @ApiOperation(value="07-\u83b7\u53d6\u9ed8\u8ba4\u6570\u636e\u6e90\u8fde\u63a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dataStoreType", value="\u6570\u636e\u5b58\u50a8\u7c7b\u578b", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="dataSourceType", value="\u6570\u636e\u6e90\u7c7b\u578b", required=false, paramType="query", dataType="int")})
    @GetMapping(value={"/default"})
    public Response<DataSourceDTO> getDefaultDataSource(@RequestParam Integer dataStoreType, @RequestParam(required=false) Integer dataSourceType) {
        DataSourceDTO databaseDTO = this.dataSourceService.getDefaultDataSource(dataStoreType, dataSourceType);
        if (databaseDTO != null) {
            this.dataSourceManager.clearDataSourcePassword(databaseDTO);
        }
        return Response.ok((Object)databaseDTO);
    }

    @ApiOperation(value="08-\u8bbe\u7f6e\u9ed8\u8ba4\u6570\u636e\u6e90\u8fde\u63a5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u5b58\u50a8\u7c7b\u578b", required=true), @ApiImplicitParam(name="isDefault", value="\u6570\u636e\u6e90\u7c7b\u578b", required=true, dataType="Boolean")})
    @PostMapping(value={"/default"})
    public Response setDefaultDataSource(@RequestParam String key, @RequestParam Boolean isDefault) {
        this.dataSourceService.setDefaultDataSource(key, isDefault.booleanValue());
        return Response.ok();
    }

    @ApiOperation(value="09-\u83b7\u53d6\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="path")})
    @GetMapping(value={"/datasets/{key}"})
    public Response<List<SimpleDatasetDTO>> listDataset(@PathVariable String key) {
        return Response.ok((Object)this.dataSourceService.listDatasets(key));
    }

    @ApiOperation(value="10-\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u96c6id", required=true, paramType="path")})
    @GetMapping(value={"/dataset/{id}"})
    public Response<DatasetDTO> getDatasetDetail(@PathVariable String id) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetailWithoutPwd(id);
        return Response.ok((Object)datasetDTO);
    }

    @ApiOperation(value="11-\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5(\u6839\u636e\u540d\u79f0)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true), @ApiImplicitParam(name="name", value="\u6570\u636e\u96c6\u540d\u79f0", required=true)})
    @GetMapping(value={"/dataset/detail"})
    public Response<DatasetDTO> getDatasetDetailWithName(@RequestParam String dsKey, @RequestParam String name) {
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(dsKey, name);
        return Response.ok((Object)datasetDTO);
    }

    @ApiOperation(hidden=true, value="11-\u83b7\u53d6\u6570\u636e\u96c6\u8be6\u60c5", notes="\u6570\u636e\u6e90\u8fde\u63a5\u8be6\u60c5\uff0c\u5305\u542b\u5bc6\u7801\u3002\u8bf7\u6c42\u5934\u9700\u5305\u542baccess-token:Geoway")
    @GetMapping(value={"/dataset/detail2"})
    public Response<DatasetDTO> getDatasetDetailWithPassword(@RequestParam String id, HttpServletRequest request) {
        String token = request.getHeader("access-token");
        if (StringUtil.isEmpty((String)token) || !"Geoway".equals(token)) {
            return Response.error((String)"\u65e0\u6548\u7684token");
        }
        DatasetDTO datasetDTO = this.dataSourceService.getDatasetDetail(id);
        return Response.ok((Object)datasetDTO);
    }

    @ApiOperation(value="12-\u5220\u9664\u6570\u636e\u96c6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u96c6id", required=true, paramType="path")})
    @DeleteMapping(value={"/dataset/{id}"})
    public Response deleteDataset(@PathVariable String id) {
        this.dataSourceService.deleteDataset(id);
        return Response.ok();
    }

    @ApiOperation(value="13-\u6570\u636e\u96c6\u6570\u636e\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u96c6id", required=true, paramType="query")})
    @RequestMapping(value={"/dataset/query"}, method={RequestMethod.GET, RequestMethod.POST})
    public Response<DataQueryResult> queryTable(String id, QueryFilterDTO queryFilterDTO) {
        return Response.ok((Object)this.dataSourceService.queryData(id, queryFilterDTO));
    }

    @ApiOperation(value="14-\u6570\u636e\u96c6\u6570\u636e\u6570\u91cf")
    @PostMapping(value={"/dataset/querycount"})
    public Response<Long> queryDataCount(String id, QueryFilterBasicDTO queryFilterDTO) {
        return Response.ok((Object)this.dataSourceService.queryDataCount(id, queryFilterDTO));
    }

    @ApiOperation(value="15-\u6570\u636e\u96c6\u5b57\u6bb5\u552f\u4e00\u503c")
    @PostMapping(value={"/dataset/querydistinct"})
    public Response<List> queryDataUniqValues(@RequestParam String datasetId, QueryFilterBasicDTO queryFilter, @RequestParam(required=false, defaultValue="100") Integer limit) {
        return Response.ok((Object)this.dataSourceService.queryDataFieldUniqValues(datasetId, queryFilter, limit));
    }

    @ApiOperation(value="16-\u83b7\u53d6\u6570\u636e\u96c6\u5b57\u6bb5")
    @GetMapping(value={"/dataset/fields"})
    public Response<List<FieldDTO>> queryDatasetFields(@RequestParam String datasetId) {
        return Response.ok((Object)this.dataSourceService.getDatasetFields(datasetId));
    }
}

