/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.api.action.datasource.ResponseDatasetList;
import com.geoway.adf.dms.common.dto.ExtentDTO;
import com.geoway.adf.dms.common.dto.FieldDTO;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.common.web.ResponsePage;
import com.geoway.adf.dms.datasource.constant.DataSourceTypeEnum;
import com.geoway.adf.dms.datasource.dto.DatasetPageList;
import com.geoway.adf.dms.datasource.dto.create.FeatureClassCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.FeatureClassEditDTO;
import com.geoway.adf.dms.datasource.dto.create.FeatureDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.FeatureDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.create.FieldsEditDTO;
import com.geoway.adf.dms.datasource.dto.create.GroupDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.MosaicDatasetEditDTO;
import com.geoway.adf.dms.datasource.dto.create.TableCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.TableEditDTO;
import com.geoway.adf.dms.datasource.dto.create.TableViewCreateDTO;
import com.geoway.adf.dms.datasource.dto.create.TableViewEditDTO;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.FeatureClassDTO;
import com.geoway.adf.dms.datasource.dto.dataset.MosaicDatasetDTO;
import com.geoway.adf.dms.datasource.dto.dataset.TableDatasetDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.datasource.DatabaseDTO;
import com.geoway.adf.dms.datasource.service.FeatureClassService;
import com.geoway.adf.dms.datasource.service.FeatureDatasetService;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.dms.datasource.service.GroupDatasetService;
import com.geoway.adf.dms.datasource.service.MosaicDatasetService;
import com.geoway.adf.dms.datasource.service.TableDatasetService;
import com.geoway.adf.gis.basic.PageList;
import com.geoway.adf.gis.geodb.FeatureType;
import com.geoway.adf.gis.geodb.GeoDatasetType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/datasource/geodb"})
@Api(tags={"01.01-\u7a7a\u95f4\u6570\u636e\u5e93"})
public class GeoDatabaseController {
    @Resource
    private GeoDatabaseService geoDatabaseService;
    @Resource
    private FeatureDatasetService featureDatasetService;
    @Resource
    private FeatureClassService featureClassService;
    @Resource
    private MosaicDatasetService mosaicDatasetService;
    @Resource
    private TableDatasetService tableDatasetService;
    @Resource
    private GroupDatasetService groupDatasetService;

    @ApiOperation(value="01-\u83b7\u53d6\u7a7a\u95f4\u6570\u636e\u6e90\u8fde\u63a5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="types", value="\u6570\u636e\u6e90\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694(0-OracleSpatial; 1-PostgreSQL; 2-KingBase; 3-HighGo; 4-HighGo\u5b89\u5168\u7248; 5-SqlServer; 6-MySql; 8-OpenGauss)", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query")})
    @GetMapping(value={"/list"})
    public Response<List<DatabaseDTO>> list(@RequestParam(required=false) String types, @RequestParam(required=false) String keyword) {
        List sourceTypes = null;
        if (StringUtil.isNotEmpty((String)types)) {
            sourceTypes = StringUtil.split((String)types, (String)",", t -> DataSourceTypeEnum.getByValue((Integer)Integer.valueOf(t)));
        }
        List databaseDTOList = this.geoDatabaseService.listGeoDatabase(sourceTypes, keyword);
        return Response.ok((Object)databaseDTOList);
    }

    @ApiOperation(value="02-\u83b7\u53d6\u8fde\u63a5\u4e0b\u7684\u6240\u6709\u6570\u636e\u5e93")
    @PostMapping(value={"/listdb"})
    public Response<List<String>> listAllDatabase(@RequestBody DataSourceDTO dataSource) {
        return Response.ok((Object)this.geoDatabaseService.listAllDatabaseNames(dataSource));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u6570\u636e\u5e93\u6a21\u5f0f\u5217\u8868")
    @ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="path")
    @PostMapping(value={"/listschema"})
    public Response<List<String>> listAllSchema(String key) {
        return Response.ok((Object)this.geoDatabaseService.listAllDatabaseSchemas(key));
    }

    @ApiOperation(value="04.1-\u540c\u6b65\u7a7a\u95f4\u6570\u636e\u5e93")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true), @ApiImplicitParam(name="schema", value="\u6a21\u5f0f\u540d", required=false)})
    @PostMapping(value={"/sync"})
    public Response synchronize(String key, @RequestParam(required=false) String schema) {
        this.geoDatabaseService.synchronize(key, schema);
        return Response.ok();
    }

    @ApiOperation(value="04.2-\u540c\u6b65\u7a7a\u95f4\u6570\u636e\u96c6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true), @ApiImplicitParam(name="name", value="\u6570\u636e\u96c6\u540d\u79f0", required=true)})
    @PostMapping(value={"/syncdataset"})
    public Response<String> synchronizeDataset(String key, String name) {
        return Response.ok((Object)this.geoDatabaseService.synchronizeDataset(key, name));
    }

    @ApiOperation(value="05.1-\u83b7\u53d6\u7a7a\u95f4\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="types", value="\u7a7a\u95f4\u6570\u636e\u96c6\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694", paramType="query", allowableValues="com.geoway.adf.gis.geodb.GeoDatasetType"), @ApiImplicitParam(name="featureTypes", value="\u8981\u7d20\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694", paramType="query", allowableValues="com.geoway.adf.gis.geodb.FeatureType"), @ApiImplicitParam(name="schema", value="\u6a21\u5f0f\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="useMetaTable", value="\u662f\u5426\u4ece\u5143\u6570\u636e\u8868\u4e2d\u8bfb\u53d6\u6570\u636e\u96c6", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/dataset/list"})
    public ResponseDatasetList<DatasetPageList> listGeoDataset(@RequestParam String key, @RequestParam(required=false) String types, @RequestParam(required=false) String featureTypes, @RequestParam(required=false) String schema, @RequestParam(required=false) Boolean useMetaTable, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        List datasetTypes = null;
        if (StringUtil.isNotEmpty((String)types)) {
            datasetTypes = StringUtil.split((String)types, (String)",", t -> GeoDatasetType.getByValue((Integer)Integer.valueOf(t)));
        }
        List featureTypeList = null;
        if (StringUtil.isNotEmpty((String)featureTypes)) {
            featureTypeList = StringUtil.split((String)featureTypes, (String)",", t -> FeatureType.getByValue((Integer)Integer.valueOf(t)));
        }
        DatasetPageList datasets = this.geoDatabaseService.listGeoDatasets(key, datasetTypes, featureTypeList, schema, useMetaTable, keyword, pageIndex, rows);
        return ResponseDatasetList.ok(datasets);
    }

    @ApiOperation(value="05.2-\u83b7\u53d6\u6240\u6709\u8981\u7d20\u7c7b\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="featureTypes", value="\u8981\u7d20\u7c7b\u578b\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694", paramType="query", allowableValues="com.geoway.adf.gis.geodb.FeatureType"), @ApiImplicitParam(name="schema", value="\u6a21\u5f0f\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="onlyWithoutRender", value="\u662f\u5426\u53ea\u8fd4\u56de\u6ca1\u6709\u6e32\u67d3\u4fe1\u606f\u7684", paramType="query"), @ApiImplicitParam(name="withDetail", value="\u662f\u5426\u8fd4\u56de\u8be6\u60c5", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/dataset/listfc"})
    public ResponsePage<FeatureClassDTO> listAllFeatureClass(@RequestParam String key, @RequestParam(required=false) String featureTypes, @RequestParam(required=false) String schema, @RequestParam(required=false) String keyword, @RequestParam(required=false) Boolean onlyWithoutRender, @RequestParam(required=false) Boolean withDetail, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        List featureTypeList = null;
        if (StringUtil.isNotEmpty((String)featureTypes)) {
            featureTypeList = StringUtil.split((String)featureTypes, (String)",", t -> FeatureType.getByValue((Integer)Integer.valueOf(t)));
        }
        PageList datasets = this.geoDatabaseService.listAllFeatureClass(key, featureTypeList, schema, onlyWithoutRender, withDetail, keyword, pageIndex, rows);
        return ResponsePage.ok((PageList)datasets);
    }

    @ApiOperation(value="05.3-\u83b7\u53d6\u9576\u5d4c\u6570\u636e\u96c6\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="schema", value="\u6a21\u5f0f\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="onlyWithoutRender", value="\u662f\u5426\u53ea\u8fd4\u56de\u6ca1\u6709\u6e32\u67d3\u4fe1\u606f\u7684", paramType="query"), @ApiImplicitParam(name="withDetail", value="\u662f\u5426\u8fd4\u56de\u8be6\u60c5", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/dataset/listmsc"})
    public ResponsePage<MosaicDatasetDTO> listMosaicDataset(@RequestParam String key, @RequestParam(required=false) String schema, @RequestParam(required=false) String keyword, @RequestParam(required=false) Boolean onlyWithoutRender, @RequestParam(required=false) Boolean withDetail, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        PageList datasets = this.geoDatabaseService.listMosaicDataset(key, schema, onlyWithoutRender, withDetail, keyword, pageIndex, rows);
        return ResponsePage.ok((PageList)datasets);
    }

    @ApiOperation(value="05.4-\u83b7\u53d6\u8981\u7d20\u6570\u636e\u96c6\u4e0b\u7684\u8981\u7d20\u7c7b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="featureDatasetId", value="\u8981\u7d20\u6570\u636e\u96c6id", required=true, paramType="query"), @ApiImplicitParam(name="withDetail", value="\u662f\u5426\u8fd4\u56de\u8be6\u60c5", paramType="query")})
    @GetMapping(value={"/dataset/listsubfc"})
    public Response<List<DatasetDTO>> listSubFeatureClass(@RequestParam String featureDatasetId, @RequestParam(required=false) Boolean withDetail) {
        List datasets = this.geoDatabaseService.listSubFeatureClass(featureDatasetId, withDetail);
        return Response.ok((Object)datasets);
    }

    @ApiOperation(value="05.5-\u83b7\u53d6\u6240\u6709\u8868\u683c\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6570\u636e\u6e90\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="schema", value="\u6a21\u5f0f\u540d\u79f0", paramType="query"), @ApiImplicitParam(name="withDetail", value="\u662f\u5426\u8fd4\u56de\u8be6\u60c5", paramType="query"), @ApiImplicitParam(name="keyword", value="\u540d\u79f0\u8fc7\u6ee4", paramType="query"), @ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", paramType="query")})
    @GetMapping(value={"/dataset/listtable"})
    public ResponsePage<TableDatasetDTO> listAllTable(@RequestParam String key, @RequestParam(required=false) String schema, @RequestParam(required=false) String keyword, @RequestParam(required=false) Boolean withDetail, @RequestParam(required=false) Integer pageIndex, @RequestParam(required=false) Integer rows) {
        PageList datasets = this.geoDatabaseService.listAllTable(key, schema, withDetail, keyword, pageIndex, rows);
        return ResponsePage.ok((PageList)datasets);
    }

    @ApiOperation(value="06-\u5220\u9664\u7a7a\u95f4\u6570\u636e\u96c6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u96c6id", required=true, paramType="path")})
    @DeleteMapping(value={"/dataset/{id}"})
    public Response deleteDataset(@PathVariable String id) {
        this.geoDatabaseService.deleteDataset(id);
        return Response.ok();
    }

    @ApiOperation(value="07.1-\u521b\u5efa\u8981\u7d20\u6570\u636e\u96c6")
    @PostMapping(value={"/featuredataset/create"})
    public Response<String> createFeatureDataset(@RequestBody FeatureDatasetCreateDTO featureDataset) {
        return Response.ok((Object)this.featureDatasetService.createFeatureDataset(featureDataset));
    }

    @ApiOperation(value="07.2-\u4fee\u6539\u8981\u7d20\u6570\u636e\u96c6")
    @PostMapping(value={"/featuredataset/update"})
    public Response updateFeatureDataset(@RequestBody FeatureDatasetEditDTO featureDataset) {
        this.featureDatasetService.updateFeatureDataset(featureDataset);
        return Response.ok();
    }

    @ApiOperation(value="08-\u521b\u5efa\u7ec4\u5408\u6570\u636e\u96c6")
    @PostMapping(value={"/groupdataset/create"})
    public Response<String> createGroupDataset(@RequestBody GroupDatasetCreateDTO groupDataset) {
        return Response.ok((Object)this.groupDatasetService.createGroupDataset(groupDataset));
    }

    @ApiOperation(value="09.1-\u521b\u5efa\u8981\u7d20\u7c7b")
    @PostMapping(value={"/featureclass/create"})
    public Response createFeatureClass(@RequestBody FeatureClassCreateDTO featureClass) {
        return Response.ok((Object)this.featureClassService.createFeatureClass(featureClass));
    }

    @ApiOperation(value="09.4-\u4fee\u6539\u8981\u7d20\u7c7b")
    @PostMapping(value={"/featureclass/update"})
    public Response updateFeatureClass(@RequestBody FeatureClassEditDTO featureClass) {
        this.featureClassService.updateFeatureClass(featureClass);
        return Response.ok();
    }

    @ApiOperation(value="09.2-\u521b\u5efa\u8981\u7d20\u7c7b\u7a7a\u95f4\u7d22\u5f15")
    @PostMapping(value={"/featureclass/createspatialindex"})
    public Response createSpatialIndex(String datasetId) {
        this.featureClassService.createSpatialIndex(datasetId);
        return Response.ok();
    }

    @ApiOperation(value="09.3-\u5220\u9664\u8981\u7d20\u7c7b\u7a7a\u95f4\u7d22\u5f15")
    @PostMapping(value={"/featureclass/dropspatialindex"})
    public Response dropSpatialIndex(String datasetId) {
        this.featureClassService.dropSpatialIndex(datasetId);
        return Response.ok();
    }

    @ApiOperation(value="10.1-\u521b\u5efa\u9576\u5d4c\u6570\u636e\u96c6")
    @PostMapping(value={"/mosaicdataset/create"})
    public Response<String> createMosaicDataset(@RequestBody MosaicDatasetCreateDTO mosaicDataset) {
        return Response.ok((Object)this.mosaicDatasetService.createMosaicDataset(mosaicDataset));
    }

    @ApiOperation(value="10.3-\u4fee\u6539\u9576\u5d4c\u6570\u636e\u96c6")
    @PostMapping(value={"/mosaicdataset/update"})
    public Response updateMosaicDataset(@RequestBody MosaicDatasetEditDTO mosaicDataset) {
        this.mosaicDatasetService.updateMosaicDataset(mosaicDataset);
        return Response.ok();
    }

    @ApiOperation(value="10.2-\u9576\u5d4c\u6570\u636e\u96c6\u8ba1\u7b97\u7edf\u8ba1\u503c")
    @PostMapping(value={"/mosaicdataset/statsCal"})
    public Response calculateStatisticValue(String id) {
        this.mosaicDatasetService.calculateStatisticValue(id);
        return Response.ok();
    }

    @ApiOperation(value="11.1-\u521b\u5efa\u8868\u683c")
    @PostMapping(value={"/table/create"})
    public Response<String> createTable(@RequestBody TableCreateDTO table) {
        return Response.ok((Object)this.tableDatasetService.createTable(table));
    }

    @ApiOperation(value="11.3-\u4fee\u6539\u8868\u683c")
    @PostMapping(value={"/table/update"})
    public Response updateTable(@RequestBody TableEditDTO table) {
        this.tableDatasetService.updateTable(table);
        return Response.ok();
    }

    @ApiOperation(value="11.2-\u521b\u5efa\u89c6\u56fe")
    @PostMapping(value={"/table/createview"})
    public Response<String> createView(@RequestBody TableViewCreateDTO tableView) {
        return Response.ok((Object)this.tableDatasetService.createTableView(tableView));
    }

    @ApiOperation(value="11.4-\u4fee\u6539\u89c6\u56fe")
    @PostMapping(value={"/table/updateview"})
    public Response updateView(@RequestBody TableViewEditDTO tableView) {
        this.tableDatasetService.updateTableView(tableView);
        return Response.ok();
    }

    @ApiOperation(value="12-\u8ba1\u7b97\u6570\u636e\u96c6\u7a7a\u95f4\u8303\u56f4")
    @PostMapping(value={"/dataset/calcextent/{id}"})
    public Response<ExtentDTO> calculateExtent(@PathVariable String id) {
        return Response.ok((Object)this.geoDatabaseService.calculateExtent(id));
    }

    @ApiOperation(value="13-\u4fee\u6539\u6570\u636e\u96c6\u5b57\u6bb5")
    @PostMapping(value={"/dataset/updatefields/{id}"})
    public Response updateFields(@PathVariable String id, @RequestBody FieldsEditDTO fields) {
        this.geoDatabaseService.updateDatasetFields(id, fields);
        return Response.ok();
    }

    @ApiOperation(value="14-\u5bfc\u51fa\u5b57\u6bb5\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="datasetId", value="\u6570\u636e\u96c6id", paramType="query")})
    @GetMapping(value={"/field/export"})
    public void exportFields(String datasetId, HttpServletRequest request, HttpServletResponse response) {
        this.geoDatabaseService.exportFields(datasetId, request, response);
    }

    @ApiOperation(value="15-\u8bfb\u53d6\u6a21\u677f\u6587\u4ef6\u5b57\u6bb5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u5b57\u6bb5\u6a21\u677fexcel\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class)})
    @UploadFileCheck(supportedSuffixes={".xlsx", ".xls"})
    @PostMapping(value={"/field/template"})
    public Response<List<FieldDTO>> loadFieldTemplateFile(@RequestPart MultipartFile file) {
        return Response.ok((Object)this.geoDatabaseService.loadFieldTemplateFile(file));
    }
}

