create table tbchart_snapshot
(
    f_id         serial8
        constraint tbchart_snapshot_pk
            primary key,
    f_sceneid    varchar(64),
    f_snapshotkey text,
    f_thumbnail  text,
    f_sceneshot  text,
    f_mapshot    text,
    f_createtime timestamp(6)
);

comment on table tbchart_snapshot is '场景快照';

comment on column tbchart_snapshot.f_sceneid is '场景id';

comment on column tbchart_snapshot.f_snapshotkey is '快照标识';

comment on column tbchart_snapshot.f_thumbnail is '场景缩略图';

comment on column tbchart_snapshot.f_sceneshot is '场景截图';

comment on column tbchart_snapshot.f_mapshot is '地图截图';

comment on column tbchart_snapshot.f_createtime is '创建时间';

create unique index tbchart_snapshot_f_key_index
    on tbchart_snapshot (f_sceneid, f_snapshotkey);

alter table tbchart_snapshot
    add constraint tbchart_snapshot_tbchart_scene_f_id_fk
        foreign key (f_sceneid) references tbchart_scene
            on delete cascade;


