/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.catalog;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.catalog.dto.mapscene.MapSceneDTO;
import com.geoway.adf.dms.catalog.entity.CmMapScene;
import com.geoway.adf.dms.catalog.service.MapSceneService;
import com.geoway.adf.dms.common.web.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/config/map"})
@Api(tags={"03.05-\u5e94\u7528\u76ee\u5f55-\u6570\u636e\u573a\u666f"})
public class MapSceneController {
    @Resource
    private MapSceneService mapSceneService;

    @ApiOperation(value="01-\u83b7\u53d6\u6570\u636e\u573a\u666f\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd"), @ApiImplicitParam(name="withPicture", value="\u662f\u5426\u8fd4\u56de\u56fe\u7247\uff0c\u9ed8\u8ba4\u4e0d\u8fd4\u56de")})
    @GetMapping(value={"/scene/tree"})
    public Response<List<MapSceneDTO>> tree(@RequestParam(required=false) String keyword, @RequestParam(required=false, defaultValue="false") Boolean withPicture) {
        return Response.ok((Object)this.mapSceneService.tree(withPicture, keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u6570\u636e\u573a\u666f\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u573a\u666f\u6807\u8bc6", required=true)})
    @GetMapping(value={"/scene"})
    public Response<MapSceneDTO> getDetail(@RequestParam String id) {
        return Response.ok((Object)this.mapSceneService.getDetail(id));
    }

    @ApiOperation(value="03-\u65b0\u589e\u6570\u636e\u573a\u666f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u573a\u666f\u7c7b\u578b0-\u5206\u7ec4\uff0c1-\u573a\u666f")})
    @UploadFileCheck(supportedSuffixes={".png", ".jpg", ".jpeg"})
    @PostMapping(value={"/scene/add"})
    public Response<String> addMapScene(@RequestParam String name, @RequestParam Integer type, @RequestParam(required=false) String pid, @RequestParam(required=false) String desc, @RequestParam(required=false) String layerInfo, @RequestParam(required=false) String location, @RequestParam(required=false) String chartUrl, @RequestPart(required=false) MultipartFile picture) {
        CmMapScene mapScene = new CmMapScene();
        mapScene.setName(name);
        mapScene.setPid(pid);
        mapScene.setType(type);
        mapScene.setDesc(desc);
        mapScene.setLayerInfo(layerInfo);
        mapScene.setLocation(location);
        mapScene.setChartUrl(chartUrl);
        return Response.ok((Object)this.mapSceneService.saveScene(mapScene, picture, Boolean.valueOf(false)));
    }

    @ApiOperation(value="04-\u66f4\u65b0\u6570\u636e\u573a\u666f")
    @UploadFileCheck(supportedSuffixes={".png", ".jpg", ".jpeg"})
    @PostMapping(value={"/scene/update"})
    public Response updateMapScene(@RequestParam String id, @RequestParam String name, @RequestParam(required=false) String desc, @RequestParam(required=false) String layerInfo, @RequestParam(required=false) String location, @RequestParam(required=false) String chartUrl, @RequestPart(required=false) MultipartFile picture, @RequestParam(required=false, defaultValue="false") Boolean deletePicture) {
        CmMapScene mapScene = new CmMapScene();
        mapScene.setId(id);
        mapScene.setName(name);
        mapScene.setDesc(desc);
        mapScene.setLayerInfo(layerInfo);
        mapScene.setLocation(location);
        mapScene.setChartUrl(chartUrl);
        this.mapSceneService.saveScene(mapScene, picture, deletePicture);
        return Response.ok();
    }

    @ApiOperation(value="05-\u5220\u9664\u6570\u636e\u573a\u666f")
    @PostMapping(value={"/scene/del"})
    public Response deleteScene(@RequestParam String id) {
        this.mapSceneService.deleteScene(id);
        return Response.ok();
    }
}

