/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.common.web.ResponsePage;
import com.geoway.adf.dms.datasource.dto.input.AtlasDataInputParams;
import com.geoway.adf.dms.datasource.dto.input.DataInputExportTaskResultDTO;
import com.geoway.adf.dms.datasource.dto.input.DataInputParams;
import com.geoway.adf.dms.datasource.dto.input.RasterDataInputParams;
import com.geoway.adf.dms.datasource.dto.output.AtlasExportParams;
import com.geoway.adf.dms.datasource.dto.output.Data2AtlasExportParams;
import com.geoway.adf.dms.datasource.dto.output.DataExportParams;
import com.geoway.adf.dms.datasource.service.DatasetInputExportService;
import com.geoway.adf.gis.basic.PageList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/task"})
@Api(tags={"01.13-\u6570\u636e\u96c6\u5bfc\u5165\u5bfc\u51fa"})
public class DatasetInputExportController {
    @Resource
    private DatasetInputExportService datasetInputExportService;

    @ApiOperation(value="01-\u77e2\u91cf\u6570\u636e\u5bfc\u5165", notes="\u6dfb\u52a0\u77e2\u91cf\u6570\u636e\u5bfc\u5165\u4efb\u52a1")
    @PostMapping(value={"/input"})
    public Response<String> dataInput(@RequestBody DataInputParams inputParam) {
        return Response.ok((Object)this.datasetInputExportService.dataInput(inputParam));
    }

    @ApiOperation(value="02-\u9576\u5d4c\u6570\u636e\u96c6\u5bfc\u5165", notes="\u6dfb\u52a0\u9576\u5d4c\u6570\u636e\u96c6\u5bfc\u5165\u4efb\u52a1")
    @PostMapping(value={"/input/raster"})
    public Response<String> rasterInput(@RequestBody RasterDataInputParams inputParam) {
        return Response.ok((Object)this.datasetInputExportService.rasterInput(inputParam));
    }

    @ApiOperation(value="03-\u6570\u636e\u5bfc\u51fa\uff08\u8981\u7d20\u7c7b/\u8868\u683c\uff09", notes="\u6dfb\u52a0\u6570\u636e\u5bfc\u51fa\u4efb\u52a1")
    @PostMapping(value={"/export"})
    public Response<String> dataExport(@RequestBody DataExportParams exportParam) {
        return Response.ok((Object)this.datasetInputExportService.dataExport(exportParam));
    }

    @ApiOperation(value="04-\u5927\u6570\u636e\u8d44\u6e90\u6c60\u6570\u636e\u5bfc\u51fa", notes="\u6dfb\u52a0\u6570\u636e\u5bfc\u51fa\u4efb\u52a1")
    @PostMapping(value={"/export/atlas"})
    public Response<String> atlasExport(@RequestBody AtlasExportParams exportParam) {
        return Response.ok((Object)this.datasetInputExportService.atlasExport(exportParam));
    }

    @ApiOperation(value="05-\u7a7a\u95f4\u5e93\u6570\u636e\u5bfc\u51fa\u5230\u5927\u6570\u636e\u8d44\u6e90\u6c60")
    @PostMapping(value={"/export2atlas"})
    public Response uploadGeoDatabaseData(Data2AtlasExportParams exportParam) {
        return Response.ok((Object)this.datasetInputExportService.dataExport2Atlas(exportParam));
    }

    @ApiOperation(value="06-\u4e0a\u4f20\u6587\u4ef6\u6570\u636e\u5230\u5927\u6570\u636e\u8d44\u6e90\u6c60")
    @PostMapping(value={"/input2atlas"})
    public Response uploadFileData(AtlasDataInputParams inputParam) {
        return Response.ok((Object)this.datasetInputExportService.dataInput2Atlas(inputParam));
    }

    @ApiOperation(value="07-\u83b7\u53d6\u5bfc\u5165\u5bfc\u51fa\u4efb\u52a1\u5217\u8868", notes="\u83b7\u53d6\u5bfc\u5165\u5bfc\u51fa\u4efb\u52a1\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageIndex", value="\u5206\u9875\u7d22\u5f15", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6570\u91cf", defaultValue="10"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd\uff08\u4efb\u52a1\u540d\u79f0\u8fc7\u6ee4\uff09"), @ApiImplicitParam(name="taskType", value="\u4efb\u52a1\u7c7b\u578b\uff08\u5bfc\u5165/\u5bfc\u51fa\uff09"), @ApiImplicitParam(name="status", value="\u4efb\u52a1\u72b6\u6001\uff0c\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00"), @ApiImplicitParam(name="dbKey", value="\u6570\u636e\u5e93\u6807\u8bc6")})
    @GetMapping(value={"/list"})
    public ResponsePage<DataInputExportTaskResultDTO> getAllTask(@RequestParam(required=false, defaultValue="0") Integer pageIndex, @RequestParam(required=false, defaultValue="10") Integer rows, @RequestParam(required=false) String keyword, @RequestParam(required=false) String taskType, @RequestParam(required=false) String status, @RequestParam(required=false) String dbKey) {
        return ResponsePage.ok((PageList)this.datasetInputExportService.getAllTask(pageIndex.intValue(), rows.intValue(), keyword, taskType, status, dbKey));
    }

    @ApiOperation(value="08-\u83b7\u53d6\u6b63\u5728\u6267\u884c\u7684\u4efb\u52a1\u4e2a\u6570")
    @GetMapping(value={"/running/count"})
    public Response<Integer> getRunningTaskCount() {
        return Response.ok((Object)this.datasetInputExportService.getRunningTaskCount());
    }

    @ApiOperation(value="09-\u5220\u9664\u5bfc\u5165\u5bfc\u51fa\u4efb\u52a1")
    @ApiImplicitParam(name="id", value="\u4efb\u52a1id", required=true, paramType="query")
    @DeleteMapping(value={""})
    public Response deleteTask(@RequestParam String id) {
        this.datasetInputExportService.deleteTask(id);
        return Response.ok();
    }

    @ApiOperation(value="10-\u4e0b\u8f7d\u5bfc\u51fa\u7684\u6570\u636e")
    @ApiImplicitParam(name="id", value="\u4efb\u52a1id", required=true, paramType="query")
    @GetMapping(value={"/download"})
    public void downloadData(@RequestParam String id) {
        this.datasetInputExportService.downloadExportData(id);
    }
}

