/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.graph.DatabaseQueryResultDTO;
import com.geoway.adf.dms.datasource.dto.graph.GraphDatabaseDetailDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.adf.dms.datasource.service.GraphDatabaseService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/graph"})
@Api(tags={"01.05-\u56fe\u6570\u636e\u5e93"})
public class GraphDatabaseController {
    @Resource
    private GraphDatabaseService graphDatabaseService;
    @Resource
    private DataSourceService dataSourceService;

    @ApiOperation(value="01-\u83b7\u53d6\u56fe\u6570\u636e\u5e93\u6807\u7b7e\u3001\u5173\u7cfb\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u56fe\u6570\u636e\u5e93Key")})
    @GetMapping(value={"/detail"})
    public Response<GraphDatabaseDetailDTO> getDetail(@RequestParam String dsKey, @RequestParam(required=false) Boolean withLabelAliasName) {
        return Response.ok((Object)this.graphDatabaseService.getDetail(this.dataSourceService.getDataSourceDetail(dsKey), withLabelAliasName));
    }

    @ApiOperation(value="02-\u67e5\u8be2\u56fe\u6570\u636e\u5e93\u6807\u7b7e(\u641c\u7d22\u7ed3\u679c\u5305\u542b\u7b2c\u4e00\u7ea7\u5173\u7cfb)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", required=true, value="\u56fe\u6570\u636e\u5e93Key"), @ApiImplicitParam(name="type", value="\u6807\u7b7e\u7c7b\u578b"), @ApiImplicitParam(name="limit", defaultValue="25", value="\u67e5\u8be2\u6570\u91cf"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd")})
    @GetMapping(value={"/label"})
    public Response<DatabaseQueryResultDTO> queryLabel(@RequestParam String dsKey, @RequestParam(required=false) String type, @RequestParam(required=false, defaultValue="25") Integer limit, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.graphDatabaseService.queryLabels(this.dataSourceService.getDataSourceDetail(dsKey), type, limit, keyword));
    }

    @ApiOperation(value="03-\u67e5\u8be2\u56fe\u6570\u636e\u5e93\u5173\u7cfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", required=true, value="\u56fe\u6570\u636e\u5e93Key"), @ApiImplicitParam(name="type", value="\u5173\u7cfb\u7c7b\u578b"), @ApiImplicitParam(name="limit", defaultValue="25", value="\u67e5\u8be2\u6570\u91cf")})
    @GetMapping(value={"/relation"})
    public Response<DatabaseQueryResultDTO> queryRelation(@RequestParam String dsKey, @RequestParam(required=false) String type, @RequestParam(required=false, defaultValue="25") Integer limit) {
        return Response.ok((Object)this.graphDatabaseService.queryRelations(this.dataSourceService.getDataSourceDetail(dsKey), type, limit));
    }
}

