/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.baselayermap.BaseMapCategoryDTO;
import com.geoway.adf.dms.config.dto.baselayermap.BaseMapGroupDTO;
import com.geoway.adf.dms.config.dto.baselayermap.BaseMapSchemeDTO;
import com.geoway.adf.dms.config.dto.baselayermap.BaseMapServiceDTO;
import com.geoway.adf.dms.config.service.BaseLayerMapService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config/basemap"})
@Api(tags={"04.08-\u914d\u7f6e\u7ba1\u7406-\u5e95\u56fe\u914d\u7f6e2"})
public class BaseLayerMapController {
    @Resource
    private BaseLayerMapService baseLayerMapService;

    @ApiOperation(value="01-\u83b7\u53d6\u5e95\u56fe\u65b9\u6848\u5217\u8868")
    @GetMapping(value={"/listScheme"})
    public Response<List<BaseMapSchemeDTO>> listScheme() {
        return Response.ok((Object)this.baseLayerMapService.listScheme());
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5e95\u56fe\u65b9\u6848\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="shcemeId", value="\u5e95\u56fe\u65b9\u6848id"), @ApiImplicitParam(name="shcemeCode", value="\u5e95\u56fe\u65b9\u6848\u7f16\u7801"), @ApiImplicitParam(name="onlyEnabled", value="\u662f\u5426\u53ea\u8fd4\u56de\u542f\u7528\u7684\u5e95\u56fe")})
    @GetMapping(value={"/detail/scheme"})
    public Response<BaseMapSchemeDTO> getBaseMapScheme(@RequestParam(required=false) String shcemeId, @RequestParam(required=false) String shcemeCode, @RequestParam(required=false, defaultValue="true") Boolean onlyEnabled) {
        return Response.ok((Object)this.baseLayerMapService.getBaseMapScheme(shcemeId, shcemeCode, onlyEnabled));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u5e95\u56fe\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e95\u56feid")})
    @GetMapping(value={"/detail"})
    public Response<BaseMapCategoryDTO> getDetail(String id) {
        return Response.ok((Object)this.baseLayerMapService.getBaseMapCategory(id));
    }

    @ApiOperation(value="04-\u4fdd\u5b58\u5e95\u56fe\u65b9\u6848")
    @PostMapping(value={"/save/scheme"})
    public Response<String> saveBaseMapCategory(@Valid @RequestBody BaseMapSchemeDTO schemeDTO) {
        return Response.ok((Object)this.baseLayerMapService.saveBaseMapScheme(schemeDTO));
    }

    @ApiOperation(value="05-\u4fdd\u5b58\u5e95\u56fe")
    @PostMapping(value={"/save/map"})
    public Response<String> addBaseMapGroup(@Valid @RequestBody BaseMapCategoryDTO categoryDTO) {
        return Response.ok((Object)this.baseLayerMapService.saveBaseMapCategory(categoryDTO));
    }

    @ApiOperation(value="06-\u4fdd\u5b58\u5206\u7ec4")
    @PostMapping(value={"/save/group"})
    public Response<String> saveBaseMapGroup(@Valid @RequestBody BaseMapGroupDTO groupDTO) {
        return Response.ok((Object)this.baseLayerMapService.saveBaseMapGroup(groupDTO));
    }

    @ApiOperation(value="07-\u4fdd\u5b58\u5e95\u56fe\u670d\u52a1")
    @PostMapping(value={"/save/service"})
    public Response<String> saveBaseMapService(@Valid @RequestBody BaseMapServiceDTO serviceDTO) {
        return Response.ok((Object)this.baseLayerMapService.saveBaseMapService(serviceDTO));
    }

    @ApiOperation(value="08-\u5220\u9664")
    @ApiImplicitParam(name="id", value="\u6807\u8bc6", required=true)
    @PostMapping(value={"/del"})
    public Response deleteBaseMap(@RequestParam String id) {
        this.baseLayerMapService.delete(id);
        return Response.ok();
    }

    @ApiOperation(value="09-\u8bbe\u7f6e\u9ed8\u8ba4")
    @PostMapping(value={"/default"})
    public Response setDefault(@RequestParam String id, @RequestParam Boolean isDefault) {
        this.baseLayerMapService.setDefault(id, isDefault);
        return Response.ok();
    }

    @ApiOperation(value="10-\u8c03\u6574\u987a\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6807\u8bc6", required=true), @ApiImplicitParam(name="pid", value="\u7236\u6807\u8bc6", required=false), @ApiImplicitParam(name="order", value="\u79fb\u52a8\u540e\u4e0a\u4e00\u4e2a\u8282\u70b9\u7684\u987a\u5e8f", required=true)})
    @PostMapping(value={"/order"})
    public Response updateServiceOrder(@RequestParam String id, @RequestParam(required=false) String pid, @RequestParam Integer order) {
        this.baseLayerMapService.updateOrder(id, pid, order);
        return Response.ok();
    }

    @ApiOperation(value="11-\u7f16\u8f91\u5e95\u56fe\u7684\u521d\u59cb\u4f4d\u7f6e")
    @PostMapping(value={"/extent"})
    public Response updateBaseMapExtentJson(String schemeId, String extentJson) {
        this.baseLayerMapService.updateBaseMapExtent(schemeId, extentJson);
        return Response.ok();
    }
}

