/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDTO;
import com.geoway.adf.dms.config.dto.geotemplate.GeoTemplateDatasetDTO;
import com.geoway.adf.dms.config.service.GeoTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config/geotemplate"})
@Api(tags={"04.14-\u914d\u7f6e\u7ba1\u7406-\u7a7a\u95f4\u6570\u636e\u6a21\u677f"})
public class GeoTemplateController {
    @Resource
    private GeoTemplateService geoTemplateService;

    @ApiOperation(value="01-\u83b7\u53d6\u6570\u636e\u6a21\u677f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd")})
    @GetMapping(value={"/list"})
    public Response<List<GeoTemplateDTO>> list(@RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.geoTemplateService.listTemplate(keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u6570\u636e\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6a21\u677fid"), @ApiImplicitParam(name="code", value="\u6a21\u677f\u7f16\u7801\uff08\u5982\u679cid\u4e3a\u7a7a\u5219\u6839\u636e\u7f16\u7801\u83b7\u53d6\uff09")})
    @GetMapping(value={"/detail"})
    public Response<GeoTemplateDTO> getTemplate(@RequestParam(required=false) String id, @RequestParam(required=false) String code) {
        return Response.ok((Object)this.geoTemplateService.getGeoTemplate(id, code));
    }

    @ApiOperation(value="03-\u4fdd\u5b58\u6570\u636e\u6a21\u677f")
    @PostMapping(value={"/save"})
    public Response<String> saveTemplate(@RequestBody GeoTemplateDTO template) {
        return Response.ok((Object)this.geoTemplateService.saveGeoTemplate(template));
    }

    @ApiOperation(value="04-\u5220\u9664\u6570\u636e\u6a21\u677f")
    @PostMapping(value={"/del"})
    public Response deleteTemplate(String id) {
        this.geoTemplateService.deleteGeoTemplate(id);
        return Response.ok();
    }

    @ApiOperation(value="05-\u4fdd\u5b58\u6570\u636e\u96c6\u56fe\u5c42")
    @PostMapping(value={"/savedataset"})
    public Response saveDataset(@RequestBody GeoTemplateDatasetDTO templateDataset) {
        this.geoTemplateService.saveDataset(templateDataset);
        return Response.ok();
    }

    @ApiOperation(value="06-\u5220\u9664\u6570\u636e\u96c6\u56fe\u5c42")
    @ApiImplicitParams(value={@ApiImplicitParam(name="templateId", value="\u6a21\u677fid"), @ApiImplicitParam(name="datasetName", value="\u6570\u636e\u96c6\u56fe\u5c42\u540d\u79f0")})
    @PostMapping(value={"/deldataset"})
    public Response deleteDataset(String templateId, String datasetName) {
        this.geoTemplateService.deleteDataset(templateId, datasetName);
        return Response.ok();
    }

    @ApiOperation(value="07-\u5bfc\u51fa\u6570\u636e\u6a21\u677f")
    @GetMapping(value={"/export"})
    public void exportGeoTemplate(String id) {
        this.geoTemplateService.exportGeoTemplate(id);
    }
}

