/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.district.DistrictCreateDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictEditDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemEditDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemImportDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictLevelCreateDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictLevelDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictLevelEditDTO;
import com.geoway.adf.dms.datasource.dto.district.DistrictTreeDTO;
import com.geoway.adf.dms.datasource.dto.district.DmDistrictDTO;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config/district"})
@Api(tags={"04.10-\u914d\u7f6e\u7ba1\u7406-\u653f\u533a\u65b9\u6848\u914d\u7f6e"})
public class DistrictController {
    @Resource
    private DistrictService districtService;

    @ApiOperation(value="01-\u83b7\u53d6\u884c\u653f\u533a\u57df\u65b9\u6848\u5217\u8868")
    @GetMapping(value={"/list"})
    public Response<List<DmDistrictDTO>> list() {
        return Response.ok((Object)this.districtService.list());
    }

    @ApiOperation(value="02-\u83b7\u53d6\u533a\u57df\u65b9\u6848-\u7ea7\u522b\u6811")
    @GetMapping(value={"/dic/level/tree"})
    public Response<List<DistrictTreeDTO>> tree() {
        return Response.ok((Object)this.districtService.tree());
    }

    @ApiOperation(value="03-\u83b7\u53d6\u533a\u57df\u65b9\u6848\u7684\u6240\u6709\u533a\u57df\u7ea7\u522b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="districtId", value="\u884c\u653f\u533a\u57df\u65b9\u6848\u552f\u4e00\u6807\u8bc6")})
    @GetMapping(value={"/level/list"})
    public Response<List<DistrictLevelDTO>> getDistrictLevels(@RequestParam Long districtId) {
        return Response.ok((Object)this.districtService.getDistrictLevels(districtId));
    }

    @ApiOperation(value="04-\u83b7\u53d6\u533a\u57df\u5355\u5143\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="districtId", value="\u884c\u653f\u533a\u57df\u65b9\u6848\u552f\u4e00\u6807\u8bc6", required=true), @ApiImplicitParam(name="pid", value="\u7236\u8282\u70b9\u6807\u8bc6"), @ApiImplicitParam(name="pCode", value="\u7236\u653f\u533a\u7f16\u7801\uff0c\u5982\u679cpid\u4e3anull\u65f6\u624d\u751f\u6548"), @ApiImplicitParam(name="withChildren", value="\u662f\u5426\u83b7\u53d6\u5b69\u5b50\u8282\u70b9\u4fe1\u606f"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd"), @ApiImplicitParam(name="searchCount", value="\u641c\u7d22\u7ed3\u679c\u8fd4\u56de\u4e0a\u9650")})
    @GetMapping(value={"/tree"})
    public Response<List<DistrictItemDTO>> getDistrictItem(@RequestParam Long districtId, @RequestParam(required=false) Long pid, @RequestParam(required=false) String pCode, @RequestParam(required=false, defaultValue="false") Boolean withChildren, @RequestParam(required=false) String keyword, @RequestParam(required=false) Integer searchCount) {
        return Response.ok((Object)this.districtService.getDistrictItem(districtId, pid, pCode, keyword, withChildren, searchCount));
    }

    @ApiOperation(value="05-\u83b7\u53d6\u533a\u57df\u5355\u5143\u6811(\u6309\u9996\u5b57\u6bcd\u5206\u7ec4)")
    @ApiImplicitParams(value={@ApiImplicitParam(name="districtId", value="\u884c\u653f\u533a\u57df\u65b9\u6848\u552f\u4e00\u6807\u8bc6", required=true), @ApiImplicitParam(name="pid", value="\u7236\u8282\u70b9\u6807\u8bc6"), @ApiImplicitParam(name="withChildren", value="\u662f\u5426\u83b7\u53d6\u5b69\u5b50\u8282\u70b9\u4fe1\u606f"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd")})
    @GetMapping(value={"/tree/group"})
    public Response<Map<String, List<DistrictItemDTO>>> getDistrictItemsGroup(@RequestParam Long districtId, @RequestParam(required=false, defaultValue="-1") Long pid, @RequestParam(required=false, defaultValue="false") Boolean withChildren, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.districtService.getDistrictItemsGroup(districtId, pid, keyword, withChildren));
    }

    @ApiOperation(value="06-\u6dfb\u52a0\u884c\u653f\u533a\u57df\u65b9\u6848")
    @PostMapping(value={""})
    public Response<Long> addDistrict(@RequestBody DistrictCreateDTO createDTO) {
        return Response.ok((Object)this.districtService.addDistrict(createDTO));
    }

    @ApiOperation(value="07-\u4fee\u6539\u884c\u653f\u533a\u57df\u65b9\u6848")
    @PutMapping(value={""})
    public Response updateDistrict(@RequestBody DistrictEditDTO editDTO) {
        this.districtService.updateDistrict(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="08-\u5220\u9664\u884c\u653f\u533a\u57df\u65b9\u6848")
    @DeleteMapping(value={"/{id}"})
    public Response deleteDistrict(@PathVariable Long id) {
        this.districtService.deleteDistrict(id);
        return Response.ok();
    }

    @ApiOperation(value="09-\u8bbe\u7f6e\u9ed8\u8ba4\u533a\u57df\u65b9\u6848")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u76ee\u5f55\u6807\u8bc6", required=true), @ApiImplicitParam(name="isDefault", value="\u662f\u5426\u4e3a\u9ed8\u8ba4", required=true, dataType="Boolean")})
    @PutMapping(value={"/default"})
    public Response setDefaultDistrict(@RequestParam Long id, @RequestParam Boolean isDefault) {
        this.districtService.setDefaultDistrict(isDefault, id);
        return Response.ok();
    }

    @ApiOperation(value="10-\u83b7\u53d6\u533a\u57df\u7ea7\u522b\u8be6\u60c5")
    @GetMapping(value={"/level"})
    public Response<DistrictLevelDTO> getDistrictLevelDetail(@RequestParam Long districtId, @RequestParam Short index) {
        return Response.ok((Object)this.districtService.getDistrictLevelDetail(districtId, index));
    }

    @ApiOperation(value="11-\u6dfb\u52a0\u533a\u57df\u7ea7\u522b")
    @PostMapping(value={"/level"})
    public Response addDistrictLevel(@RequestBody DistrictLevelCreateDTO createDTO) {
        this.districtService.addDistrictLevel(createDTO);
        return Response.ok();
    }

    @ApiOperation(value="12-\u4fee\u6539\u533a\u57df\u7ea7\u522b")
    @PutMapping(value={"/level"})
    public Response updateDistrictLevel(@RequestBody DistrictLevelEditDTO editDTO) {
        this.districtService.updateDistrictLevel(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="13-\u5220\u9664\u533a\u57df\u7ea7\u522b")
    @DeleteMapping(value={"/level"})
    public Response deleteDistrictLevel(@RequestParam Long districtId, @RequestParam Short index) {
        this.districtService.deleteDistrictLevel(districtId, index);
        return Response.ok();
    }

    @ApiOperation(value="14-\u5bfc\u5165\u533a\u57df\u5355\u5143")
    @PostMapping(value={"/item/import"})
    public Response importDistrictItems(@RequestBody DistrictItemImportDTO importDTO) {
        this.districtService.importDistrictItems(importDTO);
        return Response.ok();
    }

    @ApiOperation(value="15-\u83b7\u53d6\u533a\u57df\u5355\u5143\u8be6\u60c5")
    @GetMapping(value={"/item"})
    public Response<DistrictItemDTO> getDistrictItemDetail(@RequestParam Long id, @RequestParam(required=false) Long districtId, @RequestParam(required=false) Boolean withChildren) {
        DistrictItemDTO districtItemDTO = this.districtService.getDistrictItemDetail(id);
        if (districtItemDTO != null && Boolean.TRUE.equals(withChildren)) {
            Assert.notNull((Object)districtId, (String)"\u672a\u8bbe\u7f6edistrictId");
            districtItemDTO.setChildren(this.districtService.getDistrictItem(districtId, id, null, null, Boolean.valueOf(true), null));
        }
        return Response.ok((Object)districtItemDTO);
    }

    @ApiOperation(value="15.2-\u83b7\u53d6\u533a\u57df\u5355\u5143\u8be6\u60c5")
    @GetMapping(value={"/itemByCode"})
    public Response<DistrictItemDTO> getDistrictItemDetail(@RequestParam(required=false) Long districtId, @RequestParam(required=false) Integer level, @RequestParam String code, @RequestParam(required=false) Boolean withChildren) {
        DistrictItemDTO districtItemDTO = this.districtService.getDistrictItemDetail(districtId, level, code);
        if (districtItemDTO != null && Boolean.TRUE.equals(withChildren)) {
            districtId = districtItemDTO.getDistrictId();
            districtItemDTO.setChildren(this.districtService.getDistrictItem(districtId, null, code, null, Boolean.valueOf(true), null));
        }
        return Response.ok((Object)districtItemDTO);
    }

    @ApiOperation(value="16-\u4fee\u6539\u533a\u57df\u5355\u5143")
    @PostMapping(value={"/item"})
    public Response updateDistrictItem(@RequestBody DistrictItemEditDTO editDTO) {
        this.districtService.updateDistrictItem(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="17-\u5220\u9664\u533a\u57df\u5355\u5143")
    @DeleteMapping(value={"/item"})
    public Response deleteDistrictItem(@RequestParam Long districtId, @RequestParam Long id) {
        this.districtService.deleteDistrictItem(districtId, id);
        return Response.ok();
    }

    @ApiOperation(value="18-\u83b7\u53d6\u533a\u57df\u5355\u5143\u8303\u56f4")
    @GetMapping(value={"/item/region"})
    public Response<String> getDistrictItemExtent(@RequestParam Long id) {
        IGeometry geometry = this.districtService.getDistrictItemGeometry(id);
        if (geometry == null) {
            return Response.error((String)"\u672a\u8bfb\u53d6\u5230\u653f\u533a\u5355\u5143\u8303\u56f4");
        }
        return Response.ok((Object)geometry.toWkt());
    }

    @ApiOperation(value="19-\u8bbe\u7f6e\u9ed8\u8ba4\u533a\u57df\u5355\u5143")
    @PutMapping(value={"/item/default"})
    public Response updateDistrictLevel(@RequestParam Long districtId, @RequestParam(required=false) Long id) {
        this.districtService.setDefaultDistrictItem(districtId, id);
        return Response.ok();
    }

    @ApiOperation(value="20-\u83b7\u53d6\u9ed8\u8ba4\u533a\u57df\u5355\u5143")
    @GetMapping(value={"/item/default"})
    public Response<DistrictItemDTO> getDefaultDistrictItem(@RequestParam(required=false) Long districtId) {
        return Response.ok((Object)this.districtService.getDefaultDistrictItem(districtId));
    }

    @ApiOperation(value="21-\u533a\u57df\u5355\u5143\u7a7a\u95f4\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="districtId", value="\u653f\u533a\u65b9\u6848id\uff0c\u4e0d\u8bbe\u7f6e\u4f7f\u7528\u9ed8\u8ba4\u7684\u653f\u533a\u65b9\u6848", required=false), @ApiImplicitParam(name="level", value="\u653f\u533a\u7ea7\u522b\uff0c\u4ece1\u5f00\u59cb", required=true), @ApiImplicitParam(name="geometry", value="\u67e5\u8be2wkt", required=true)})
    @GetMapping(value={"/item/query"})
    public Response<List<DistrictItemDTO>> queryDistrictItem(@RequestParam(required=false) Long districtId, @RequestParam Short level, @RequestParam String geometry) {
        return Response.ok((Object)this.districtService.queryDistrictItem(districtId, level, geometry));
    }
}

