/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.catalog;

import com.alibaba.fastjson.JSONObject;
import com.geoway.adf.dms.catalog.dto.CatalogDataNodeFieldsDTO;
import com.geoway.adf.dms.catalog.dto.query.AttributeQueryDTO;
import com.geoway.adf.dms.catalog.dto.query.FeatureFieldQueryResultDTO;
import com.geoway.adf.dms.catalog.dto.query.FeatureQueryFilterDTO;
import com.geoway.adf.dms.catalog.dto.query.IdentifyQueryExtentFilterDTO;
import com.geoway.adf.dms.catalog.dto.query.IdentifyQueryFilterDTO;
import com.geoway.adf.dms.catalog.dto.query.QueryByFieldValueDTO;
import com.geoway.adf.dms.catalog.dto.query.QueryByObjectIdDTO;
import com.geoway.adf.dms.catalog.dto.query.StatQueryNodeFilterDTO;
import com.geoway.adf.dms.catalog.dto.query.StatQuerySingleResultDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogLayerQueryService;
import com.geoway.adf.dms.catalog.service.AppCatalogService;
import com.geoway.adf.dms.catalog.service.impl.AggregationQueryService;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.filepackage.data.FileDataUnitDTO;
import com.geoway.adf.dms.datasource.dto.query.DataQueryResult;
import com.geoway.adf.dms.datasource.dto.query.StatQueryResultDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/catalog/browse"})
@Api(tags={"03.01-\u5e94\u7528\u76ee\u5f55-\u6d4f\u89c8\u67e5\u8be2"})
public class AppCatalogQueryController {
    @Resource
    private AppCatalogService appCatalogService;
    @Resource
    private AppCatalogLayerQueryService queryService;
    @Resource
    private AggregationQueryService aggregationQueryService;

    @ApiOperation(value="00-\u8bbe\u7f6e\u9ed8\u8ba4\u5e94\u7528\u76ee\u5f55", hidden=true)
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u76ee\u5f55\u6807\u8bc6", required=true), @ApiImplicitParam(name="isDefault", value="\u662f\u5426\u4e3a\u9ed8\u8ba4", required=true, dataType="Boolean")})
    @PutMapping(value={"/default"})
    public Response setDefaultCatalog(@RequestParam String id, @RequestParam Boolean isDefault) {
        this.appCatalogService.setDefaultCatalog(isDefault, id);
        return Response.ok();
    }

    @ApiOperation(value="01-\u5e94\u7528\u76ee\u5f55\u56fe\u5c5e\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public Response<DataQueryResult> queryData(@RequestBody FeatureQueryFilterDTO queryFilterDTO) {
        return Response.ok((Object)this.queryService.queryData(queryFilterDTO, null));
    }

    @ApiOperation(value="02-\u5e94\u7528\u76ee\u5f55\u5c5e\u6027\u8868\u67e5\u8be2")
    @GetMapping(value={"/query/attribute"})
    public Response<DataQueryResult> queryData(AttributeQueryDTO queryDTO) {
        return Response.ok((Object)this.queryService.queryAttribute(queryDTO));
    }

    @ApiOperation(value="03-\u5e94\u7528\u76ee\u5f55i\u67e5\u8be2")
    @RequestMapping(value={"/query/identify"}, method={RequestMethod.GET, RequestMethod.POST})
    public Response<List<DataQueryResult>> identityQueryData(IdentifyQueryFilterDTO queryFilterDTO) {
        return Response.ok((Object)this.queryService.identifyQuery(queryFilterDTO));
    }

    @ApiOperation(value="04-\u5e94\u7528\u76ee\u5f55\u8981\u7d20\u67e5\u8be2")
    @GetMapping(value={"/query/feature"})
    public Response<DataQueryResult> queryByObjectId(QueryByObjectIdDTO queryByObjectIdDTO) {
        return Response.ok((Object)this.queryService.queryByObjectId(queryByObjectIdDTO));
    }

    @ApiOperation(value="05-\u5168\u5e93\u67e5\u8be2")
    @GetMapping(value={"/query/value"})
    public Response<List<FeatureFieldQueryResultDTO>> queryByFieldValue(QueryByFieldValueDTO queryByObjectIdDTO) {
        return Response.ok((Object)this.queryService.queryByFieldValue(queryByObjectIdDTO));
    }

    @ApiOperation(value="06-\u805a\u5408\u6570\u636e\u67e5\u8be2")
    @GetMapping(value={"/query/aggregation/{nodeId}"})
    public List<JSONObject> queryAggregation(@PathVariable String nodeId, @RequestParam Integer x, @RequestParam Integer y, @RequestParam Integer l) {
        return this.aggregationQueryService.query(nodeId, x, y, l);
    }

    @ApiOperation(value="07-\u7ed3\u679c\u5bfc\u51fa")
    @PostMapping(value={"/query/export"})
    public Response<String> exportQueryResult(@RequestBody FeatureQueryFilterDTO queryFilterDTO) {
        return Response.ok((Object)this.queryService.exportQueryResult(queryFilterDTO));
    }

    @ApiOperation(value="08-\u4e0b\u8f7d\u5bfc\u51fa\u7ed3\u679c")
    @GetMapping(value={"/query/download"})
    public void exportQueryResult(@RequestParam String id) {
        this.queryService.downloadQueryResult(id);
    }

    @ApiOperation(value="09-\u83b7\u53d6\u6570\u636e\u8282\u70b9\u5b57\u6bb5\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeId", value="\u76ee\u5f55\u8282\u70b9\u6807\u8bc6", required=true), @ApiImplicitParam(name="onlyNumber", value="\u4ec5\u83b7\u53d6\u6570\u503c\u578b\u5b57\u6bb5")})
    @GetMapping(value={"/query/fields"})
    public Response<List<CatalogDataNodeFieldsDTO>> queryFields(@RequestParam String nodeId, @RequestParam(required=false, defaultValue="false") Boolean onlyNumber) {
        return Response.ok((Object)this.queryService.queryDataNodeFields(nodeId, onlyNumber));
    }

    @ApiOperation(value="10-\u8282\u70b9\u5c5e\u6027\u8868\u7edf\u8ba1")
    @PostMapping(value={"/query/stat"})
    public Response<Map<String, List<StatQuerySingleResultDTO>>> queryStat(@RequestBody StatQueryNodeFilterDTO statDTO) {
        return Response.ok((Object)this.queryService.queryStat(statDTO));
    }

    @ApiOperation(value="10-\u8282\u70b9\u5c5e\u6027\u8868\u7edf\u8ba1", notes="\u652f\u6301\u591a\u4e2a\u5206\u7ec4\u5b57\u6bb5")
    @PostMapping(value={"/query/statMulti"})
    public Response<List<StatQueryResultDTO>> queryStatMulti(@RequestBody StatQueryNodeFilterDTO statDTO) {
        return Response.ok((Object)this.queryService.queryStatMulti(statDTO));
    }

    @ApiOperation(value="11-\u6570\u636e\u8282\u70b9\u6570\u636e\u6570\u91cf")
    @PostMapping(value={"/query/count"})
    public Response<Long> queryDataCount(@RequestBody FeatureQueryFilterDTO queryFilterDTO) {
        return Response.ok((Object)this.queryService.queryDataCount(queryFilterDTO));
    }

    @ApiOperation(value="12-\u6570\u636e\u8282\u70b9\u5b57\u6bb5\u552f\u4e00\u503c")
    @PostMapping(value={"/query/distinct"})
    public Response<List> queryDataUniqValues(@RequestParam String nodeId, @RequestParam String fieldName, @RequestParam(required=false, defaultValue="100") Integer limit) {
        return Response.ok((Object)this.queryService.queryDataFieldUniqValues(nodeId, fieldName, limit));
    }

    @ApiOperation(value="13-\u67e5\u8be2\u6805\u683c\u6570\u636e\u7684\u50cf\u7d20\u503c")
    @RequestMapping(value={"/query/identify/raster"}, method={RequestMethod.GET, RequestMethod.POST})
    public Response<Map<String, Object>> queryRasterBandValue(IdentifyQueryExtentFilterDTO extentFilter) {
        return Response.ok((Object)this.queryService.queryRasterBandValue(extentFilter));
    }

    @ApiOperation(value="14-\u67e5\u8be2\u6587\u4ef6\u6570\u636e\u96c6\u7684\u6570\u636e\u5305\u6587\u4ef6\u7ec4\u7ec7\u7ed3\u6784")
    @GetMapping(value={"/query/identify/datum"})
    public Response<FileDataUnitDTO> getDatumDataCatalog(QueryByObjectIdDTO extentFilter) {
        return Response.ok((Object)this.queryService.getDatumDataCatalog(extentFilter));
    }

    @ApiOperation(value="15-\u9a8c\u8bc1\u6587\u4ef6\u6570\u636e\u5305\u662f\u5426\u53ef\u4ee5\u4e0b\u8f7d")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeId", value="\u76ee\u5f55\u8282\u70b9\u6807\u8bc6", required=true), @ApiImplicitParam(name="objectId", value="objectId", required=true), @ApiImplicitParam(name="fileLocation", value="\u6587\u4ef6\uff08\u5939\uff09\u76f8\u5bf9\u8def\u5f84\uff0c\u552f\u4e00\u6807\u8bc6")})
    @GetMapping(value={"/datum/download/check"})
    public Response<Boolean> fileDataUnitDownloadCheck(@RequestParam String nodeId, @RequestParam String objectId, @RequestParam(required=false) String fileLocation) {
        return Response.ok((Object)this.queryService.fileDataUnitDownloadCheck(nodeId, objectId, fileLocation));
    }

    @ApiOperation(value="16-\u4e0b\u8f7d\u6587\u4ef6\u6570\u636e\u5305")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeId", value="\u76ee\u5f55\u8282\u70b9\u6807\u8bc6", required=true), @ApiImplicitParam(name="objectId", value="objectId", required=true), @ApiImplicitParam(name="fileLocation", value="\u6587\u4ef6\uff08\u5939\uff09\u76f8\u5bf9\u8def\u5f84\uff0c\u552f\u4e00\u6807\u8bc6")})
    @GetMapping(value={"/datum/download"})
    public void downloadFileDataUnit(@RequestParam String nodeId, @RequestParam String objectId, @RequestParam(required=false) String fileLocation) {
        this.queryService.downloadFileDataUnit(nodeId, objectId, fileLocation);
    }

    @ApiOperation(value="17-\u6269\u5c55\u5c5e\u6027\u503c\u67e5\u8be2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeId", value="\u76ee\u5f55\u8282\u70b9\u6807\u8bc6", required=true), @ApiImplicitParam(name="extendConfigId", value="\u5173\u8054\u914d\u7f6eid", required=true), @ApiImplicitParam(name="fieldValue", value="\u5b57\u6bb5\u503c", required=true), @ApiImplicitParam(name="rowCount", value="\u5173\u8054\u6570\u636e\u6570\u91cf\u9650\u5236", defaultValue="1"), @ApiImplicitParam(name="returnGeometry", value="\u662f\u5426\u8fd4\u56de\u51e0\u4f55\u56fe\u5f62")})
    @GetMapping(value={"/query/extendAtt"})
    public Response<DataQueryResult> queryExtendAttribute(String nodeId, String extendConfigId, String fieldValue, @RequestParam(required=false, defaultValue="1") Integer rowCount, @RequestParam(required=false, defaultValue="false") Boolean returnGeometry) {
        return Response.ok((Object)this.queryService.queryExtendAttribute(nodeId, extendConfigId, fieldValue, rowCount, returnGeometry));
    }

    @ApiOperation(value="18-\u9884\u89c8\u6587\u4ef6\u6570\u636e\u5305\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeId", value="\u76ee\u5f55\u8282\u70b9\u6807\u8bc6", required=true), @ApiImplicitParam(name="objectId", value="objectId", required=true), @ApiImplicitParam(name="fileLocation", value="\u6587\u4ef6\uff08\u5939\uff09\u76f8\u5bf9\u8def\u5f84\uff0c\u552f\u4e00\u6807\u8bc6")})
    @GetMapping(value={"/datum/data/view"})
    public void viewFile(@RequestParam String nodeId, @RequestParam String objectId, @RequestParam(required=false) String fileLocation, HttpServletRequest request, HttpServletResponse response) {
        this.queryService.viewFileDataUnit(nodeId, objectId, fileLocation, request, response);
    }
}

