/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.meta.MetaDataValueDTO;
import com.geoway.adf.dms.config.dto.meta.MetaTemplateDTO;
import com.geoway.adf.dms.config.dto.meta.MetaTemplateFieldDTO;
import com.geoway.adf.dms.config.dto.meta.edit.MetaTemplateCreateDTO;
import com.geoway.adf.dms.config.dto.meta.edit.MetaTemplateEditDTO;
import com.geoway.adf.dms.config.dto.meta.edit.MetaTemplateFieldGroupEditDTO;
import com.geoway.adf.dms.config.service.MetaTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config/meta/template"})
@Api(tags={"04.13-\u914d\u7f6e\u7ba1\u7406-\u5143\u6570\u636e\u6a21\u677f"})
public class MetaTemplateController {
    @Resource
    private MetaTemplateService metaTemplateService;

    @ApiOperation(value="01-\u83b7\u53d6\u5143\u6570\u636e\u6a21\u677f\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd")})
    @GetMapping(value={"/list"})
    public Response<List<MetaTemplateDTO>> list(@RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.metaTemplateService.list(keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5143\u6570\u636e\u6a21\u677f\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5143\u6570\u636e\u6a21\u677f\u6807\u8bc6")})
    @GetMapping(value={"/detail"})
    public Response<MetaTemplateDTO> getMetaTemplateDetail(@RequestParam Long id, @RequestParam(required=false, defaultValue="true") Boolean withFields) {
        return Response.ok((Object)this.metaTemplateService.getMetaTemplateDetail(id, withFields));
    }

    @ApiOperation(value="03-\u6dfb\u52a0\u5143\u6570\u636e\u6a21\u677f")
    @PostMapping
    public Response<Long> addMetaTemplate(@RequestBody MetaTemplateCreateDTO createDTO) {
        return Response.ok((Object)this.metaTemplateService.addMetaTemplate(createDTO));
    }

    @ApiOperation(value="04-\u4fee\u6539\u5143\u6570\u636e\u6a21\u677f")
    @PutMapping
    public Response updateMetaTemplate(@RequestBody MetaTemplateEditDTO editDTO) {
        this.metaTemplateService.updateMetaTemplate(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="05-\u6279\u91cf\u5220\u9664\u5143\u6570\u636e\u6a21\u677f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="\u5143\u6570\u636e\u6a21\u677f\u6807\u8bc6\uff0c\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00")})
    @DeleteMapping
    public Response deleteMetaTemplate(@RequestParam String ids) {
        this.metaTemplateService.deleteMetaTemplate(ids);
        return Response.ok();
    }

    @ApiOperation(value="06-\u83b7\u53d6\u6a21\u677f\u5b57\u6bb5\u6811\u72b6\u7ed3\u6784")
    @GetMapping(value={"/field/tree"})
    public Response editMetaTemplateField(Long templateId) {
        return Response.ok((Object)this.metaTemplateService.getMetaMetaTemplateFieldTree(templateId));
    }

    @ApiOperation(value="07-\u4fdd\u5b58\u6a21\u677f\u5b57\u6bb5\u5206\u7ec4")
    @PostMapping(value={"/field/group"})
    public Response<Long> addMetaTemplateField(@RequestBody MetaTemplateFieldGroupEditDTO group) {
        return Response.ok((Object)this.metaTemplateService.saveMetaTemplateFieldGroup(group));
    }

    @ApiOperation(value="08-\u6dfb\u52a0\u6a21\u677f\u5b57\u6bb5")
    @PostMapping(value={"/field/add"})
    public Response<Long> addMetaTemplateField(@RequestBody MetaTemplateFieldDTO field) {
        return Response.ok((Object)this.metaTemplateService.addMetaTemplateField(field));
    }

    @ApiOperation(value="09-\u6279\u91cf\u6dfb\u52a0\u6a21\u677f\u5b57\u6bb5")
    @PostMapping(value={"/field/batch"})
    public Response batchAddMetaTemplateField(@RequestBody List<MetaTemplateFieldDTO> fields) {
        this.metaTemplateService.batchAddMetaTemplateField(fields);
        return Response.ok();
    }

    @ApiOperation(value="10-\u4fee\u6539\u6a21\u677f\u5b57\u6bb5")
    @PostMapping(value={"/field/edit"})
    public Response editMetaTemplateField(@RequestBody MetaTemplateFieldDTO field) {
        this.metaTemplateService.editMetaTemplateField(field);
        return Response.ok();
    }

    @ApiOperation(value="11-\u5220\u9664\u6a21\u677f\u5b57\u6bb5")
    @PostMapping(value={"/field/del"})
    public Response deleteMetaTemplateField(String id) {
        this.metaTemplateService.deleteMetaTemplateField(id);
        return Response.ok();
    }

    @ApiOperation(value="12-\u8c03\u6574\u6a21\u677f\u5b57\u6bb5\u987a\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5b57\u6bb5id", required=true), @ApiImplicitParam(name="groupId", value="\u79fb\u52a8\u540e\u7684\u5206\u7ec4id", required=false), @ApiImplicitParam(name="frontId", value="\u540c\u7ea7\u7684\u524d\u9762\u7684id", required=false)})
    @PostMapping(value={"/field/move"})
    public Response moveMetaTemplateField(Long id, @RequestParam(required=false) Long groupId, @RequestParam(required=false) Long frontId) {
        this.metaTemplateService.moveMetaTemplateField(id, groupId, frontId);
        return Response.ok();
    }

    @ApiOperation(value="13-\u4ece\u6587\u4ef6\u8bfb\u53d6\u5143\u6570\u636e\u6a21\u677f(xls\u3001xlsx)")
    @GetMapping(value={"/read"})
    public Response<List<MetaDataValueDTO>> readMetaData(@RequestParam String path) {
        return Response.ok((Object)this.metaTemplateService.readMetaData(path));
    }
}

