--新的底图配置
CREATE TABLE tbcm_baselayermap (
   f_id varchar(32) NOT NULL PRIMARY KEY,
   f_pid varchar(32) NOT NULL,
   f_name varchar(200) NOT NULL,
   f_type int4 NOT NULL,
   f_code varchar(32),
   f_enable int4 DEFAULT 1,
   f_isdefault int4,
   f_order int4 DEFAULT 0,
   f_schemeid varchar(32),
   f_serviceurl varchar(500),
   f_minlevel int4,
   f_maxlevel int4,
   f_visible2d int4,
   f_visible3d int4,
   f_note int4,
   f_subdomain varchar(500),
   f_servicevague int4,
   f_openavoidance int4,
   f_annotationpixelrange int4,
   f_picture bytea,
   f_extension text
);
create unique index tbcm_baselayermap_f_pid_f_name_uindex
    on tbcm_baselayermap (f_pid, f_name);

COMMENT ON TABLE tbcm_baselayermap IS '底图配置';

-- Column comments

COMMENT ON COLUMN tbcm_baselayermap.f_id IS '标识';
COMMENT ON COLUMN tbcm_baselayermap.f_pid IS '父标识';
COMMENT ON COLUMN tbcm_baselayermap.f_name IS '名称';
COMMENT ON COLUMN tbcm_baselayermap.f_type IS '类型';
COMMENT ON COLUMN tbcm_baselayermap.f_code IS '编码';
COMMENT ON COLUMN tbcm_baselayermap.f_enable IS '是否可用';
COMMENT ON COLUMN tbcm_baselayermap.f_isdefault IS '是否为默认';
COMMENT ON COLUMN tbcm_baselayermap.f_order IS '顺序';
COMMENT ON COLUMN tbcm_baselayermap.f_schemeid IS '底图方案id';
COMMENT ON COLUMN tbcm_baselayermap.f_serviceurl IS '服务地址';
COMMENT ON COLUMN tbcm_baselayermap.f_minlevel IS '最小显示级别';
COMMENT ON COLUMN tbcm_baselayermap.f_maxlevel IS '最大显示级别';
COMMENT ON COLUMN tbcm_baselayermap.f_visible2d IS '二维可见';
COMMENT ON COLUMN tbcm_baselayermap.f_visible3d IS '三维可见';
COMMENT ON COLUMN tbcm_baselayermap.f_note IS '是否注记';
COMMENT ON COLUMN tbcm_baselayermap.f_subdomain IS '子域名';
COMMENT ON COLUMN tbcm_baselayermap.f_servicevague IS '模糊处理';
COMMENT ON COLUMN tbcm_baselayermap.f_openavoidance IS '开启避让';
COMMENT ON COLUMN tbcm_baselayermap.f_annotationpixelrange IS '避让因子';
COMMENT ON COLUMN tbcm_baselayermap.f_picture IS '图片';
COMMENT ON COLUMN tbcm_baselayermap.f_extension IS '扩展信息';