/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.catalog;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.catalog.dto.view.ViewSchemaCreateDTO;
import com.geoway.adf.dms.catalog.dto.view.ViewSchemaDTO;
import com.geoway.adf.dms.catalog.service.ViewSchemaService;
import com.geoway.adf.dms.common.web.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/catalog/browse"})
@Api(tags={"03.04-\u5e94\u7528\u76ee\u5f55-\u663e\u793a\u65b9\u6848(\u4e66\u7b7e)"})
public class MapViewSchemaController {
    @Resource
    private ViewSchemaService viewSchemaService;

    @ApiOperation(value="01-\u83b7\u53d6\u663e\u793a\u65b9\u6848\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd"), @ApiImplicitParam(name="containsExtType", defaultValue="false", value="\u662f\u5426\u5305\u542b\u6269\u5c55\u7c7b\u578b"), @ApiImplicitParam(name="extType", value="\u6269\u5c55\u7c7b\u578b"), @ApiImplicitParam(name="withPicture", value="\u662f\u5426\u5305\u542b\u56fe\u7247")})
    @GetMapping(value={"/view/schemas"})
    public Response<List<ViewSchemaDTO>> getViewSchemaList(@RequestParam(required=false) String keyword, @RequestParam(required=false, defaultValue="false") Boolean withPicture, @RequestParam(required=false, defaultValue="false") Boolean containsExtType, @RequestParam(required=false) String extType) {
        return Response.ok((Object)this.viewSchemaService.listViewSchema(keyword, withPicture, containsExtType, extType));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u663e\u793a\u65b9\u6848\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="schemaId", value="\u663e\u793a\u65b9\u6848\u6807\u8bc6", required=true)})
    @GetMapping(value={"/view/schema"})
    public Response<ViewSchemaDTO> getViewSchemaDetail(@RequestParam Long schemaId) {
        return Response.ok((Object)this.viewSchemaService.getViewSchemaDetail(schemaId));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u663e\u793a\u65b9\u6848\u5206\u7ec4")
    @GetMapping(value={"/view/schema/groups"})
    public Response<List<String>> getViewSchemaGroupList() {
        return Response.ok((Object)this.viewSchemaService.groupList());
    }

    @ApiOperation(value="04-\u65b0\u589e\u663e\u793a\u65b9\u6848")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", value="\u540d\u79f0"), @ApiImplicitParam(name="catalogModel", value="\u65b9\u6848\u7c7b\u578b(1-\u4e00\u822c\u6a21\u5f0f\uff0c2-\u6f14\u793a\u6a21\u5f0f)", required=true), @ApiImplicitParam(name="appCatalogId", value="\u5e94\u7528\u76ee\u5f55\u6807\u8bc6", required=true), @ApiImplicitParam(name="cardId", value="\u6f14\u793a\u6a21\u5f0f\u7684\u4e00\u7ea7\u76ee\u5f55ID"), @ApiImplicitParam(name="groupName", value="\u5206\u7ec4\u540d\u79f0"), @ApiImplicitParam(name="layerInfo", value="\u56fe\u5c42\u4fe1\u606f"), @ApiImplicitParam(name="location", value="\u4f4d\u7f6e\u4fe1\u606f"), @ApiImplicitParam(name="chartUrl", value="\u7edf\u8ba1\u9762\u677fUrl"), @ApiImplicitParam(name="desc", value="\u63cf\u8ff0\u4fe1\u606f"), @ApiImplicitParam(name="extType", value="\u6269\u5c55\u7c7b\u578b"), @ApiImplicitParam(name="hotkey", value="\u5feb\u6377\u952e"), @ApiImplicitParam(name="picture", value="\u4e0a\u4f20\u56fe\u7247", dataTypeClass=MultipartFile.class)})
    @UploadFileCheck(supportedSuffixes={".png", ".jpg", ".svg"})
    @PostMapping(value={"/view/schema"})
    public Response addViewSchema(@RequestParam String name, @RequestParam Short catalogModel, @RequestParam String appCatalogId, @RequestParam(required=false) String groupName, @RequestParam(required=false) String cardId, @RequestParam(required=false) String layerInfo, @RequestParam(required=false) String location, @RequestParam(required=false) String chartUrl, @RequestParam(required=false) String desc, @RequestParam(required=false) String extType, @RequestParam(required=false) String hotkey, @RequestPart(required=false) MultipartFile picture) {
        ViewSchemaCreateDTO createDTO = new ViewSchemaCreateDTO();
        createDTO.setName(name);
        createDTO.setGroupName(groupName);
        createDTO.setCatalogModel(catalogModel);
        createDTO.setAppCatalogId(appCatalogId);
        createDTO.setCardId(cardId);
        createDTO.setLayerInfo(layerInfo);
        createDTO.setLocation(location);
        createDTO.setChartUrl(chartUrl);
        createDTO.setPicture(picture);
        createDTO.setDesc(desc);
        createDTO.setExtType(extType);
        createDTO.setHotkey(hotkey);
        this.viewSchemaService.addOrUpdateViewSchema(createDTO, Boolean.valueOf(false));
        return Response.ok();
    }

    @ApiOperation(value="05-\u66f4\u65b0\u663e\u793a\u65b9\u6848")
    @ApiImplicitParams(value={@ApiImplicitParam(name="schemaId", value="\u65b9\u6848id"), @ApiImplicitParam(name="name", value="\u540d\u79f0"), @ApiImplicitParam(name="catalogModel", value="\u65b9\u6848\u7c7b\u578b(1-\u4e00\u822c\u6a21\u5f0f\uff0c2-\u6f14\u793a\u6a21\u5f0f)", required=true), @ApiImplicitParam(name="appCatalogId", value="\u5e94\u7528\u76ee\u5f55\u6807\u8bc6", required=true), @ApiImplicitParam(name="cardId", value="\u6f14\u793a\u6a21\u5f0f\u7684\u4e00\u7ea7\u76ee\u5f55ID"), @ApiImplicitParam(name="groupName", value="\u5206\u7ec4\u540d\u79f0"), @ApiImplicitParam(name="layerInfo", value="\u56fe\u5c42\u4fe1\u606f"), @ApiImplicitParam(name="location", value="\u4f4d\u7f6e\u4fe1\u606f"), @ApiImplicitParam(name="chartUrl", value="\u7edf\u8ba1\u9762\u677fUrl"), @ApiImplicitParam(name="desc", value="\u63cf\u8ff0\u4fe1\u606f"), @ApiImplicitParam(name="extType", value="\u6269\u5c55\u7c7b\u578b"), @ApiImplicitParam(name="hotkey", value="\u5feb\u6377\u952e"), @ApiImplicitParam(name="picture", value="\u4e0a\u4f20\u56fe\u7247", dataTypeClass=MultipartFile.class)})
    @UploadFileCheck(supportedSuffixes={".png", ".jpg", ".svg"})
    @PutMapping(value={"/view/schema"})
    public Response updateViewSchema(@RequestParam Long schemaId, @RequestParam String name, @RequestParam Short catalogModel, @RequestParam String appCatalogId, @RequestParam(required=false) String cardId, @RequestParam(required=false) String groupName, @RequestParam(required=false) String layerInfo, @RequestParam(required=false) String location, @RequestParam(required=false) String chartUrl, @RequestParam(required=false) String desc, @RequestParam(required=false) String extType, @RequestParam(required=false) String hotkey, @RequestPart(required=false) MultipartFile picture, @RequestParam(required=false, defaultValue="false") Boolean deletePicture) {
        ViewSchemaCreateDTO schemaDTO = new ViewSchemaCreateDTO();
        schemaDTO.setSchemaId(schemaId);
        schemaDTO.setName(name);
        schemaDTO.setGroupName(groupName);
        schemaDTO.setCatalogModel(catalogModel);
        schemaDTO.setAppCatalogId(appCatalogId);
        schemaDTO.setCardId(cardId);
        schemaDTO.setLayerInfo(layerInfo);
        schemaDTO.setLocation(location);
        schemaDTO.setChartUrl(chartUrl);
        schemaDTO.setPicture(picture);
        schemaDTO.setDesc(desc);
        schemaDTO.setExtType(extType);
        schemaDTO.setHotkey(hotkey);
        this.viewSchemaService.addOrUpdateViewSchema(schemaDTO, deletePicture);
        return Response.ok();
    }

    @ApiOperation(value="06-\u5220\u9664\u663e\u793a\u65b9\u6848")
    @DeleteMapping(value={"/view/schema/{id}"})
    public Response deleteViewSchema(@PathVariable Long id) {
        this.viewSchemaService.deleteViewSchema(id);
        return Response.ok();
    }
}

