/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.dataset.DatasetDTO;
import com.geoway.adf.dms.datasource.entity.DsDatasetRelation;
import com.geoway.adf.dms.datasource.service.DatasetRelationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/relation"})
@Api(tags={"01.10-\u6570\u636e\u96c6\u5173\u8054\u5173\u7cfb"})
public class DatasetRelationController {
    @Resource
    private DatasetRelationService datasetRelationService;

    @ApiOperation(value="01-\u83b7\u53d6\u6570\u636e\u96c6\u5173\u8054\u5173\u7cfb")
    @GetMapping(value={"datasetrel"})
    public Response<List<DsDatasetRelation>> getDatasetRelations(String datasetId, @RequestParam(required=false) String relation) {
        if (relation == null) {
            return Response.ok((Object)this.datasetRelationService.getDatasetRelations(datasetId));
        }
        return Response.ok((Object)this.datasetRelationService.getDatasetRelations(datasetId, relation));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5173\u8054\u6570\u636e\u96c6\u8be6\u60c5")
    @GetMapping(value={"datasetrel/detail"})
    public Response<Map<String, DatasetDTO>> getDatasetDetail(String datasetId) {
        Map relationMap = this.datasetRelationService.getRelateDatasetDetail(datasetId);
        return Response.ok((Object)relationMap);
    }

    @ApiOperation(value="03-\u65b0\u589e\u6570\u636e\u96c6\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"add"})
    public Response getDatasetRelations(@RequestBody DsDatasetRelation datasetRelation) {
        return Response.ok((Object)this.datasetRelationService.addRelation(datasetRelation));
    }

    @ApiOperation(value="04-\u6279\u91cf\u65b0\u589e\u6570\u636e\u96c6\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"batchadd"})
    public Response batchAddRelation(@RequestBody List<DsDatasetRelation> datasetRelations) {
        return Response.ok((Object)this.datasetRelationService.batchAddRelation(datasetRelations));
    }

    @ApiOperation(value="05-\u5220\u9664\u6570\u636e\u96c6\u5173\u8054\u5173\u7cfb")
    @PostMapping(value={"datasetdel"})
    public Response deleteDatasetRelation(String datasetId) {
        return Response.ok((Object)this.datasetRelationService.deleteDatasetRelation(datasetId));
    }
}

