/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.catalog;

import com.geoway.adf.dms.catalog.dto.app.AppCatalogDTO;
import com.geoway.adf.dms.catalog.dto.app.AppCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.AppCatalogNodeService;
import com.geoway.adf.dms.catalog.service.AppCatalogService;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.renderindex.DatasetRenderDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/appcatalog"})
@Api(tags={"03-\u5e94\u7528\u76ee\u5f55"})
public class AppCatalogController {
    @Resource
    private AppCatalogService appCatalogService;
    @Resource
    private AppCatalogNodeService appCatalogNodeService;

    @ApiOperation(value="01-\u83b7\u53d6\u5e94\u7528\u76ee\u5f55\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57"), @ApiImplicitParam(name="needResCatalog", value="\u662f\u5426\u83b7\u53d6\u8d44\u6e90\u76ee\u5f55", example="false")})
    @GetMapping(value={"/list"})
    public Response<List<AppCatalogDTO>> getAppCatalogList(@RequestParam(required=false) String keyword, @RequestParam(required=false, defaultValue="false") Boolean needResCatalog) {
        return Response.ok((Object)this.appCatalogService.getAppCatalogList(keyword, needResCatalog));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5e94\u7528\u76ee\u5f55\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public Response<AppCatalogDTO> getCatalogDetail(@RequestParam(required=false) String id, @RequestParam(required=false) String name) {
        if (StringUtil.isEmptyOrWhiteSpace((String)id) && StringUtil.isEmptyOrWhiteSpace((String)name)) {
            throw new IllegalArgumentException("\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        if (!StringUtil.isEmptyOrWhiteSpace((String)id)) {
            return Response.ok((Object)this.appCatalogService.getAppCatalogDetail(id));
        }
        return Response.ok((Object)this.appCatalogService.getAppCatalog(name));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u5e94\u7528\u76ee\u5f55\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appCatalogId", value="\u5e94\u7528\u76ee\u5f55\u6807\u8bc6", required=true), @ApiImplicitParam(name="rootId", value="\u6839\u8282\u70b9\u6807\u8bc6"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57"), @ApiImplicitParam(name="datasetTypes", value="\u6570\u636e\u96c6\u7c7b\u578b\uff08\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00\uff09"), @ApiImplicitParam(name="onlyLayerNode", value="\u4ec5\u67e5\u627e\u56fe\u5c42\u8282\u70b9", defaultValue="false"), @ApiImplicitParam(name="showCompositeChild", value="\u6811\u7ed3\u6784\u4e0a\u662f\u5426\u6e32\u67d3\u7ec4\u5408\u8282\u70b9\u7684\u5b50\u8282\u70b9", defaultValue="false"), @ApiImplicitParam(name="withLevelOnePic", value="\u662f\u5426\u83b7\u53d6\u4e00\u7ea7\u76ee\u5f55\u8282\u70b9\u7684\u56fe\u7247\u914d\u7f6e", defaultValue="false")})
    @GetMapping(value={"/tree"})
    public Response<AppCatalogNodeDTO> getAppCatalogList(@RequestParam String appCatalogId, @RequestParam(required=false) String rootId, @RequestParam(required=false) String keyword, @RequestParam(required=false) String datasetTypes, @RequestParam(required=false, defaultValue="false") Boolean onlyLayerNode, @RequestParam(required=false, defaultValue="false") Boolean showCompositeChild, @RequestParam(required=false, defaultValue="false") Boolean withLevelOnePic) {
        return Response.ok((Object)this.appCatalogNodeService.getCatalogTree(appCatalogId, rootId, keyword, datasetTypes, onlyLayerNode, showCompositeChild, withLevelOnePic));
    }

    @ApiOperation(value="04-\u83b7\u53d6\u4e00\u7ea7\u5e94\u7528\u76ee\u5f55\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appCatalogId", value="\u5e94\u7528\u76ee\u5f55\u6807\u8bc6", required=true), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57")})
    @GetMapping(value={"/tree/lv1"})
    public Response<AppCatalogNodeDTO> getAppCatalogLevelOne(@RequestParam String appCatalogId, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.appCatalogNodeService.getCatalogTreeLevelOne(appCatalogId, keyword));
    }

    @ApiOperation(value="05-\u83b7\u53d6\u76ee\u5f55\u8282\u70b9\u56fe\u7247")
    @GetMapping(value={"/folder/image/{id}"})
    public Response<String> getFolderImage(@PathVariable String id) {
        return Response.ok((Object)this.appCatalogNodeService.getFolderImg(id));
    }

    @ApiOperation(value="06-\u83b7\u53d6\u5e94\u7528\u76ee\u5f55\u8282\u70b9\u8be6\u60c5")
    @GetMapping(value={"/node/detail"})
    public Response<AppCatalogNodeDTO> getNodeDetail(@RequestParam String nodeId) {
        return Response.ok((Object)this.appCatalogNodeService.getNodeDetail(nodeId));
    }

    @ApiOperation(value="07-\u83b7\u53d6\u5e94\u7528\u76ee\u5f55\u8282\u70b9\u6e32\u67d3\u7d22\u5f15")
    @GetMapping(value={"/node/render"})
    public Response<DatasetRenderDTO> getNodeRender(@RequestParam String nodeId) {
        return Response.ok((Object)this.appCatalogNodeService.getNodeRender(nodeId));
    }

    @ApiOperation(value="08-\u83b7\u53d6\u6240\u6709\u5e94\u7528\u76ee\u5f55\u6811")
    @GetMapping(value={"/tree/all"})
    public Response<List<AppCatalogNodeDTO>> getAppCatalogTreeList(@RequestParam(required=false, defaultValue="false") Boolean needResCatalog) {
        return Response.ok((Object)this.appCatalogNodeService.getCatalogTreeList(needResCatalog.booleanValue()));
    }

    @ApiOperation(value="09-\u83b7\u53d6\u56fe\u5c42\u8282\u70b9\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appCatalogId", value="\u5e94\u7528\u76ee\u5f55\u6807\u8bc6", required=true), @ApiImplicitParam(name="pNodeId", value="\u7236\u8282\u70b9id"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57")})
    @GetMapping(value={"/layers"})
    public Response<List<AppCatalogNodeDTO>> getLayerNodeList(@RequestParam String appCatalogId, @RequestParam(required=false) String pNodeId, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.appCatalogNodeService.getLayerNodeList(appCatalogId, pNodeId, keyword));
    }

    @ApiOperation(value="10-\u8bbe\u7f6e\u9ed8\u8ba4\u5e94\u7528\u76ee\u5f55")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u76ee\u5f55\u6807\u8bc6", required=true), @ApiImplicitParam(name="isDefault", value="\u662f\u5426\u4e3a\u9ed8\u8ba4", required=true, dataType="Boolean")})
    @PostMapping(value={"/default"})
    public Response setDefaultCatalog(@RequestParam String id, @RequestParam Boolean isDefault) {
        this.appCatalogService.setDefaultCatalog(isDefault, id);
        return Response.ok();
    }
}

