/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.catalog;

import com.geoway.adf.dms.catalog.dto.MoveCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.VectorRenderStyleDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.create.ResCatalogDatasetCreateDTO;
import com.geoway.adf.dms.catalog.dto.res.create.ResCatalogFolderCreateDTO;
import com.geoway.adf.dms.catalog.dto.res.edit.ResCatalogFolderEditDTO;
import com.geoway.adf.dms.catalog.dto.res.edit.ResDatasetNodeEditDTO;
import com.geoway.adf.dms.catalog.dto.res.edit.ResDatasetNodeMetaDataEditDTO;
import com.geoway.adf.dms.catalog.dto.res.inventory.ResDataInventoryConfigDTO;
import com.geoway.adf.dms.catalog.dto.res.inventory.ResDataInventoryExportDTO;
import com.geoway.adf.dms.catalog.service.ResCatalogNodeService;
import com.geoway.adf.dms.catalog.service.ResDataInventoryService;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.gis.basic.PageList;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rescatalog"})
@Api(tags={"02-\u8d44\u6e90\u76ee\u5f55"})
public class ResCatalogNodeController {
    @Resource
    private ResCatalogNodeService resCatalogNodeService;
    @Resource
    private ResDataInventoryService resDataInventoryService;

    @ApiOperation(value="01-\u83b7\u53d6\u8d44\u6e90\u76ee\u5f55\u6811")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rootId", value="\u6839\u8282\u70b9"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57"), @ApiImplicitParam(name="datasetTypes", value="\u6570\u636e\u96c6\u7c7b\u578b\uff08\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00\uff09"), @ApiImplicitParam(name="onlyFolder", value="\u4ec5\u76ee\u5f55\u8282\u70b9", defaultValue="false"), @ApiImplicitParam(name="searchMetaData", value="\u662f\u5426\u641c\u7d22\u5143\u6570\u636e\u6807\u7b7e", defaultValue="false")})
    @GetMapping(value={"/tree"})
    public Response<ResCatalogNodeDTO> getCatalogTree(@RequestParam(required=false) String rootId, @RequestParam(required=false) String keyword, @RequestParam(required=false) String datasetTypes, @RequestParam(required=false, defaultValue="false") Boolean onlyFolder, @RequestParam(required=false, defaultValue="false") Boolean searchMetaData) {
        return Response.ok((Object)this.resCatalogNodeService.getCatalogTree(rootId, keyword, datasetTypes, onlyFolder, searchMetaData));
    }

    @ApiOperation(value="02-\u8d44\u6e90\u76ee\u5f55\u6570\u636e\u96c6\u8282\u70b9\u5217\u8868\u641c\u7d22")
    @ApiImplicitParams(value={@ApiImplicitParam(name="rootId", value="\u6839\u8282\u70b9"), @ApiImplicitParam(name="page", value="\u9875\u7801", defaultValue="0"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u884c\u6570", defaultValue="9"), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57"), @ApiImplicitParam(name="datasetTypes", value="\u6570\u636e\u96c6\u7c7b\u578b\uff08\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00\uff09"), @ApiImplicitParam(name="searchMetaData", value="\u662f\u5426\u641c\u7d22\u5143\u6570\u636e\u6807\u7b7e", defaultValue="true")})
    @GetMapping(value={"/list"})
    public Response<PageList<ResCatalogNodeDTO>> searchCatalogNode(@RequestParam(required=false) String rootId, @RequestParam(required=false, defaultValue="0") Integer page, @RequestParam(required=false, defaultValue="9") Integer rows, @RequestParam(required=false) String keyword, @RequestParam(required=false) String datasetTypes, @RequestParam(required=false, defaultValue="true") Boolean searchMetaData) {
        return Response.ok((Object)this.resCatalogNodeService.searchCatalogDataNode(rootId, page, rows, keyword, datasetTypes, searchMetaData));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u8282\u70b9\u8be6\u60c5")
    @GetMapping(value={"/node/detail"})
    public Response<ResCatalogNodeDTO> getNodeDetail(@RequestParam String nodeId) {
        return Response.ok((Object)this.resCatalogNodeService.getNodeDetail(nodeId));
    }

    @ApiOperation(value="04-\u6279\u91cf\u83b7\u53d6\u8282\u70b9\u8be6\u60c5")
    @GetMapping(value={"/node/details"})
    public Response<Map<String, ResCatalogNodeDTO>> getNodeDetails(@RequestParam String nodeIds) {
        return Response.ok((Object)this.resCatalogNodeService.getNodeDetails(Arrays.asList(nodeIds.split(","))));
    }

    @ApiOperation(value="05-\u6dfb\u52a0\u5206\u7c7b\u8282\u70b9")
    @PostMapping(value={"/folder"})
    public Response<String> addFolderNode(@RequestBody ResCatalogFolderCreateDTO folderCreateDTO) {
        return Response.ok((Object)this.resCatalogNodeService.addFolderNode(folderCreateDTO));
    }

    @ApiOperation(value="06-\u7f16\u8f91\u5206\u7c7b\u8282\u70b9")
    @PutMapping(value={"/folder"})
    public Response editFolderNode(@RequestBody ResCatalogFolderEditDTO folderEditDTO) {
        this.resCatalogNodeService.editFolderNode(folderEditDTO);
        return Response.ok();
    }

    @ApiOperation(value="07-\u6dfb\u52a0\u6570\u636e\u96c6\u8282\u70b9")
    @PostMapping(value={"/dataset"})
    public Response<List<String>> addDatasetNode(@RequestBody ResCatalogDatasetCreateDTO datasetCreateDTO) {
        return Response.ok((Object)this.resCatalogNodeService.addDatasetNode(datasetCreateDTO));
    }

    @ApiOperation(value="08-\u8c03\u6574\u8282\u70b9\u987a\u5e8f")
    @PutMapping(value={"/move/node"})
    public Response deleteNodes(@RequestBody MoveCatalogNodeDTO moveCatalogNodeDTO) {
        this.resCatalogNodeService.moveCatalogNode(moveCatalogNodeDTO);
        return Response.ok();
    }

    @ApiOperation(value="09-\u7f16\u8f91\u6570\u636e\u96c6\u8282\u70b9\u901a\u7528\u5c5e\u6027")
    @PutMapping(value={"/dataset/property"})
    public Response editDatasetNode(@RequestBody ResDatasetNodeEditDTO editDTO) {
        this.resCatalogNodeService.editGeoDatasetNode(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="10-\u6279\u91cf\u5220\u9664\u8282\u70b9")
    @DeleteMapping(value={"/nodes"})
    @ApiImplicitParam(name="nodeIds", value="\u76ee\u5f55\u8282\u70b9ID\uff0c\u591a\u4e2a\u9017\u53f7\u5206\u9694")
    public Response deleteNodes(@RequestParam String nodeIds) {
        this.resCatalogNodeService.deleteCatalogNode(nodeIds);
        return Response.ok();
    }

    @ApiOperation(value="11-\u7f16\u8f91\u670d\u52a1\u8282\u70b9\u5c5e\u6027")
    @PutMapping(value={"/service/property"})
    public Response editServiceNode(@RequestBody ResDatasetNodeEditDTO editDTO) {
        this.resCatalogNodeService.editGeoDatasetNode(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="12-\u83b7\u53d6\u8282\u70b9\u77e2\u91cf\u6e32\u67d3\u7d22\u5f15\u6837\u5f0f")
    @GetMapping(value={"/vector/style"})
    public Response<VectorRenderStyleDTO> getVectorRenderStyle(@RequestParam String nodeId) {
        return Response.ok((Object)this.resCatalogNodeService.getVectorRenderStyle(nodeId));
    }

    @ApiOperation(value="13-\u4fee\u6539\u8282\u70b9\u77e2\u91cf\u6e32\u67d3\u7d22\u5f15\u6837\u5f0f")
    @PutMapping(value={"/vector/style"})
    public Response chooseVectorRenderStyle(@RequestParam String nodeId, @RequestParam String styleId) {
        this.resCatalogNodeService.chooseVectorRenderStyle(nodeId, styleId);
        return Response.ok();
    }

    @ApiOperation(value="14-\u83b7\u53d6\u8282\u70b9\u529f\u80fd\u5e94\u7528\u914d\u7f6e")
    @GetMapping(value={"/node/funcConfig"})
    public Response<String> getCatalogNodeFunctionConfig(@RequestParam String nodeId) {
        return Response.ok((Object)this.resCatalogNodeService.getCatalogNodeFunctionConfig(nodeId));
    }

    @ApiOperation(value="15-\u4fee\u6539\u8282\u70b9\u529f\u80fd\u5e94\u7528\u914d\u7f6e")
    @PostMapping(value={"/node/funcConfig"})
    public Response editCatalogNodeFunctionConfig(@RequestParam String nodeId, @RequestParam String funcConfig) {
        this.resCatalogNodeService.editCatalogNodeFunctionConfig(nodeId, funcConfig);
        return Response.ok();
    }

    @ApiOperation(value="16-\u6279\u91cf\u7f16\u8f91\u5143\u6570\u636e")
    @PostMapping(value={"/dataset/metadata"})
    public Response editDatasetNodeMetaData(@RequestBody ResDatasetNodeMetaDataEditDTO editDTO) {
        this.resCatalogNodeService.editDatasetNodeMetaData(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="17-\u83b7\u53d6\u8d44\u6e90\u6e05\u5355\u914d\u7f6e")
    @GetMapping(value={"/inventory/saveConfig"})
    public Response<ResDataInventoryConfigDTO> getResMetaInventoryConfig() {
        return Response.ok((Object)this.resDataInventoryService.getResMetaInventoryConfig());
    }

    @ApiOperation(value="18-\u4fdd\u5b58\u8d44\u6e90\u6e05\u5355\u914d\u7f6e")
    @PostMapping(value={"/inventory/config"})
    public Response<?> getNodeDetails(@RequestBody ResDataInventoryConfigDTO resMetaInventoryConfig) {
        this.resDataInventoryService.saveResMetaInventoryConfig(resMetaInventoryConfig);
        return Response.ok();
    }

    @ApiOperation(value="19-\u8ba1\u7b97\u8d44\u6e90\u6570\u636e\u91cf")
    @PostMapping(value={"/inventory/calculate"})
    public Response<?> calculateResCatalogStorage(@RequestParam(required=false, defaultValue="true") Boolean forceRecalculate) {
        this.resDataInventoryService.calculateResCatalogStorage(forceRecalculate);
        return Response.ok();
    }

    @ApiOperation(value="20-\u8d44\u6e90\u6e05\u5355\u5bfc\u51fa")
    @GetMapping(value={"/listExport"})
    public void getNodeDetails(ResDataInventoryExportDTO exportDTO, HttpServletRequest request, HttpServletResponse response) {
        this.resDataInventoryService.exportResCatalogMetaList(exportDTO, request, response);
    }
}

