/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.api.action.check.UploadFileCheck;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.filepackage.create.FileModelCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.FileModelEditDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelCompactPackageNodeCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelFileNodeCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelFileNodeEditDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelFolderNodeCreateDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelFolderNodeEditDTO;
import com.geoway.adf.dms.config.dto.filepackage.create.ModelNodeCopyDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.FileModelDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.FilePropertyDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ModelNodeDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.NameRuleDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.NameRuleJsCheckDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.RealFileModelNodeDTO;
import com.geoway.adf.dms.config.dto.filepackage.model.ScanResultDTO;
import com.geoway.adf.dms.config.service.FileModelService;
import com.geoway.adf.dms.datasource.dto.SimpleDatasetDTO;
import com.geoway.adf.dms.datasource.service.DatumDatabaseService;
import com.geoway.adf.dms.datasource.service.FileStorageService;
import com.geoway.adf.gis.fs.IFileStorage;
import com.geoway.adf.gis.fs.IFileset;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/config/file/model"})
@Api(tags={"04.12-\u914d\u7f6e\u7ba1\u7406-\u6587\u4ef6\u7ed3\u6784\u5efa\u6a21"})
public class FileModelController {
    @Resource
    private FileModelService fileModelService;
    @Resource
    private DatumDatabaseService datumDatabaseService;
    @Resource
    private FileStorageService fileStorageService;

    @ApiOperation(value="01-\u83b7\u53d6\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="keyword", value="\u5173\u952e\u5b57")})
    @GetMapping(value={"/list"})
    public Response<List<FileModelDTO>> list(@RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.fileModelService.list(keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u8be6\u60c5")
    @GetMapping(value={"/detail"})
    public Response<FileModelDTO> getFileModelDetail(@RequestParam Long modelId) {
        return Response.ok((Object)this.fileModelService.getFileModelDetail(modelId));
    }

    @ApiOperation(value="03-\u83b7\u53d6\u6a21\u578b\u8282\u70b9\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6587\u4ef6\u7ed3\u6784\u6a21\u578bID", dataType="long", required=true), @ApiImplicitParam(name="nodePath", value="\u8282\u70b9\u8def\u5f84(\u552f\u4e00\u503c)", required=true)})
    @GetMapping(value={"/node"})
    public Response<ModelNodeDTO> getModelNodeDetail(@RequestParam Long modelId, @RequestParam String nodePath) {
        return Response.ok((Object)this.fileModelService.getModelNodeDetail(modelId, nodePath));
    }

    @ApiOperation(value="04-\u5220\u9664\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6587\u4ef6\u7ed3\u6784\u6a21\u578bID", dataType="long", required=true), @ApiImplicitParam(name="nodePath", value="\u8282\u70b9\u8def\u5f84(\u552f\u4e00\u503c)", required=true)})
    @DeleteMapping(value={"/node"})
    public Response deleteModelNode(@RequestParam Long modelId, @RequestParam String nodePath) {
        this.fileModelService.deleteModelNode(modelId, nodePath);
        return Response.ok();
    }

    @ApiOperation(value="05-\u5bfc\u5165\u6587\u4ef6\u7ed3\u6784\u6a21\u578b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="xml\u6587\u4ef6", required=true, dataTypeClass=MultipartFile.class), @ApiImplicitParam(name="name", value="\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u540d\u79f0", required=true)})
    @UploadFileCheck(supportedSuffixes={".xml"})
    @PostMapping(value={"/import"})
    public Response importXml(@RequestPart MultipartFile file, @RequestParam String name) {
        this.fileModelService.importXml(file, name);
        return Response.ok();
    }

    @ApiOperation(value="06-\u5bfc\u51fa\u6587\u4ef6\u7ed3\u6784\u6a21\u578b")
    @GetMapping(value={"/export"})
    public void exportXml(@RequestParam Long modelId) {
        this.fileModelService.exportXml(modelId);
    }

    @ApiOperation(value="07-\u65b0\u589e\u6587\u4ef6\u7ed3\u6784\u6a21\u578b")
    @PostMapping(value={""})
    public Response<Long> addFileModel(@RequestBody FileModelCreateDTO createDTO) {
        return Response.ok((Object)this.fileModelService.addFileModel(createDTO));
    }

    @ApiOperation(value="08-\u7f16\u8f91\u6587\u4ef6\u7ed3\u6784\u6a21\u578b")
    @PutMapping(value={""})
    public Response updateFileModel(@RequestBody FileModelEditDTO editDTO) {
        this.fileModelService.updateFileModel(editDTO);
        return Response.ok();
    }

    @ApiOperation(value="09-\u5220\u9664\u6587\u4ef6\u7ed3\u6784\u6a21\u578b")
    @DeleteMapping(value={""})
    public Response delete(@RequestParam Long modelId) {
        List datasetList = this.datumDatabaseService.getDatumDatasetByFileModel(modelId);
        if (datasetList.size() > 0) {
            List nameList = ListUtil.convertAll((List)datasetList, SimpleDatasetDTO::getAliasName);
            String nameString = String.join((CharSequence)",", nameList);
            return Response.error((String)("\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u88ab\u6587\u4ef6\u6570\u636e\u96c6\uff1a" + nameString + "\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01"));
        }
        this.fileModelService.delete(modelId);
        return Response.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="10-\u4ece\u5b9e\u9645\u76ee\u5f55\u521b\u5efa\u6587\u4ef6\u7ed3\u6784\u6a21\u578b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6587\u4ef6\u7ed3\u6784\u6a21\u578bID", dataType="long", required=true), @ApiImplicitParam(name="dirPath", value="\u6587\u4ef6\u5939\u8def\u5f84", required=true)})
    @GetMapping(value={"/build"})
    public Response<RealFileModelNodeDTO> creatFileModelFromFolder(@RequestParam Long modelId, @RequestParam String dirPath) {
        try (IFileStorage fileStorage = this.fileStorageService.openFileStorageByFilePath(dirPath);){
            IFileset fileset = fileStorage.getFile(dirPath);
            if (fileset == null) {
                throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\uff1a" + dirPath);
            }
            Response response = Response.ok((Object)this.fileModelService.creatFileModelFromFolder(modelId, fileset));
            return response;
        }
    }

    @ApiOperation(value="11-\u4fdd\u5b58\u4ece\u5b9e\u9645\u76ee\u5f55\u521b\u5efa\u7684\u6587\u4ef6\u7ed3\u6784\u6a21\u578b")
    @PostMapping(value={"/build/save"})
    public Response creatFileModelFromFolder(@RequestBody RealFileModelNodeDTO modelNodeDTO) {
        this.fileModelService.saveFileModel(modelNodeDTO);
        return Response.ok();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="12-\u6821\u9a8c\uff08\u626b\u63cf\u6587\u4ef6\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6587\u4ef6\u7ed3\u6784\u6a21\u578bID", dataType="long", required=true), @ApiImplicitParam(name="dirPath", value="\u6587\u4ef6\u5939\u8def\u5f84", required=true), @ApiImplicitParam(name="needScanInvalidData", value="\u662f\u5426\u9700\u8981\u626b\u63cf\u4e0d\u5408\u683c\u7684\u6570\u636e")})
    @GetMapping(value={"/scan"})
    public Response<ScanResultDTO> creatFileModelFromFolder(@RequestParam Long modelId, @RequestParam String dirPath, @RequestParam(required=false, defaultValue="true") Boolean needScanInvalidData) {
        try (IFileStorage fileStorage = this.fileStorageService.openFileStorageByFilePath(dirPath);){
            IFileset fileset = fileStorage.getFile(dirPath);
            if (fileset == null) {
                throw new RuntimeException("\u6570\u636e\u4e0d\u5b58\u5728\uff1a" + dirPath);
            }
            Response response = Response.ok((Object)this.fileModelService.scanFile(modelId, fileset, needScanInvalidData));
            return response;
        }
    }

    @ApiOperation(value="13-\u83b7\u53d6\u6a21\u578b\u8282\u70b9\u7279\u6b8a\u5c5e\u6027")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeTypes", value="\u6a21\u578b\u8282\u70b9\u7684\u7c7b\u578b\uff0c\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00", allowableValues="com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum")})
    @GetMapping(value={"/node/property"})
    public Response<List<FilePropertyDTO>> getFileProperty(@RequestParam String nodeTypes) {
        List typeList = new ArrayList();
        if (StringUtil.isNotEmpty((String)nodeTypes)) {
            typeList = StringUtil.split((String)nodeTypes, (String)",", Integer::valueOf);
        }
        return Response.ok((Object)this.fileModelService.getFileProperty(typeList));
    }

    @ApiOperation(value="14-\u83b7\u53d6\u6a21\u578b\u8282\u70b9\u7684\u547d\u540d\u89c4\u5219")
    @ApiImplicitParams(value={@ApiImplicitParam(name="nodeTypes", value="\u6a21\u578b\u8282\u70b9\u7684\u7c7b\u578b\uff0c\u591a\u4e2a\u7528\u9017\u53f7\u9694\u5f00", allowableValues="com.geoway.adf.dms.config.filemodel.constant.FileModelNodeTypeEnum")})
    @GetMapping(value={"/node/rule"})
    public Response<List<NameRuleDTO>> getNameRule(@RequestParam String nodeTypes) {
        List typeList = new ArrayList();
        if (StringUtil.isNotEmpty((String)nodeTypes)) {
            typeList = StringUtil.split((String)nodeTypes, (String)",", Integer::valueOf);
        }
        return Response.ok((Object)this.fileModelService.getNameRule(typeList));
    }

    @ApiOperation(value="15-\u65b0\u5efa\u6587\u4ef6\u8282\u70b9")
    @PostMapping(value={"/node/file"})
    public Response<String> addModelFileNode(@RequestBody ModelFileNodeCreateDTO createDTO) {
        return Response.ok((Object)this.fileModelService.addModelFileNode(createDTO));
    }

    @ApiOperation(value="16-\u7f16\u8f91\u6587\u4ef6\u8282\u70b9")
    @PutMapping(value={"/node/file"})
    public Response<String> addModelFileNode(@RequestBody ModelFileNodeEditDTO editDTO) {
        return Response.ok((Object)this.fileModelService.updateModelFileNode(editDTO));
    }

    @ApiOperation(value="17-\u65b0\u5efa\u6587\u4ef6\u5939\u8282\u70b9")
    @PostMapping(value={"/node/folder"})
    public Response<String> addModelFolderNode(@RequestBody ModelFolderNodeCreateDTO createDTO) {
        return Response.ok((Object)this.fileModelService.addModelFolderNode(createDTO));
    }

    @ApiOperation(value="18-\u7f16\u8f91\u6587\u4ef6\u5939\u8282\u70b9")
    @PutMapping(value={"/node/folder"})
    public Response<String> updateModelFolderNode(@RequestBody ModelFolderNodeEditDTO editDTO) {
        return Response.ok((Object)this.fileModelService.updateModelFolderNode(editDTO));
    }

    @ApiOperation(value="19-\u65b0\u5efa(\u7f16\u8f91)\u538b\u7f29\u5305\u8282\u70b9")
    @PostMapping(value={"/node/compact"})
    public Response<String> addModelCompactPackageNode(@RequestBody ModelCompactPackageNodeCreateDTO createDTO) {
        return Response.ok((Object)this.fileModelService.addOrUpdateModelCompactPackageNode(createDTO));
    }

    @ApiOperation(value="20-\u8bbe\u7f6e\u4e3b\u6570\u636e\u6807\u8bc6")
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u6587\u4ef6\u7ed3\u6784\u6a21\u578bID", dataType="long", required=true), @ApiImplicitParam(name="nodePath", value="\u8282\u70b9\u8def\u5f84(\u552f\u4e00\u503c)", required=true)})
    @PutMapping(value={"/key"})
    public Response setModelKey(@RequestParam Long modelId, @RequestParam String nodePath) {
        this.fileModelService.setModelKey(modelId, nodePath);
        return Response.ok();
    }

    @ApiOperation(value="21-\u9a8c\u8bc1javaScript\u811a\u672c")
    @PostMapping(value={"/check/rule"})
    public Response<String> checkJavaScriptRule(@RequestBody NameRuleJsCheckDTO checkDTO) {
        return Response.ok((Object)this.fileModelService.checkNameRuleJs(checkDTO));
    }

    @ApiOperation(value="22-\u590d\u5236\u6587\u4ef6\u7ed3\u6784\u6a21\u578b\u8282\u70b9")
    @PostMapping(value={"/node/copy"})
    public Response<String> copyModelNode(@RequestBody ModelNodeCopyDTO copyDTO) {
        return Response.ok((Object)this.fileModelService.copyModelNode(copyDTO));
    }
}

