/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.config;

import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.config.dto.frontscheme.FrontSchemeDTO;
import com.geoway.adf.dms.config.service.FrontSchemeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/front/scheme"})
@Api(tags={"04.02-\u901a\u7528\u65b9\u6848\u7ba1\u7406"})
public class FrontSchemeController {
    private static final Logger log = LoggerFactory.getLogger(FrontSchemeController.class);
    @Resource
    private FrontSchemeService frontSchemeService;

    @ApiOperation(value="01-\u83b7\u53d6\u65b9\u6848\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u65b9\u6848\u7c7b\u578b\uff08\u4e0d\u540c\u529f\u80fd\u4f7f\u7528\u4e0d\u540c\u7c7b\u578b\uff0c\u53ef\u81ea\u884c\u5b9a\u4e49\uff09", required=true), @ApiImplicitParam(name="keyword", value="\u5173\u952e\u8bcd")})
    @GetMapping(value={"/list"})
    public Response<List<FrontSchemeDTO>> list(@RequestParam String type, @RequestParam(required=false) String keyword) {
        return Response.ok((Object)this.frontSchemeService.list(type, keyword));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u65b9\u6848\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u65b9\u6848\u7c7b\u578b\uff08\u4e0d\u540c\u529f\u80fd\u4f7f\u7528\u4e0d\u540c\u7c7b\u578b\uff0c\u53ef\u81ea\u884c\u5b9a\u4e49\uff09", required=true), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=true)})
    @GetMapping(value={""})
    public Response<FrontSchemeDTO> getDetail(@RequestParam String type, @RequestParam String name) {
        FrontSchemeDTO frontScheme = this.frontSchemeService.getDetail(type, name);
        if (frontScheme == null) {
            log.error(type + " " + name + "\u65b9\u6848\u4e0d\u5b58\u5728\uff01");
            return Response.error((String)"\u65b9\u6848\u4e0d\u5b58\u5728\uff01");
        }
        return Response.ok((Object)frontScheme);
    }

    @ApiOperation(value="02.1-\u83b7\u53d6\u65b9\u6848\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u65b9\u6848key", required=true)})
    @GetMapping(value={"/detail"})
    public Response<FrontSchemeDTO> getDetailByKey(@RequestParam String key) {
        FrontSchemeDTO frontScheme = this.frontSchemeService.getDetailByKey(key);
        if (frontScheme == null) {
            log.error(key + "\u65b9\u6848\u4e0d\u5b58\u5728\uff01");
            return Response.error((String)"\u65b9\u6848\u4e0d\u5b58\u5728\uff01");
        }
        return Response.ok((Object)frontScheme);
    }

    @ApiOperation(value="03-\u65b0\u589e\u65b9\u6848")
    @PostMapping(value={""})
    public Response<String> add(@RequestBody FrontSchemeDTO schemeDTO) {
        return Response.ok((Object)this.frontSchemeService.add(schemeDTO));
    }

    @ApiOperation(value="04-\u4fee\u6539\u65b9\u6848")
    @PutMapping(value={""})
    public Response update(@RequestBody FrontSchemeDTO schemeDTO) {
        return Response.ok((Object)this.frontSchemeService.update(schemeDTO));
    }

    @ApiOperation(value="05-\u5220\u9664\u65b9\u6848")
    @ApiImplicitParams(value={@ApiImplicitParam(name="type", value="\u65b9\u6848\u7c7b\u578b\uff08\u4e0d\u540c\u529f\u80fd\u4f7f\u7528\u4e0d\u540c\u7c7b\u578b\uff0c\u53ef\u81ea\u884c\u5b9a\u4e49\uff09", required=true), @ApiImplicitParam(name="name", value="\u540d\u79f0", required=true)})
    @DeleteMapping(value={""})
    public Response deleteByName(@RequestParam String type, @RequestParam String name) {
        this.frontSchemeService.deleteByName(type, name);
        return Response.ok();
    }

    @ApiOperation(value="06-(\u63a8\u8350)\u5220\u9664\u65b9\u6848\uff08\u901a\u8fc7key\u5220\u9664\uff09")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6807\u8bc6", required=true)})
    @DeleteMapping(value={"/key"})
    public Response deleteByKey(@RequestParam String key) {
        this.frontSchemeService.deleteByKey(key);
        return Response.ok();
    }

    @ApiOperation(value="07-\u8c03\u6574\u65b9\u6848\u987a\u5e8f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="key", value="\u6807\u8bc6", required=true), @ApiImplicitParam(name="order", value="\u79fb\u52a8\u540e\u4e0a\u4e00\u4e2a\u5144\u5f1f\u8282\u70b9\u7684\u4f4d\u6b21\uff08\u4f4d\u6b21\u4ece1\u5f00\u59cb\uff0c\u6ca1\u6709\u4e0a\u4e2a\u5144\u5f1f\u8282\u70b9\u65f6\u6b64\u5904\u4e3a0\uff09", required=true)})
    @PostMapping(value={"/move"})
    public Response move(@RequestParam String key, @RequestParam Integer order) {
        this.frontSchemeService.move(key, order);
        return Response.ok();
    }
}

