/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.api.action.datasource;

import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.Response;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.dto.file.ObjectStorageBucketDTO;
import com.geoway.adf.dms.datasource.service.FileObjectStorageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/datasource/filestorage"})
@Api(tags={"01.04-\u6587\u4ef6\u5b58\u50a8-\u5bf9\u8c61\u5b58\u50a8"})
public class FileObjectStorageController {
    @Resource
    private FileObjectStorageService fileObjectStorageService;

    @ApiOperation(value="01-\u83b7\u53d6\u5bf9\u8c61\u5b58\u50a8\u4e0b\u7684\u6240\u6709\u6876")
    @PostMapping(value={"/bucket/list"})
    public Response<List<String>> listBucket(@RequestBody DataSourceDTO dataSource) {
        return Response.ok((Object)this.fileObjectStorageService.listObjectStorageBuckets(dataSource));
    }

    @ApiOperation(value="02-\u83b7\u53d6\u5bf9\u8c61\u5b58\u50a8\u6876\u4fe1\u606f")
    @ApiImplicitParam(name="dsKey", value="\u5b58\u50a8\u6570\u636e\u6e90\u6807\u8bc6", required=true)
    @GetMapping(value={"/bucket/info"})
    public Response<ObjectStorageBucketDTO> getBucketInfo(@RequestParam String dsKey) {
        return Response.ok((Object)this.fileObjectStorageService.getBucketInfo(dsKey));
    }

    @ApiOperation(value="03-\u751f\u6210\u4e34\u65f6GET\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u5b58\u50a8\u6570\u636e\u6e90\u6807\u8bc6", required=true), @ApiImplicitParam(name="filePath", value="\u6587\u4ef6\u8def\u5f84", required=true), @ApiImplicitParam(name="expirationSeconds", value="\u63a5\u53e3\u6709\u6548\u671f\uff0c\u5355\u4f4d\u79d2", defaultValue="3600"), @ApiImplicitParam(name="contentType", value="\u54cd\u5e94Content-Type")})
    @PostMapping(value={"/temporary/getUrl"})
    public Response<String> generatePresignedGetUrl(@RequestParam String dsKey, @RequestParam String filePath, @RequestParam(required=false) String contentType, @RequestParam(required=false, defaultValue="3600") Integer expirationSeconds) {
        HashMap<String, String> queryParams = null;
        if (!StringUtil.isEmptyOrWhiteSpace((String)contentType)) {
            queryParams = new HashMap<String, String>();
            queryParams.put("response-content-type", contentType);
        }
        return Response.ok((Object)this.fileObjectStorageService.generatePresignedGetUrl(dsKey, filePath, expirationSeconds.intValue(), null, queryParams));
    }

    @ApiOperation(value="04-\u751f\u6210\u4e34\u65f6PUT\u63a5\u53e3")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dsKey", value="\u5b58\u50a8\u6570\u636e\u6e90\u6807\u8bc6", required=true), @ApiImplicitParam(name="filePath", value="\u6587\u4ef6\u4e0a\u4f20\u540e\u5b58\u50a8\u8def\u5f84", required=true), @ApiImplicitParam(name="expirationSeconds", value="\u63a5\u53e3\u6709\u6548\u671f\uff0c\u5355\u4f4d\u79d2", defaultValue="3600"), @ApiImplicitParam(name="contentType", value="\u8bf7\u6c42\u5934Content-Type", defaultValue="application/octet-stream")})
    @PostMapping(value={"/temporary/putUrl"})
    public Response<String> generatePresignedPutUrl(@RequestParam String dsKey, @RequestParam String filePath, @RequestParam(required=false, defaultValue="application/octet-stream") String contentType, @RequestParam(required=false, defaultValue="3600") Integer expirationSeconds) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", contentType);
        return Response.ok((Object)this.fileObjectStorageService.generatePresignedPutUrl(dsKey, filePath, expirationSeconds.intValue(), headers, null));
    }
}

