/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.charts.service.impl;

import com.geoway.adf.dms.charts.check.ChartLicenseChecker;
import com.geoway.adf.dms.charts.dao.ChartSceneDao;
import com.geoway.adf.dms.charts.dao.ChartSceneVersionDao;
import com.geoway.adf.dms.charts.dto.ChartSceneDTO;
import com.geoway.adf.dms.charts.dto.ChartTypeEnum;
import com.geoway.adf.dms.charts.entity.ChartScene;
import com.geoway.adf.dms.charts.entity.ChartSceneVersion;
import com.geoway.adf.dms.charts.service.ChartSceneService;
import com.geoway.adf.dms.common.util.ListUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.dms.config.service.SysLogService;
import com.geoway.adf.gis.basic.RefObject;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Transactional(rollbackFor={Exception.class})
@Primary
@Service
public class ChartSceneServiceImpl
implements ChartSceneService {
    private static final Logger log = LoggerFactory.getLogger(ChartSceneServiceImpl.class);
    @Resource
    private ChartSceneDao chartSceneDao;
    @Resource
    private ChartSceneVersionDao chartSceneVersionDao;
    @Resource
    private ChartLicenseChecker chartLicenseChecker;
    @Resource
    private LoginUserService loginUserService;
    @Resource
    private SysLogService sysLogService;

    @Override
    public List<ChartSceneDTO> tree(Boolean withDataScene, String keyword) {
        List<ChartScene> allChartScenes = this.chartSceneDao.selectAll();
        Map<String, List<ChartScene>> allChartScenesMap = allChartScenes.stream().collect(Collectors.groupingBy(s -> s.getPid() == null ? "" : s.getPid()));
        RefObject sceneCount = new RefObject((Object)0);
        List<ChartSceneDTO> sceneDTOList = this.completeChildren(allChartScenesMap, null, keyword, withDataScene, (RefObject<Integer>)sceneCount);
        return sceneDTOList;
    }

    @Override
    public List<ChartSceneDTO> listScene(String pid, String keyword) {
        List<ChartScene> allChartScenes = this.chartSceneDao.selectAll();
        return this.getAllDataScene(allChartScenes, pid, keyword);
    }

    @Override
    public List<ChartSceneDTO> listSceneByIds(List<String> ids) {
        List<ChartScene> allChartScenes = this.chartSceneDao.selectByIds(ids);
        ArrayList<ChartSceneDTO> chartSceneDTOS = new ArrayList<ChartSceneDTO>();
        for (ChartScene entity : allChartScenes) {
            chartSceneDTOS.add(this.convertCharScene(entity));
        }
        return chartSceneDTOS;
    }

    @Override
    public ChartSceneDTO getDetail(String id) {
        ChartScene chartScene = this.chartSceneDao.selectByPrimaryKey(id);
        if (chartScene != null) {
            return this.convertCharScene(chartScene);
        }
        return null;
    }

    @Override
    public String saveScene(ChartScene chartScene) {
        this.chartLicenseChecker.check();
        boolean addVersion = true;
        if (StringUtil.isEmpty((String)chartScene.getId())) {
            Assert.notNull((Object)chartScene.getType(), (String)"\u672a\u8bbe\u7f6e\u573a\u666f\u7c7b\u578b");
            chartScene.setId(UUID.randomUUID().toString().replace("-", ""));
            chartScene.setCreateTime(new Date());
            this.checkSceneName(chartScene);
            if (StringUtil.isNotEmpty((String)chartScene.getPid())) {
                ChartScene parent = this.chartSceneDao.selectByPrimaryKey(chartScene.getPid());
                Assert.notNull((Object)parent, (String)"\u7236\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
                if (chartScene.getType().intValue() != ChartTypeEnum.Group.getValue() && parent.getType().intValue() != ChartTypeEnum.Group.getValue()) {
                    throw new RuntimeException("\u56fe\u8868\u573a\u666f\u53ea\u80fd\u5b58\u5728\u5206\u7c7b\u4e0b\uff01");
                }
            } else {
                chartScene.setPid(null);
            }
            Integer order = this.chartSceneDao.queryMaxOrder(chartScene.getPid());
            if (order == null) {
                order = 0;
            }
            chartScene.setOrder(order + 1);
            this.chartSceneDao.insert(chartScene);
        } else {
            ChartScene existChart = this.chartSceneDao.selectByPrimaryKey(chartScene.getId());
            Assert.notNull((Object)existChart, (String)"\u573a\u666f\u4e0d\u5b58\u5728\uff01");
            chartScene.setType(existChart.getType());
            chartScene.setPid(existChart.getPid());
            this.checkSceneName(chartScene);
            if (StringUtil.equals((String)chartScene.getConfig(), (String)existChart.getConfig())) {
                addVersion = false;
            }
            ChartSceneDTO updateChart = new ChartSceneDTO();
            updateChart.setId(chartScene.getId());
            updateChart.setName(chartScene.getName());
            updateChart.setDes(chartScene.getDes());
            updateChart.setConfig(chartScene.getConfig());
            updateChart.setPicture(chartScene.getPicture());
            updateChart.setLabels(chartScene.getLabels());
            this.chartSceneDao.updateByPrimaryKeySelective(updateChart);
        }
        if (ChartTypeEnum.Group.getValue() != chartScene.getType().intValue()) {
            if (addVersion) {
                try {
                    ChartSceneVersion chartSceneVersion = new ChartSceneVersion();
                    chartSceneVersion.setId(UUID.randomUUID().toString().replace("-", ""));
                    chartSceneVersion.setSceneId(chartScene.getId());
                    chartSceneVersion.setConfig(chartScene.getConfig());
                    chartSceneVersion.setVersionTime(new Date());
                    try {
                        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
                        LoginUserInfo loginUserInfo = this.loginUserService.getUserInfo(servletRequestAttributes.getRequest());
                        chartSceneVersion.setClientIP(loginUserInfo.getRequestRemoteAddr());
                        chartSceneVersion.setUserName(loginUserInfo.getUserName());
                    }
                    catch (Exception e) {
                        log.error("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Throwable)e);
                    }
                    this.chartSceneVersionDao.insert(chartSceneVersion);
                }
                catch (Exception e) {
                    log.error(chartScene.getId() + "\u4fdd\u5b58\u573a\u666f\u7248\u672c\u5931\u8d25", (Throwable)e);
                }
            }
            this.sysLogService.addLog(202, "\u4fdd\u5b58\u573a\u666f[" + chartScene.getName() + "]");
        }
        return chartScene.getId();
    }

    @Override
    public String addSceneGroup(ChartScene chartScene, boolean allowNameDuplicate) {
        chartScene.setType(ChartTypeEnum.Group.getValue());
        chartScene.setCreateTime(new Date());
        if (!allowNameDuplicate) {
            this.checkSceneName(chartScene);
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)chartScene.getId())) {
            chartScene.setId(UUID.randomUUID().toString().replace("-", ""));
        }
        if (StringUtil.isNotEmpty((String)chartScene.getPid())) {
            ChartScene parent = this.chartSceneDao.selectByPrimaryKey(chartScene.getPid());
            Assert.notNull((Object)parent, (String)"\u7236\u5206\u7c7b\u4e0d\u5b58\u5728\uff01");
        } else {
            chartScene.setPid(null);
        }
        Integer order = this.chartSceneDao.queryMaxOrder(chartScene.getPid());
        if (order == null) {
            order = 0;
        }
        chartScene.setOrder(order + 1);
        this.chartSceneDao.insert(chartScene);
        return chartScene.getId();
    }

    @Override
    public void deleteScene(String id) {
        this.chartLicenseChecker.check();
        ChartScene chartScene = this.chartSceneDao.selectByPrimaryKey(id);
        Assert.notNull((Object)chartScene, (String)"\u56fe\u8868\u573a\u666f\u4e0d\u5b58\u5728\uff01");
        if (chartScene.getType().intValue() == ChartTypeEnum.Group.getValue()) {
            List<ChartScene> allChartScenes = this.chartSceneDao.selectAll();
            List<String> subNodeIdList = this.getSubSceneIdList(allChartScenes, id);
            subNodeIdList.add(id);
            this.chartSceneDao.deleteByIdList(subNodeIdList);
            this.sysLogService.addLog(202, "\u5220\u9664\u573a\u666f\u5206\u7ec4[" + chartScene.getName() + "]");
        } else {
            this.chartSceneDao.deleteByPrimaryKey(id);
            this.sysLogService.addLog(202, "\u5220\u9664\u573a\u666f[" + chartScene.getName() + "]");
        }
    }

    @Override
    public void moveChartScene(String id, String pid, Integer order) {
        int i;
        List children;
        this.chartLicenseChecker.check();
        if (id == null || order == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        if (StringUtil.equals((String)id, (String)pid)) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u8282\u70b9\u672c\u8eab\u4e0b");
        }
        ChartScene chartScene = this.chartSceneDao.selectByPrimaryKey(id);
        Assert.notNull((Object)chartScene, (String)"\u56fe\u8868\u4e0d\u5b58\u5728\uff0c\u6b64\u6b21\u79fb\u52a8\u65e0\u6548");
        if (chartScene.getType().intValue() != ChartTypeEnum.Group.getValue() && StringUtil.isEmptyOrWhiteSpace((String)pid)) {
            throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u6839\u8282\u70b9\u4e0b");
        }
        if (StringUtil.isEmptyOrWhiteSpace((String)pid)) {
            pid = null;
        }
        if (!StringUtil.equals((String)chartScene.getPid(), (String)pid)) {
            List<ChartScene> allStatConfig = this.chartSceneDao.selectAll();
            List<String> subNodeIdList = this.getSubSceneIdList(allStatConfig, chartScene.getId());
            if (subNodeIdList.contains(pid)) {
                throw new RuntimeException("\u4e0d\u5141\u8bb8\u79fb\u52a8\u5230\u5b50\u8282\u70b9\u4e0b");
            }
            this.checkSceneName(chartScene);
            chartScene.setPid(pid);
            chartScene.setOrder(-1);
            this.chartSceneDao.updateOrderAndPid(chartScene.getId(), -1, pid);
            String finalPid = pid;
            children = ListUtil.findAll(allStatConfig, f -> StringUtil.equals((String)f.getPid(), (String)finalPid));
        } else {
            children = this.chartSceneDao.selectByPid(pid);
            children.removeIf(f -> StringUtil.equals((String)f.getId(), (String)id));
        }
        int preIndex = -1;
        for (i = 0; i < children.size(); ++i) {
            if (children.get(i).getOrder() != order) continue;
            preIndex = i;
            break;
        }
        if (preIndex == -1 && order > 0) {
            preIndex = order;
        }
        if (preIndex >= children.size()) {
            preIndex = children.size() - 1;
        }
        children.add(preIndex + 1, (ChartScene)chartScene);
        for (i = 0; i < children.size(); ++i) {
            ChartScene child = (ChartScene)children.get(i);
            if (child.getOrder() == i + 1) continue;
            child.setOrder(i + 1);
            this.chartSceneDao.updateOrderByPrimaryKey(child.getId(), child.getOrder());
        }
    }

    @Override
    public List<ChartSceneVersion> listChartSceneVersion(String sceneId) {
        PageHelper.startPage((int)1, (int)100);
        return this.chartSceneVersionDao.selectBySceneId(sceneId);
    }

    @Override
    public ChartSceneVersion getChartSceneVersion(String versionId) {
        return this.chartSceneVersionDao.selectByPrimaryKey(versionId);
    }

    private void checkSceneName(ChartScene chartScene) {
        List<ChartScene> existCharts = this.chartSceneDao.selectByName(chartScene.getName(), Objects.equals(ChartTypeEnum.Group.getValue(), chartScene.getType()), chartScene.getPid());
        if (existCharts.size() > 0 && ListUtil.exist(existCharts, c -> !c.getId().equals(chartScene.getId()))) {
            throw new RuntimeException("[" + chartScene.getName() + "]\u540d\u79f0\u5df2\u5b58\u5728\uff01");
        }
    }

    private List<ChartSceneDTO> completeChildren(Map<String, List<ChartScene>> allChartScenes, String pId, String keyword, Boolean withDataScene, RefObject<Integer> sceneCount) {
        ArrayList<ChartSceneDTO> chartSceneDTOS = new ArrayList<ChartSceneDTO>();
        List<ChartScene> subChartScenes = allChartScenes.get(pId == null ? "" : pId);
        if (subChartScenes == null) {
            return chartSceneDTOS;
        }
        for (ChartScene chart : subChartScenes) {
            RefObject subSceneCount = new RefObject((Object)0);
            List<ChartSceneDTO> subIndicators = this.completeChildren(allChartScenes, chart.getId(), keyword, withDataScene, (RefObject<Integer>)subSceneCount);
            ChartSceneDTO indicatorClassDTO = this.convertCharScene(chart);
            indicatorClassDTO.setConfig(null);
            if (!StringUtil.isEmpty((String)keyword) && !indicatorClassDTO.getName().toLowerCase().contains(keyword.toLowerCase()) && !indicatorClassDTO.getId().equals(keyword) && subIndicators.size() <= 0) continue;
            int sCount = (Integer)subSceneCount.get() + (int)subIndicators.stream().filter(s -> ChartTypeEnum.Group.getValue() != s.getType().intValue()).count();
            sceneCount.set((Object)((Integer)sceneCount.get() + sCount));
            if (!Boolean.TRUE.equals(withDataScene)) {
                subIndicators = subIndicators.stream().filter(s -> ChartTypeEnum.Group.getValue() == s.getType().intValue()).collect(Collectors.toList());
            }
            indicatorClassDTO.setChildren(subIndicators);
            indicatorClassDTO.setSceneCount(sCount);
            chartSceneDTOS.add(indicatorClassDTO);
        }
        return chartSceneDTOS;
    }

    private List<ChartSceneDTO> getAllDataScene(List<ChartScene> allChartScenes, String pId, String keyword) {
        ArrayList<ChartSceneDTO> childrenDTOS = new ArrayList<ChartSceneDTO>();
        List subChartScenes = ListUtil.findAll(allChartScenes, t -> StringUtil.equals((String)pId, (String)t.getPid()));
        for (ChartScene entity : subChartScenes) {
            if (entity.getType() == null || entity.getType().intValue() == ChartTypeEnum.Group.getValue()) {
                childrenDTOS.addAll(this.getAllDataScene(allChartScenes, entity.getId(), keyword));
                continue;
            }
            if (!StringUtil.isEmpty((String)keyword) && !entity.getName().toLowerCase().contains(keyword.toLowerCase()) && !entity.getId().equals(keyword)) continue;
            childrenDTOS.add(this.convertCharScene(entity));
        }
        return childrenDTOS;
    }

    private List<String> getSubSceneIdList(List<ChartScene> allChartScenes, String id) {
        List children = ListUtil.findAll(allChartScenes, f -> id.equals(f.getPid()));
        ArrayList<String> result = new ArrayList<String>();
        children.forEach(child -> {
            result.add(child.getId());
            result.addAll(this.getSubSceneIdList(allChartScenes, child.getId()));
        });
        return result;
    }

    private ChartSceneDTO convertCharScene(ChartScene chartScene) {
        ChartSceneDTO dto = new ChartSceneDTO();
        BeanUtils.copyProperties((Object)chartScene, (Object)dto);
        return dto;
    }
}

