/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.util;

import com.geoway.adf.dms.common.constant.MapScaleEnum;
import com.geoway.adf.dms.common.dto.MapNumber;
import org.apache.commons.lang3.StringUtils;

public class MapIDUtil {
    public static MapNumber getMapNumber(String strMapNo) {
        MapNumber mapNumber = new MapNumber();
        mapNumber.setMapNo(strMapNo);
        if (strMapNo.length() < 3) {
            mapNumber.setValid(false);
            return mapNumber;
        }
        strMapNo = strMapNo.trim().toUpperCase();
        boolean isNorth = true;
        if (strMapNo.startsWith("N")) {
            if (!MapIDUtil.isNumber(strMapNo.substring(1, 2))) {
                strMapNo = strMapNo.substring(1);
            }
        } else if (strMapNo.startsWith("S") && !MapIDUtil.isNumber(strMapNo.substring(1, 2))) {
            strMapNo = strMapNo.substring(1);
            isNorth = false;
        }
        MapScaleEnum iScale = MapScaleEnum.None;
        boolean isValid = false;
        if (strMapNo.length() == 3) {
            isValid = MapIDUtil.Valid100WMapNO(strMapNo);
            iScale = MapScaleEnum.W100;
        } else if (strMapNo.length() == 4) {
            isValid = MapIDUtil.Valid50WMapNO(strMapNo);
            iScale = MapScaleEnum.W050;
        } else if (strMapNo.length() == 10) {
            String sScale = strMapNo.substring(3, 4);
            int iRowCols = 0;
            switch (sScale) {
                case "A": {
                    iScale = MapScaleEnum.W100;
                    iRowCols = 1;
                    isValid = MapIDUtil.ValidOtherMapNO(strMapNo, iRowCols);
                    break;
                }
                case "B": {
                    iScale = MapScaleEnum.W050;
                    iRowCols = 2;
                    isValid = MapIDUtil.ValidOtherMapNO(strMapNo, iRowCols);
                    break;
                }
                case "C": {
                    iScale = MapScaleEnum.W025;
                    iRowCols = 4;
                    isValid = MapIDUtil.ValidOtherMapNO(strMapNo, iRowCols);
                    break;
                }
                case "D": {
                    iScale = MapScaleEnum.W010;
                    iRowCols = 12;
                    isValid = MapIDUtil.ValidOtherMapNO(strMapNo, iRowCols);
                    break;
                }
                case "E": {
                    iScale = MapScaleEnum.K050;
                    iRowCols = 24;
                    isValid = MapIDUtil.ValidOtherMapNO(strMapNo, iRowCols);
                    break;
                }
                case "F": {
                    iScale = MapScaleEnum.K025;
                    iRowCols = 48;
                    isValid = MapIDUtil.ValidOtherMapNO(strMapNo, iRowCols);
                    break;
                }
                case "G": {
                    iScale = MapScaleEnum.K010;
                    iRowCols = 96;
                    isValid = MapIDUtil.ValidOtherMapNO(strMapNo, iRowCols);
                    break;
                }
                case "H": {
                    iScale = MapScaleEnum.K005;
                    iRowCols = 192;
                    isValid = MapIDUtil.ValidOtherMapNO(strMapNo, iRowCols);
                    break;
                }
            }
        }
        mapNumber.setValid(isValid);
        mapNumber.setScale(iScale.getValue());
        if (isValid) {
            MapIDUtil.setZoneNO(mapNumber, strMapNo);
            MapIDUtil.setLBFormMapNum(mapNumber, strMapNo, isNorth);
        }
        return mapNumber;
    }

    static boolean Valid100WMapNO(String sMapNO) {
        int x = -9999;
        String strX = sMapNO.substring(1, 3);
        if (!MapIDUtil.isNumber(strX)) {
            return false;
        }
        x = Integer.parseInt(strX);
        if (x > 60) {
            return false;
        }
        char sChar = sMapNO.substring(0, 1).charAt(0);
        int y = sChar - 64;
        return y >= 1 && y <= 22;
    }

    static boolean Valid50WMapNO(String sMapNO) {
        String sTemp;
        return MapIDUtil.Valid100WMapNO(sMapNO) && ((sTemp = sMapNO.substring(3, 4)).equals("A") || sTemp.equals("B") || sTemp.equals("C") || sTemp.equals("D"));
    }

    static boolean ValidOtherMapNO(String sMapNO, int iRowCols) {
        if (!MapIDUtil.Valid100WMapNO(sMapNO)) {
            return false;
        }
        int row_num = 0;
        int col_num = 0;
        if (!MapIDUtil.isNumber(sMapNO.substring(4, 7))) {
            return false;
        }
        if (!MapIDUtil.isNumber(sMapNO.substring(7, 10))) {
            return false;
        }
        row_num = Integer.parseInt(sMapNO.substring(4, 7));
        col_num = Integer.parseInt(sMapNO.substring(7, 10));
        if (row_num < 1 || row_num > iRowCols) {
            return false;
        }
        return col_num >= 1 && col_num <= iRowCols;
    }

    private static void setZoneNO(MapNumber mapNumber, String sMapNO) {
        int iZoneNO = 9999;
        int iZoneWidth = 0;
        double dCentroidLongitude = 9999.0;
        sMapNO = sMapNO.trim();
        String sLongitude = sMapNO.substring(1, 3);
        int iLongitude = Integer.parseInt(sLongitude);
        double dLongitudeGap = 0.0;
        MapScaleEnum sScaleType = MapScaleEnum.getByValue(mapNumber.getScale());
        switch (sScaleType) {
            case W100: {
                dLongitudeGap = 21600.0;
                break;
            }
            case W050: {
                dLongitudeGap = 10800.0;
                break;
            }
            case W025: {
                dLongitudeGap = 5400.0;
                break;
            }
            case W010: {
                dLongitudeGap = 1800.0;
                break;
            }
            case K050: {
                dLongitudeGap = 900.0;
                break;
            }
            case K025: {
                dLongitudeGap = 450.0;
                break;
            }
            case K010: {
                dLongitudeGap = 225.0;
                break;
            }
            case K005: {
                dLongitudeGap = 112.5;
                break;
            }
        }
        int iColNO = 0;
        iColNO = sScaleType == MapScaleEnum.W100 ? 1 : (sScaleType == MapScaleEnum.W050 ? 2 : Integer.parseInt(sMapNO.substring(7, 10)));
        double dMapL = ((double)((iLongitude - 31) * 21600) + (double)(iColNO - 1) * dLongitudeGap) / 3600.0;
        if (sScaleType.equals("G") || sScaleType.equals("H") || sScaleType.equals("I")) {
            iZoneWidth = 3;
            iZoneNO = (int)(dMapL + 1.5) / 3;
            dCentroidLongitude = iZoneNO * 3;
        } else {
            iZoneWidth = 6;
            iZoneNO = (int)(dMapL + 6.0) / 6;
            dCentroidLongitude = iZoneNO * 6 - 3;
        }
        mapNumber.setZoneNumber(iZoneNO);
        mapNumber.setZoneWidth(iZoneWidth);
        mapNumber.setCentroidLongitude(dCentroidLongitude);
    }

    private static boolean setLBFormMapNum(MapNumber mapNumber, String strMapNo, boolean isNorth) {
        long lLongitudeGap100W;
        double pLongitude1 = 0.0;
        double pLongitude2 = 0.0;
        double pLatitude1 = 0.0;
        double pLatitude2 = 0.0;
        int y = 0;
        String y_s = strMapNo.substring(0, 1);
        String x_s = strMapNo.substring(1, 3);
        switch (y_s.toUpperCase()) {
            case "A": 
            case "1": {
                y = 1;
                break;
            }
            case "B": 
            case "2": {
                y = 2;
                break;
            }
            case "C": 
            case "3": {
                y = 3;
                break;
            }
            case "D": 
            case "4": {
                y = 4;
                break;
            }
            case "E": 
            case "5": {
                y = 5;
                break;
            }
            case "F": 
            case "6": {
                y = 6;
                break;
            }
            case "G": 
            case "7": {
                y = 7;
                break;
            }
            case "H": 
            case "8": {
                y = 8;
                break;
            }
            case "I": 
            case "9": {
                y = 9;
                break;
            }
            case "J": 
            case "10": {
                y = 10;
                break;
            }
            case "K": 
            case "11": {
                y = 11;
                break;
            }
            case "L": 
            case "12": {
                y = 12;
                break;
            }
            case "M": 
            case "13": {
                y = 13;
                break;
            }
            case "N": 
            case "14": {
                y = 14;
                break;
            }
            case "O": 
            case "15": {
                y = 15;
                break;
            }
            case "P": 
            case "16": {
                y = 16;
                break;
            }
            case "Q": 
            case "17": {
                y = 17;
                break;
            }
            case "R": 
            case "18": {
                y = 18;
                break;
            }
            case "S": 
            case "19": {
                y = 19;
                break;
            }
            case "T": 
            case "20": {
                y = 20;
                break;
            }
            case "U": 
            case "21": {
                y = 21;
                break;
            }
            case "V": 
            case "22": {
                y = 22;
                break;
            }
            default: {
                return false;
            }
        }
        int x = Integer.parseInt(x_s);
        if (x > 60) {
            return false;
        }
        switch (y) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                lLongitudeGap100W = 6L;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                lLongitudeGap100W = 12L;
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                lLongitudeGap100W = 24L;
                break;
            }
            default: {
                return false;
            }
        }
        long lLatitudeGap100W = 4L;
        long lRowsCols = 0L;
        int MapNumLen = strMapNo.trim().length();
        switch (MapNumLen) {
            case 3: 
            case 4: {
                lRowsCols = 1L;
                int pScale = 1000000;
                String sScale = "A";
                pLongitude1 = (x - 31) * 6;
                pLongitude2 = pLongitude1 + (double)lLongitudeGap100W;
                if (isNorth) {
                    pLatitude1 = (y - 1) * 4;
                    pLatitude2 = pLatitude1 + (double)lLatitudeGap100W;
                    break;
                }
                pLatitude1 = -(y - 1) * 4;
                pLatitude2 = pLatitude1 - (double)lLatitudeGap100W;
                break;
            }
            case 10: {
                String sScale = strMapNo.substring(3, 4);
                switch (sScale.toUpperCase()) {
                    case "A": {
                        lRowsCols = 1L;
                        int pScale = 1000000;
                        break;
                    }
                    case "B": {
                        lRowsCols = 2L;
                        int pScale = 500000;
                        break;
                    }
                    case "C": {
                        lRowsCols = 4L;
                        int pScale = 250000;
                        break;
                    }
                    case "D": {
                        lRowsCols = 12L;
                        int pScale = 100000;
                        break;
                    }
                    case "E": {
                        lRowsCols = 24L;
                        int pScale = 50000;
                        break;
                    }
                    case "F": {
                        lRowsCols = 48L;
                        int pScale = 25000;
                        break;
                    }
                    case "G": {
                        lRowsCols = 96L;
                        int pScale = 10000;
                        break;
                    }
                    case "H": {
                        lRowsCols = 192L;
                        int pScale = 5000;
                        break;
                    }
                }
                long row_num = Integer.parseInt(strMapNo.substring(4, 7));
                long col_num = Integer.parseInt(strMapNo.substring(7, 10));
                if (row_num < 1L || row_num > lRowsCols) {
                    return false;
                }
                if (col_num < 1L || col_num > lRowsCols) {
                    return false;
                }
                double JinCha = (double)lLongitudeGap100W * 3600.0 / (double)lRowsCols;
                double WeiCha = (double)lLatitudeGap100W * 3600.0 / (double)lRowsCols;
                pLongitude1 = (double)((x - 31) * 6) + (double)(col_num - 1L) * JinCha / 3600.0;
                pLongitude2 = pLongitude1 + JinCha / 3600.0;
                if (isNorth) {
                    pLatitude1 = (double)((y - 1) * 4 + 4) - (double)row_num * WeiCha / 3600.0;
                    pLatitude2 = pLatitude1 + WeiCha / 3600.0;
                    break;
                }
                pLatitude1 = -((double)((y - 1) * 4) + (double)(row_num - 1L) * WeiCha / 3600.0);
                pLatitude2 = pLatitude1 - WeiCha / 3600.0;
                break;
            }
        }
        mapNumber.setxMin(pLongitude1);
        mapNumber.setxMax(pLongitude2);
        mapNumber.setyMin(pLatitude1);
        mapNumber.setyMax(pLatitude2);
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("POLYGON(");
        strBuilder.append("(");
        strBuilder.append(pLongitude1);
        strBuilder.append(" ");
        strBuilder.append(pLatitude1);
        strBuilder.append(",");
        strBuilder.append(pLongitude2);
        strBuilder.append(" ");
        strBuilder.append(pLatitude1);
        strBuilder.append(",");
        strBuilder.append(pLongitude2);
        strBuilder.append(" ");
        strBuilder.append(pLatitude2);
        strBuilder.append(",");
        strBuilder.append(pLongitude1);
        strBuilder.append(" ");
        strBuilder.append(pLatitude2);
        strBuilder.append(",");
        strBuilder.append(pLongitude1);
        strBuilder.append(" ");
        strBuilder.append(pLatitude1);
        strBuilder.append(")");
        strBuilder.append(")");
        mapNumber.setGeometry(strBuilder.toString());
        return true;
    }

    public static boolean isNumber(String str) {
        int i;
        int start;
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        char[] chars = str.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] != 'e' && chars[i] != 'E') {
                if (chars[i] != '+' && chars[i] != '-') {
                    return false;
                }
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            if (hasExp) {
                return false;
            }
            if (!foundDigit) {
                return false;
            }
            hasExp = true;
            allowSigns = true;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] != 'e' && chars[i] != 'E') {
                if (chars[i] == '.') {
                    return !hasDecPoint && !hasExp ? foundDigit : false;
                }
                if (allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F') {
                    if (chars[i] != 'l' && chars[i] != 'L') {
                        return false;
                    }
                    return foundDigit && !hasExp && !hasDecPoint;
                }
                return foundDigit;
            }
            return false;
        }
        return !allowSigns && foundDigit;
    }
}

