/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.adf.dms.common.gis;

import com.geoway.adf.dms.common.config.UploadPathConfig;
import com.geoway.adf.dms.common.util.FileUtil;
import com.geoway.adf.gis.basic.geometry.IGeometry;
import com.geoway.adf.gis.geodb.IFeatureClass;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.adf.gis.geodb.cursor.IFeature;
import com.geoway.adf.gis.geodb.cursor.IFeatureCursor;
import com.geoway.adf.gis.geodb.excel.ExcelWorkspaceFactory;
import com.geoway.adf.gis.geodb.mdb.MDBJackessWorkspaceFactory;
import com.geoway.adf.gis.geodb.ogr.OgrWorkspaceFactory;
import com.geoway.adf.gis.raster.IRasterDataset;
import com.geoway.adf.gis.raster.RasterFileWorkspace;
import com.geoway.adf.gis.raster.info.RasterInfo;

public class WorkspaceUtil {
    public static IFeatureWorkspace openLocalFileGeodatabase(String filePath) {
        String fileFullPath = UploadPathConfig.getFullPath(filePath).toString();
        String ext = FileUtil.getExtension(filePath).toLowerCase();
        IFeatureWorkspace iWorkspace = null;
        iWorkspace = ext.equals(".mdb") ? new MDBJackessWorkspaceFactory().openWorkspace(fileFullPath, null, null, null) : (ext.equals(".xls") || ext.equals(".xlsx") || ext.equals(".csv") ? new ExcelWorkspaceFactory().openWorkspace(fileFullPath, null, null, null) : new OgrWorkspaceFactory().openWorkspace(fileFullPath, null, null, null));
        if (iWorkspace == null) {
            throw new RuntimeException("\u6587\u4ef6 [" + filePath + "] \u6253\u5f00\u5931\u8d25! ");
        }
        return iWorkspace;
    }

    public static IFeatureWorkspace createLocalFileGeodatabase(String filePath) {
        String ext = FileUtil.getExtension(filePath).toLowerCase();
        IFeatureWorkspace iWorkspace = null;
        iWorkspace = ext.equals(".mdb") ? new MDBJackessWorkspaceFactory().createWorkspace(filePath, null, null, null) : (ext.equals(".xls") || ext.equals(".xlsx") || ext.equals(".csv") ? new ExcelWorkspaceFactory().createWorkspace(filePath, null, null, null) : new OgrWorkspaceFactory().createLocalWorkspace(filePath));
        if (iWorkspace == null) {
            throw new RuntimeException("\u6587\u4ef6 [" + filePath + "] \u521b\u5efa\u5931\u8d25! ");
        }
        return iWorkspace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IGeometry readLocalFileGeometry(String localfile) {
        try (IFeatureWorkspace srcWorkspace = null;){
            String name = FileUtil.getFileNameWithoutExtension(localfile);
            srcWorkspace = WorkspaceUtil.openLocalFileGeodatabase(localfile);
            IFeatureClass featureClass = srcWorkspace.openFeatureClass(name);
            if (featureClass == null) {
                throw new RuntimeException(name + "\u56fe\u5c42\u6253\u5f00\u5931\u8d25");
            }
            IGeometry geometry = null;
            IFeatureCursor cursor = featureClass.searchFeature(null);
            IFeature feature = cursor.nextFeature();
            while (feature != null) {
                geometry = geometry == null ? feature.getGeometry() : geometry.union(feature.getGeometry());
                feature = cursor.nextFeature();
            }
            cursor.release();
            IGeometry iGeometry = geometry;
            return iGeometry;
        }
    }

    public static RasterInfo readRasterInfo(String rasterFile) {
        IRasterDataset rasterDataset = null;
        try {
            RasterFileWorkspace rasterWorkspace = new RasterFileWorkspace(rasterFile);
            rasterDataset = rasterWorkspace.openRasterDataset(rasterFile);
            if (rasterDataset != null) {
                RasterInfo rasterInfo = rasterDataset.getRasterInfo();
                return rasterInfo;
            }
            System.out.println(rasterFile);
            throw new RuntimeException("\u6805\u683c\u6587\u4ef6\u6253\u5f00\u5931\u8d25");
        }
        finally {
            if (rasterDataset != null) {
                rasterDataset.closeRaster();
            }
        }
    }
}

